/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.jre;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.debug.ui.jres.JREsPreferencePage;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.JREItem;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.requirement.inject.InjectRequirement;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.jre.JREConfiguration;
import org.eclipse.reddeer.requirements.jre.JRERequirement;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@JRERequirement.JRE
@RunWith(value=RedDeerSuite.class)
public class JRERequirementTest {
    @InjectRequirement
    JRERequirement requirement;

    @Test
    public void testConfigurationValues() {
        Assert.assertEquals((Object)"testName", (Object)((JREConfiguration)this.requirement.getConfiguration()).getName());
        Assert.assertEquals((String)"1.7", (Object)((JREConfiguration)this.requirement.getConfiguration()).getVersion(), (Object)"1.7");
        File file = new File(this.requirement.getPath());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isDirectory());
    }

    @Test
    public void testConfiguredValues() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        List jres = page.getJREs();
        Assert.assertTrue((boolean)this.matchJREs(jres, ((JREConfiguration)this.requirement.getConfiguration()).getName(), this.requirement.getPath()));
        Assert.assertFalse((boolean)page.getJREItem(((JREConfiguration)this.requirement.getConfiguration()).getName()).isDefault());
        dialog.cancel();
    }

    private boolean matchJREs(List<JREItem> items, String name, String path) {
        String absolutePath = new File(path).getAbsolutePath();
        for (JREItem item : items) {
            String absolutePath2 = new File(item.getLocation()).getAbsolutePath();
            if (!item.getName().equals(name) || !absolutePath.equals(absolutePath2)) continue;
            return true;
        }
        return false;
    }
}

