/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

abstract class AbstractTextZoomHandler
extends AbstractHandler {
    private static Map<String, String> fgFontToDefault;
    private static Map<String, Set<String>> fgDefaultToFonts;
    private int fFontSizeOffset;

    protected AbstractTextZoomHandler(int fontSizeOffset) {
        this.fFontSizeOffset = fontSizeOffset;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        AbstractTextEditor textEditor = this.getActiveTextEditor(event);
        if (textEditor == null) {
            return null;
        }
        FontRegistry fontRegistry = textEditor.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        String fontProperty = textEditor.getSymbolicFontName();
        if (fontProperty == null) {
            fontProperty = "org.eclipse.jface.textfont";
        }
        List<String> fontsToSet = this.getAffectedFontNames(fontProperty, fontRegistry);
        for (String fontName : fontsToSet) {
            FontData[] currentFontData = null;
            String currentFontName = fontName;
            while (currentFontName != null && (currentFontData = fontRegistry.getFontData(currentFontName)) == null) {
                currentFontName = fgFontToDefault.get(currentFontName);
            }
            FontData[] newFontData = this.createFontDescriptor(currentFontData).getFontData();
            if (newFontData == null) continue;
            fontRegistry.put(fontName, newFontData);
        }
        return Status.OK_STATUS;
    }

    private FontDescriptor createFontDescriptor(FontData[] initialFontData) {
        int destFontSize = initialFontData[0].getHeight() + this.fFontSizeOffset;
        if (destFontSize <= 0) {
            return FontDescriptor.createFrom((FontData[])initialFontData);
        }
        return FontDescriptor.createFrom((FontData[])initialFontData).setHeight(destFontSize);
    }

    private AbstractTextEditor getActiveTextEditor(ExecutionEvent event) {
        return this.getActiveTextEditor(HandlerUtil.getActiveEditor((ExecutionEvent)event));
    }

    private AbstractTextEditor getActiveTextEditor(IEditorPart part) {
        if (part instanceof AbstractTextEditor) {
            return (AbstractTextEditor)part;
        }
        if (part instanceof AbstractMultiEditor && ((AbstractMultiEditor)part).getActiveEditor() instanceof AbstractTextEditor) {
            return (AbstractTextEditor)((AbstractMultiEditor)part).getActiveEditor();
        }
        if (part instanceof MultiPageEditorPart && ((MultiPageEditorPart)part).getSelectedPage() instanceof AbstractTextEditor) {
            return (AbstractTextEditor)((MultiPageEditorPart)part).getSelectedPage();
        }
        return part != null ? (AbstractTextEditor)part.getAdapter(AbstractTextEditor.class) : null;
    }

    public void setEnabled(Object evaluationContext) {
        Object activeEditor;
        boolean enabled = false;
        if (evaluationContext instanceof IEvaluationContext && (activeEditor = ((IEvaluationContext)evaluationContext).getVariable("activeEditor")) instanceof IEditorPart) {
            enabled = this.getActiveTextEditor((IEditorPart)activeEditor) != null;
        }
        this.setBaseEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAffectedFontNames(String referenceFontName, FontRegistry fontRegistry) {
        Class<AbstractTextZoomHandler> clazz = AbstractTextZoomHandler.class;
        synchronized (AbstractTextZoomHandler.class) {
            String currentFontName;
            if (fgFontToDefault == null) {
                fgFontToDefault = new HashMap<String, String>();
                fgDefaultToFonts = new HashMap<String, Set<String>>();
                IConfigurationElement[] themeElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.themes");
                int i = 0;
                while (i < themeElements.length) {
                    IConfigurationElement extension = themeElements[i];
                    if ("fontDefinition".equals(extension.getName())) {
                        String fontId = extension.getAttribute("id");
                        String defaultsTo = extension.getAttribute("defaultsTo");
                        if (defaultsTo != null) {
                            fgFontToDefault.put(fontId, defaultsTo);
                            if (!fgDefaultToFonts.containsKey(defaultsTo)) {
                                fgDefaultToFonts.put(defaultsTo, new HashSet());
                            }
                            fgDefaultToFonts.get(defaultsTo).add(fontId);
                        }
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            String rootFontName = currentFontName = referenceFontName;
            do {
                if ((currentFontName = fgFontToDefault.get(currentFontName)) == null) continue;
                rootFontName = currentFontName;
            } while (currentFontName != null);
            LinkedHashSet<String> fontNames = new LinkedHashSet<String>();
            HashSet<String> alreadyProcessed = new HashSet<String>();
            LinkedList<String> fontsToProcess = new LinkedList<String>();
            fontsToProcess.add(rootFontName);
            while (!fontsToProcess.isEmpty()) {
                Set<String> children;
                currentFontName = (String)fontsToProcess.poll();
                if (alreadyProcessed.contains(currentFontName)) continue;
                alreadyProcessed.add(currentFontName);
                if (fontRegistry.hasValueFor(currentFontName)) {
                    fontNames.add(currentFontName);
                }
                if ((children = fgDefaultToFonts.get(currentFontName)) == null) continue;
                fontsToProcess.addAll(children);
            }
            ArrayList<String> result = new ArrayList<String>(fontNames);
            Collections.reverse(result);
            return result;
        }
    }
}

