/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.ViewComparator;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.internal.dialogs.ViewPatternFilter;

public class ShowViewDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "ShowViewDialog";
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 250;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "ShowViewDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_VIEW_ID = "ShowViewDialog.STORE_SELECTED_VIEW_ID";
    private FilteredTree filteredTree;
    private Color dimmedForeground;
    private Button okButton;
    private MApplication application;
    private MPartDescriptor[] viewDescs = new MPartDescriptor[0];
    private Label descriptionHint;
    private IEclipseContext context;
    private EModelService modelService;
    private MWindow window;
    private EPartService partService;

    public ShowViewDialog(Shell shell, MApplication application, MWindow window, EModelService modelService, EPartService partService, IEclipseContext context) {
        super(shell);
        this.application = application;
        this.window = window;
        this.modelService = modelService;
        this.partService = partService;
        this.context = context;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    protected void cancelPressed() {
        this.viewDescs = new MPartDescriptor[0];
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.ShowView_shellTitle);
        EHelpService helpService = (EHelpService)this.context.get(EHelpService.class);
        if (helpService != null) {
            helpService.setHelp((Object)shell, "org.eclipse.ui.show_view_dialog_context");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, WorkbenchMessages.ShowView_open_button_label, true);
        this.createButton(parent, 1, JFaceResources.getString((String)"cancel"), false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createFilteredTreeViewer(composite);
        this.layoutTopControl((Control)this.filteredTree);
        this.descriptionHint = new Label(composite, 64);
        this.descriptionHint.setText(WorkbenchMessages.ShowView_selectViewHelp);
        this.descriptionHint.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptionHint.setVisible(false);
        this.restoreWidgetValues();
        ShowViewDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = ShowViewDialog.blend(c1.red, c2.red, ratio);
        int g = ShowViewDialog.blend(c1.green, c2.green, ratio);
        int b = ShowViewDialog.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private void createFilteredTreeViewer(Composite parent) {
        Text filterText;
        ViewPatternFilter filter = new ViewPatternFilter();
        int styleBits = 2818;
        this.filteredTree = new FilteredTree(parent, styleBits, filter, true, true);
        this.filteredTree.setQuickSelectionMode(true);
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        TreeViewer treeViewer = this.filteredTree.getViewer();
        Control treeControl = treeViewer.getControl();
        RGB dimmedRGB = ShowViewDialog.blend(treeControl.getForeground().getRGB(), treeControl.getBackground().getRGB(), 60);
        this.dimmedForeground = new Color((Device)treeControl.getDisplay(), dimmedRGB);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this.context, this.modelService, this.partService, this.window, this.dimmedForeground));
        treeViewer.setContentProvider((IContentProvider)new ViewContentProvider(this.application));
        treeViewer.setComparator((ViewerComparator)new ViewComparator());
        treeViewer.setInput((Object)this.application);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ShowViewDialog.this.handleTreeViewerKeyPressed(e);
            }
        });
        if (this.hasAtMostOneView(this.filteredTree.getViewer()) && (filterText = this.filteredTree.getFilterControl()) != null) {
            filterText.setEnabled(false);
        }
    }

    private boolean hasAtMostOneView(TreeViewer tree) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)tree.getContentProvider();
        Object[] children = contentProvider.getElements(tree.getInput());
        if (children.length <= 1) {
            if (children.length == 0) {
                return true;
            }
            return !contentProvider.hasChildren(children[0]);
        }
        return false;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (this.filteredTree.getViewer().isExpandable(element)) {
            this.filteredTree.getViewer().setExpandedState(element, !this.filteredTree.getViewer().getExpandedState(element));
        } else if (this.viewDescs.length > 0) {
            this.saveWidgetValues();
            this.setReturnCode(0);
            this.close();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchSWTActivator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTING_SECTION_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTING_SECTION_NAME);
        }
        return section;
    }

    public MPartDescriptor[] getSelection() {
        return this.viewDescs;
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    protected void restoreWidgetValues() {
        String selectedPartId;
        IDialogSettings settings = this.getDialogSettings();
        Object[] expandedCategoryIds = settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryIds == null) {
            return;
        }
        if (expandedCategoryIds.length > 0) {
            this.filteredTree.getViewer().setExpandedElements(expandedCategoryIds);
        }
        if ((selectedPartId = settings.get(STORE_SELECTED_VIEW_ID)) != null) {
            List descriptors = this.application.getDescriptors();
            for (MPartDescriptor descriptor : descriptors) {
                if (!selectedPartId.equals(descriptor.getElementId())) continue;
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)descriptor), true);
                break;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        Object[] expandedElements = this.filteredTree.getViewer().getExpandedElements();
        String[] expandedCategoryIds = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedCategoryIds[i] = expandedElements[i] instanceof MPartDescriptor ? ((MPartDescriptor)expandedElements[i]).getElementId() : expandedElements[i].toString();
            ++i;
        }
        settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedCategoryIds);
        String selectedViewId = "";
        if (this.viewDescs.length > 0) {
            selectedViewId = this.viewDescs[0].getElementId();
        }
        settings.put(STORE_SELECTED_VIEW_ID, selectedViewId);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
        String tooltip = "";
        if (this.viewDescs.length > 0) {
            tooltip = this.viewDescs[0].getTooltip();
            tooltip = LocalizationHelper.getLocalized((String)tooltip, (MApplicationElement)this.viewDescs[0], (IEclipseContext)this.context);
        }
        boolean hasTooltip = tooltip != null && tooltip.length() > 0;
        this.descriptionHint.setVisible(this.viewDescs.length == 1 && hasTooltip);
    }

    protected void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getSelection().length > 0);
        }
    }

    protected void updateSelection(SelectionChangedEvent event) {
        ArrayList<MPartDescriptor> descs = new ArrayList<MPartDescriptor>();
        for (Object o : event.getStructuredSelection()) {
            if (!(o instanceof MPartDescriptor)) continue;
            descs.add((MPartDescriptor)o);
        }
        this.viewDescs = new MPartDescriptor[descs.size()];
        descs.toArray(this.viewDescs);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    void handleTreeViewerKeyPressed(KeyEvent event) {
        Object o;
        ITreeSelection selection;
        if (this.descriptionHint.isVisible() && event.keyCode == 0x100000B && event.stateMask == 0 && (selection = this.filteredTree.getViewer().getStructuredSelection()).size() == 1 && (o = selection.getFirstElement()) instanceof MPartDescriptor) {
            String description = ((MPartDescriptor)o).getTooltip();
            if ((description = LocalizationHelper.getLocalized((String)description, (MApplicationElement)((MPartDescriptor)o), (IEclipseContext)this.context)) != null && description.length() == 0) {
                description = WorkbenchMessages.ShowView_noDesc;
            }
            this.popUp(description);
        }
    }

    private void popUp(final String description) {
        new PopupDialog(this.filteredTree.getShell(), 540676, true, false, false, false, false, null, null){
            private static final int CURSOR_SIZE = 15;

            protected Point getInitialLocation(Point initialSize) {
                Display display = this.getShell().getDisplay();
                Point location = display.getCursorLocation();
                location.x += 15;
                location.y += 15;
                return location;
            }

            protected Control createDialogArea(Composite parent) {
                Label label = new Label(parent, 64);
                label.setText(description);
                label.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent event) {
                        this.close();
                    }
                });
                GridData gd = new GridData(1809);
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                label.setLayoutData((Object)gd);
                return label;
            }
        }.open();
    }

    protected boolean isResizable() {
        return true;
    }
}

