/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StatusInfo;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.sse.ui.preferences.AppearancePreferenceNames;

public class TextHoverPreferenceTab
extends AbstractPreferenceTab {
    private static final String DELIMITER = SSEUIMessages.TextHoverPreferenceTab_delimiter;
    private Text fDescription;
    private Table fHoverTable;
    private TableViewer fHoverTableViewer;
    private TableColumn fModifierColumn;
    private Text fModifierEditor;
    private TableColumn fNameColumn;
    private TextHoverManager.TextHoverDescriptor[] fTextHovers;

    public TextHoverPreferenceTab(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.setMainPreferencePage(mainPreferencePage);
        this.setOverlayStore(store);
        this.getOverlayStore().addKeys(this.createOverlayStoreKeys());
    }

    @Override
    public Control createContents(Composite tabFolder) {
        int heightHint;
        Composite hoverComposite = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        hoverComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        hoverComposite.setLayoutData((Object)gd);
        Label label = new Label(hoverComposite, 0);
        label.setText(SSEUIMessages.TextHoverPreferenceTab_hoverPreferences);
        gd = new GridData(4, 4, true, false, 2, 1);
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fHoverTableViewer = CheckboxTableViewer.newCheckList((Composite)hoverComposite, (int)68354);
        this.fHoverTable = this.fHoverTableViewer.getTable();
        this.fHoverTable.setHeaderVisible(true);
        this.fHoverTable.setLinesVisible(true);
        gd = new GridData(4, 4, true, false, 2, 1);
        GC gc = new GC((Drawable)this.fHoverTable);
        gc.setFont(this.fHoverTable.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gd.heightHint = heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)7);
        this.fHoverTable.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 140, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 140, true));
        this.fHoverTable.setLayout((Layout)tableLayout);
        this.fHoverTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextHoverPreferenceTab.this.handleHoverListSelection();
            }
        });
        this.fNameColumn = new TableColumn(this.fHoverTable, 0);
        this.fNameColumn.setText(SSEUIMessages.TextHoverPreferenceTab_nameColumnTitle);
        this.fNameColumn.setResizable(true);
        this.fModifierColumn = new TableColumn(this.fHoverTable, 0);
        this.fModifierColumn.setText(SSEUIMessages.TextHoverPreferenceTab_modifierColumnTitle);
        this.fModifierColumn.setResizable(true);
        this.fHoverTableViewer.setUseHashlookup(true);
        this.fHoverTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fHoverTableViewer.setLabelProvider((IBaseLabelProvider)new InternalTableLabelProvider());
        ((CheckboxTableViewer)this.fHoverTableViewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String id = ((TextHoverManager.TextHoverDescriptor)event.getElement()).getId();
                if (id == null) {
                    return;
                }
                TextHoverManager.TextHoverDescriptor[] descriptors = TextHoverPreferenceTab.this.getTextHoverManager().getTextHovers();
                TextHoverManager.TextHoverDescriptor hoverConfig = null;
                int i = 0;
                int length = TextHoverPreferenceTab.this.fTextHovers.length;
                while (i < length) {
                    if (id.equals(descriptors[i].getId())) {
                        hoverConfig = TextHoverPreferenceTab.this.fTextHovers[i];
                        hoverConfig.setEnabled(event.getChecked());
                        TextHoverPreferenceTab.this.fModifierEditor.setEnabled(event.getChecked());
                        TextHoverPreferenceTab.this.fHoverTableViewer.setSelection((ISelection)new StructuredSelection((Object)descriptors[i]));
                    }
                    ++i;
                }
                TextHoverPreferenceTab.this.handleHoverListSelection();
                TextHoverPreferenceTab.this.updateStatus(hoverConfig);
            }
        });
        label = new Label(hoverComposite, 16384);
        label.setText(SSEUIMessages.TextHoverPreferenceTab_keyModifier);
        this.fModifierEditor = new Text(hoverComposite, 2048);
        gd = new GridData(256);
        this.fModifierEditor.setLayoutData((Object)gd);
        this.fModifierEditor.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String text = TextHoverPreferenceTab.this.fModifierEditor.getText();
                    Point selection = TextHoverPreferenceTab.this.fModifierEditor.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(text.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    i = selection.y;
                    while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < text.length() && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_insertDelimiterAndModifierAndDelimiter, (Object[])new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_insertDelimiterAndModifier, (Object[])new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_insertModifierAndDelimiter, (Object[])new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                    if (insertString != null) {
                        TextHoverPreferenceTab.this.fModifierEditor.insert(insertString);
                    }
                }
            }
        });
        this.fModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextHoverPreferenceTab.this.handleModifierModified();
            }
        });
        Label descriptionLabel = new Label(hoverComposite, 16384);
        descriptionLabel.setText(SSEUIMessages.TextHoverPreferenceTab_description);
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)gd);
        this.fDescription = new Text(hoverComposite, 18506);
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gd);
        new Label(hoverComposite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.addCheckBox(hoverComposite, SSEUIMessages.TextHoverPreferenceTab_generic, "prefer_generic_hover", 0);
        this.initialize();
        Dialog.applyDialogFont((Control)hoverComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)hoverComposite, "org.eclipse.wst.sse.ui.sted0003");
        return hoverComposite;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, AppearancePreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "prefer_generic_hover"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String generateTextHoverString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fTextHovers.length) {
            buf.append(this.fTextHovers[i].getId());
            buf.append("|");
            buf.append(Boolean.toString(this.fTextHovers[i].isEnabled()));
            buf.append("|");
            String modifier = this.fTextHovers[i].getModifierString();
            if (modifier == null || modifier.length() == 0) {
                modifier = "0";
            }
            buf.append(modifier);
            buf.append(";");
            ++i;
        }
        return buf.toString();
    }

    private TextHoverManager getTextHoverManager() {
        return SSEUIPlugin.getDefault().getTextHoverManager();
    }

    @Override
    public String getTitle() {
        return SSEUIMessages.TextHoverPreferenceTab_title;
    }

    void handleHoverListSelection() {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            if (this.fHoverTable.getSelectionCount() == 0) {
                this.fModifierEditor.setEnabled(false);
            }
            return;
        }
        boolean enabled = this.fTextHovers[i].isEnabled();
        this.fModifierEditor.setEnabled(enabled);
        this.fModifierEditor.setText(this.fTextHovers[i].getModifierString());
        String description = this.fTextHovers[i].getDescription();
        if (description == null) {
            description = "";
        }
        this.fDescription.setText(description);
    }

    private void handleModifierModified() {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String modifiers = this.fModifierEditor.getText();
        this.fTextHovers[i].setModifierString(modifiers);
        this.fHoverTableViewer.refresh((Object)this.fTextHovers[i]);
        this.updateStatus(this.fTextHovers[i]);
    }

    private void initialize() {
        this.restoreFromOverlay();
        this.fHoverTableViewer.setInput((Object)this.fTextHovers);
        this.initializeFields();
    }

    @Override
    protected void initializeFields() {
        super.initializeFields();
        this.fModifierEditor.setEnabled(false);
        int i = 0;
        while (i < this.fTextHovers.length) {
            this.fHoverTable.getItem(i).setChecked(this.fTextHovers[i].isEnabled());
            ++i;
        }
        this.fHoverTableViewer.refresh();
    }

    @Override
    public void performApply() {
        this.performOk();
    }

    @Override
    public void performDefaults() {
        this.initialize();
    }

    @Override
    public void performOk() {
        String textHoverString = this.generateTextHoverString();
        this.getOverlayStore().setValue(AppearancePreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS, textHoverString);
        this.getTextHoverManager().resetTextHovers();
    }

    private void restoreFromOverlay() {
        String descriptorsString = this.getOverlayStore().getString(AppearancePreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS);
        this.fTextHovers = this.getTextHoverManager().generateTextHoverDescriptors(descriptorsString);
    }

    void updateStatus(TextHoverManager.TextHoverDescriptor hoverConfig) {
        StatusInfo status = new StatusInfo();
        if (hoverConfig != null && hoverConfig.isEnabled() && EditorUtility.computeStateMask(hoverConfig.getModifierString()) == -1) {
            status = new StatusInfo(4, NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_modifierIsNotValid, (Object[])new String[]{hoverConfig.getModifierString()}));
        }
        int i = 0;
        HashMap<Integer, String> stateMasks = new HashMap<Integer, String>(this.fTextHovers.length);
        while (status.isOK() && i < this.fTextHovers.length) {
            if (this.fTextHovers[i].isEnabled()) {
                String label = this.fTextHovers[i].getLabel();
                Integer stateMask = new Integer(EditorUtility.computeStateMask(this.fTextHovers[i].getModifierString()));
                if (stateMask == -1) {
                    status = new StatusInfo(4, NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_modifierIsNotValidForHover, (Object[])new String[]{this.fTextHovers[i].getModifierString(), label}));
                } else if (stateMasks.containsKey(stateMask)) {
                    status = new StatusInfo(4, NLS.bind((String)SSEUIMessages.TextHoverPreferenceTab_duplicateModifier, (Object[])new String[]{label, (String)stateMasks.get(stateMask)}));
                } else {
                    stateMasks.put(stateMask, label);
                }
            }
            ++i;
        }
        this.updateStatus(status);
    }

    private class InternalTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((TextHoverManager.TextHoverDescriptor)element).getLabel();
                }
                case 1: {
                    return ((TextHoverManager.TextHoverDescriptor)element).getModifierString();
                }
            }
            return null;
        }
    }
}

