/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.DebugInfoHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;

public class BestMatchHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private ITextHover fBestMatchHover;
    private ITextHover[] fTagInfoHovers;
    private List<ITextHover> fTextHovers;
    private String fPartitionType;
    private ITextHover controlCreatorProvider;
    private Set<IContentType> fDetectedContentTypes;

    public BestMatchHover(ITextHover infoTagHover) {
        this(new ITextHover[]{infoTagHover});
    }

    public BestMatchHover(ITextHover[] infoTagHovers) {
        this.fTagInfoHovers = infoTagHovers;
    }

    public BestMatchHover(String partitionType) {
        this.fPartitionType = partitionType;
    }

    private List<ITextHover> createTextHoversList(ITextViewer textViewer) {
        ArrayList<ITextHover> hoverList = new ArrayList<ITextHover>();
        if (Logger.isTracing("debuginfohover")) {
            hoverList.add(new DebugInfoHoverProcessor());
        }
        hoverList.add(new ProblemAnnotationHoverProcessor());
        if (this.fPartitionType != null && this.fTagInfoHovers == null) {
            List<ITextHover> extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", this.fPartitionType);
            this.fTagInfoHovers = extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
        }
        if (this.fTagInfoHovers != null) {
            int i = 0;
            while (i < this.fTagInfoHovers.length) {
                hoverList.add(this.fTagInfoHovers[i]);
                ++i;
            }
        }
        hoverList.add(new AnnotationHoverProcessor());
        if (SSEUIPlugin.getInstance().getPreferenceStore().getBoolean("prefer_generic_hover")) {
            Set<IContentType> detectedContentTypes = this.detectContentTypes(textViewer);
            if (textViewer instanceof ISourceViewer && detectedContentTypes != null) {
                List genericHovers = GenericEditorPlugin.getDefault().getHoverRegistry().getAvailableHovers((ISourceViewer)textViewer, null, detectedContentTypes);
                hoverList.addAll(0, genericHovers);
            }
        }
        return hoverList;
    }

    private Set<IContentType> detectContentTypes(ITextViewer viewer) {
        if (this.fDetectedContentTypes == null) {
            ITextFileBuffer textFileBuffer;
            HashSet<IContentType> types = new HashSet<IContentType>();
            IDocument currentDocument = viewer.getDocument();
            if (currentDocument != null && (textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(currentDocument)) != null) {
                IContentType[] foundTypes = Platform.getContentTypeManager().findContentTypesFor(textFileBuffer.getLocation().lastSegment());
                int i = 0;
                while (i < foundTypes.length) {
                    IContentType type = foundTypes[i];
                    while (type != null) {
                        types.add(type);
                        type = type.getBaseType();
                    }
                    ++i;
                }
            }
            this.fDetectedContentTypes = types;
        }
        return this.fDetectedContentTypes;
    }

    public IInformationControlCreator getHoverControlCreator() {
        IInformationControlCreator creator = null;
        if (this.controlCreatorProvider instanceof ITextHoverExtension) {
            creator = ((ITextHoverExtension)this.controlCreatorProvider).getHoverControlCreator();
        } else if (this.fBestMatchHover instanceof ITextHoverExtension) {
            creator = ((ITextHoverExtension)this.fBestMatchHover).getHoverControlCreator();
        }
        return creator;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        String displayText = null;
        this.controlCreatorProvider = null;
        if (this.fBestMatchHover != null) {
            displayText = this.fBestMatchHover.getHoverInfo(viewer, hoverRegion);
        }
        if (displayText == null) {
            Iterator<ITextHover> i = this.getTextHovers(viewer).iterator();
            while (i.hasNext() && displayText == null) {
                ITextHover hover = i.next();
                displayText = hover.getHoverInfo(viewer, hoverRegion);
                if (displayText == null) continue;
                this.controlCreatorProvider = hover;
            }
        } else {
            this.controlCreatorProvider = this.fBestMatchHover;
        }
        return displayText;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        Object information = null;
        this.controlCreatorProvider = null;
        if (this.fBestMatchHover instanceof ITextHoverExtension2) {
            information = ((ITextHoverExtension2)this.fBestMatchHover).getHoverInfo2(textViewer, hoverRegion);
        } else if (this.fBestMatchHover != null) {
            information = this.fBestMatchHover.getHoverInfo(textViewer, hoverRegion);
        }
        if (information == null) {
            Iterator<ITextHover> i = this.getTextHovers(textViewer).iterator();
            while (i.hasNext() && information == null) {
                ITextHover hover = i.next();
                if (hover == this.fBestMatchHover || (information = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, hoverRegion) : hover.getHoverInfo(textViewer, hoverRegion)) == null) continue;
                this.controlCreatorProvider = hover;
            }
        } else {
            this.controlCreatorProvider = this.fBestMatchHover;
        }
        return information;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        IRegion hoverRegion = null;
        ITextHover hover = null;
        Iterator<ITextHover> i = this.getTextHovers(viewer).iterator();
        while (i.hasNext() && hoverRegion == null) {
            hover = i.next();
            hoverRegion = hover.getHoverRegion(viewer, offset);
        }
        this.fBestMatchHover = hoverRegion != null ? hover : null;
        return hoverRegion;
    }

    private List<ITextHover> getTextHovers(ITextViewer viewer) {
        if (this.fTextHovers == null) {
            this.fTextHovers = this.createTextHoversList(viewer);
        }
        return this.fTextHovers;
    }
}

