/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.io.Serializable;
import org.mockito.mock.MockName;

public class MockNameImpl
implements MockName,
Serializable {
    private static final long serialVersionUID = 8014974700844306925L;
    private final String mockName;
    private boolean defaultName;

    public MockNameImpl(String mockName, Class<?> classToMock) {
        if (mockName == null) {
            this.mockName = MockNameImpl.toInstanceName(classToMock);
            this.defaultName = true;
        } else {
            this.mockName = mockName;
        }
    }

    public MockNameImpl(String mockName) {
        this.mockName = mockName;
    }

    private static String toInstanceName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    @Override
    public boolean isDefault() {
        return this.defaultName;
    }

    @Override
    public String toString() {
        return this.mockName;
    }
}

