/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorInputFactory;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStringStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class SQLEditorStorageEditorInput
implements IStorageEditorInput,
ISQLEditorInput,
IPersistableElement {
    private ISQLEditorConnectionInfo fConnInfo;
    private String fName;
    private IStorage fStorage;

    public SQLEditorStorageEditorInput(String name, String storageSource) {
        this((IStorage)new SQLEditorStringStorage(name, storageSource));
    }

    public SQLEditorStorageEditorInput(IStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException();
        }
        this.setStorage(storage);
        this.setName(storage.getName());
        this.setConnectionInfo(null);
    }

    public boolean exists() {
        return this.fStorage != null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        return this.fStorage;
    }

    public String getToolTipText() {
        StringBuffer sb = new StringBuffer(30);
        if (this.fConnInfo != null && this.fConnInfo.getConnectionProfile() != null) {
            sb.append(this.fConnInfo.getConnectionProfile().getName());
            sb.append("/");
        }
        sb.append(this.fName);
        return sb.toString();
    }

    public String getFactoryId() {
        return "org.eclipse.datatools.sqltools.sqleditor.SQLEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        SQLEditorInputFactory.saveState(memento, this);
    }

    @Override
    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setStorage(IStorage storage) {
        this.fStorage = storage;
    }

    @Override
    public boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getClass().getName()) + "(" + this.fName + ")";
    }
}

