/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.di;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public abstract class UISynchronize {
    public abstract void syncExec(Runnable var1);

    public abstract void asyncExec(Runnable var1);

    protected abstract boolean isUIThread(Thread var1);

    protected abstract void showBusyWhile(Runnable var1);

    protected abstract boolean dispatchEvents();

    public void exec(Runnable action) {
        Thread thread = Thread.currentThread();
        if (this.isUIThread(thread)) {
            action.run();
        } else {
            this.syncExec(action);
        }
    }

    public <T> T call(Callable<T> action) throws InterruptedException, ExecutionException {
        Thread thread = Thread.currentThread();
        if (this.isUIThread(thread)) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                throw new ExecutionException(e);
            }
        }
        FutureTask<T> task = new FutureTask<T>(action);
        try {
            this.syncExec(task);
        }
        catch (RuntimeException e) {
            throw new ExecutionException(e);
        }
        return task.get();
    }

    public void busyExec(Runnable action) throws InterruptedException {
        try {
            this.busyCall(() -> {
                action.run();
                return null;
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public <T> T busyCall(Callable<T> action) throws InterruptedException, ExecutionException {
        Objects.requireNonNull(action);
        FutureTask<T> task = new FutureTask<T>(action);
        Thread thread = Thread.currentThread();
        if (this.isUIThread(thread)) {
            Future fork = ForkJoinPool.commonPool().submit(task);
            this.showBusyWhile(() -> this.lambda$1((ForkJoinTask)fork));
        } else {
            task.run();
        }
        return task.get();
    }

    private /* synthetic */ void lambda$1(ForkJoinTask forkJoinTask) {
        while (!forkJoinTask.isDone() && !Thread.currentThread().isInterrupted()) {
            if (this.dispatchEvents()) continue;
            Thread.yield();
        }
    }
}

