/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;

public class FontShorthandAdapter
implements IShorthandAdapter {
    @Override
    public boolean expand(String source, CSSPropertyContext dest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return false;
        }
        String style = null;
        String variant = null;
        String weight = null;
        String size = null;
        String height = null;
        String family = null;
        PropCMProperty propFont = PropCMProperty.getInstanceOf("font");
        PropCMProperty propStyle = PropCMProperty.getInstanceOf("font-style");
        PropCMProperty propVariant = PropCMProperty.getInstanceOf("font-variant");
        PropCMProperty propWeight = PropCMProperty.getInstanceOf("font-weight");
        PropCMProperty propSize = PropCMProperty.getInstanceOf("font-size");
        boolean bNormalSpecified = false;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (i == 0) {
                    int j = 0;
                    while (j < propFont.getNumChild()) {
                        Object obj = propFont.getChildAt(i);
                        if (obj instanceof String && tokens[i].image.compareToIgnoreCase(obj.toString()) == 0) {
                            return false;
                        }
                        ++j;
                    }
                }
                if (tokens[i].image.equalsIgnoreCase("normal")) {
                    bNormalSpecified = true;
                } else if (propStyle.canHave(tokens[i].image)) {
                    style = tokens[i].image;
                } else if (propVariant.canHave(tokens[i].image)) {
                    variant = tokens[i].image;
                } else if (propWeight.canHave(tokens[i].image)) {
                    weight = tokens[i].image;
                } else if (propSize.canHave(tokens[i].image)) {
                    size = tokens[i].image;
                    break;
                }
            } else if (tokens[i].kind == "DECLARATION_VALUE_NUMBER" && weight == null && propWeight.canHave(tokens[i].image)) {
                weight = tokens[i].image;
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE") {
                size = tokens[i].image;
                break;
            }
            ++i;
        }
        if (bNormalSpecified) {
            if (style == null) {
                style = "normal";
            }
            if (variant == null) {
                variant = "normal";
            }
            if (weight == null) {
                weight = "normal";
            }
        }
        ++i;
        while (i < tokens.length) {
            if (tokens[i].kind != "S" || tokens[i].kind != "DECLARATION_VALUE_S") break;
            ++i;
        }
        if (i < tokens.length && tokens[i].kind == "DECLARATION_VALUE_OPERATOR" && tokens[i].image.equals("/")) {
            ++i;
            while (i < tokens.length) {
                if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE" || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                    height = tokens[i++].image;
                    break;
                }
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        while (i < tokens.length) {
            if (tokens[i].kind == "COMMENT") {
                buf.append(" ");
            } else {
                buf.append(tokens[i].image);
            }
            ++i;
        }
        family = buf.toString().trim();
        dest.set("font-style", style);
        dest.set("font-variant", variant);
        dest.set("font-weight", weight);
        dest.set("font-size", size);
        dest.set("line-height", height);
        dest.set("font-family", family);
        return true;
    }

    @Override
    public String extract(String source, PropCMProperty propDest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return null;
        }
        String style = null;
        String variant = null;
        String weight = null;
        String size = null;
        String height = null;
        String family = null;
        PropCMProperty propFont = PropCMProperty.getInstanceOf("font");
        PropCMProperty propStyle = PropCMProperty.getInstanceOf("font-style");
        PropCMProperty propVariant = PropCMProperty.getInstanceOf("font-variant");
        PropCMProperty propWeight = PropCMProperty.getInstanceOf("font-weight");
        PropCMProperty propSize = PropCMProperty.getInstanceOf("font-size");
        PropCMProperty propHeight = PropCMProperty.getInstanceOf("line-height");
        PropCMProperty propFamily = PropCMProperty.getInstanceOf("font-family");
        boolean bNormalSpecified = false;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (i == 0) {
                    int j = 0;
                    while (j < propFont.getNumChild()) {
                        Object obj = propFont.getChildAt(i);
                        if (obj instanceof String && tokens[i].image.compareToIgnoreCase(obj.toString()) == 0) {
                            return null;
                        }
                        ++j;
                    }
                }
                if (tokens[i].image.equalsIgnoreCase("normal")) {
                    bNormalSpecified = true;
                } else if (propStyle.canHave(tokens[i].image)) {
                    style = tokens[i].image;
                } else if (propVariant.canHave(tokens[i].image)) {
                    variant = tokens[i].image;
                } else if (propWeight.canHave(tokens[i].image)) {
                    weight = tokens[i].image;
                } else if (propSize.canHave(tokens[i].image)) {
                    size = tokens[i].image;
                    break;
                }
            } else if (tokens[i].kind == "DECLARATION_VALUE_NUMBER" && weight == null && propWeight.canHave(tokens[i].image)) {
                weight = tokens[i].image;
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE") {
                size = tokens[i].image;
                break;
            }
            ++i;
        }
        if (bNormalSpecified) {
            if (style == null) {
                style = "normal";
            }
            if (variant == null) {
                variant = "normal";
            }
            if (weight == null) {
                weight = "normal";
            }
        }
        ++i;
        while (i < tokens.length) {
            if (tokens[i].kind != "S" || tokens[i].kind != "DECLARATION_VALUE_S") break;
            ++i;
        }
        if (i < tokens.length && tokens[i].kind == "DECLARATION_VALUE_OPERATOR" && tokens[i].image.equals("/")) {
            ++i;
            while (i < tokens.length) {
                if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE" || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                    height = tokens[i++].image;
                    break;
                }
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        while (i < tokens.length) {
            if (tokens[i].kind == "COMMENT") {
                buf.append(" ");
            } else {
                buf.append(tokens[i].image);
            }
            ++i;
        }
        family = buf.toString().trim();
        if (propStyle == propDest) {
            return style;
        }
        if (propVariant == propDest) {
            return variant;
        }
        if (propWeight == propDest) {
            return weight;
        }
        if (propSize == propDest) {
            return size;
        }
        if (propHeight == propDest) {
            return height;
        }
        if (propFamily == propDest) {
            return family;
        }
        return null;
    }
}

