/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.Hashtable;
import org.eclipse.core.internal.resources.CheckMissingNaturesListener;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ResourcesPlugin
extends Plugin {
    public static final String PI_RESOURCES = "org.eclipse.core.resources";
    public static final String PT_BUILDERS = "builders";
    public static final String PT_NATURES = "natures";
    public static final String PT_MARKERS = "markers";
    public static final String PT_FILE_MODIFICATION_VALIDATOR = "fileModificationValidator";
    public static final String PT_MOVE_DELETE_HOOK = "moveDeleteHook";
    public static final String PT_TEAM_HOOK = "teamHook";
    public static final String PT_REFRESH_PROVIDERS = "refreshProviders";
    public static final String PT_MODEL_PROVIDERS = "modelProviders";
    public static final String PT_VARIABLE_PROVIDERS = "variableResolvers";
    public static final String PT_FILTER_MATCHERS = "filterMatchers";
    public static final Object FAMILY_AUTO_BUILD = new Object();
    public static final Object FAMILY_AUTO_REFRESH = new Object();
    public static final Object FAMILY_MANUAL_BUILD = new Object();
    public static final Object FAMILY_MANUAL_REFRESH = new Object();
    public static final String PREF_ENCODING = "encoding";
    private static final String PREF_DESCRIPTION_PREFIX = "description.";
    @Deprecated
    public static final String PREF_MAX_NOTIFICATION_DELAY = "maxnotifydelay";
    public static final String PREF_AUTO_BUILDING = "description.autobuilding";
    public static final String PREF_BUILD_ORDER = "description.buildorder";
    public static final String PREF_DEFAULT_BUILD_ORDER = "description.defaultbuildorder";
    public static final String PREF_MAX_BUILD_ITERATIONS = "description.maxbuilditerations";
    public static final String PREF_APPLY_FILE_STATE_POLICY = "description.applyfilestatepolicy";
    public static final String PREF_FILE_STATE_LONGEVITY = "description.filestatelongevity";
    public static final String PREF_MAX_FILE_STATE_SIZE = "description.maxfilestatesize";
    public static final String PREF_MAX_FILE_STATES = "description.maxfilestates";
    public static final String PREF_SNAPSHOT_INTERVAL = "description.snapshotinterval";
    public static final String PREF_DISABLE_LINKING = "description.disableLinking";
    public static final String PREF_AUTO_REFRESH = "refresh.enabled";
    public static final String PREF_LIGHTWEIGHT_AUTO_REFRESH = "refresh.lightweight.enabled";
    public static final String PREF_SEPARATE_DERIVED_ENCODINGS = "separateDerivedEncodings";
    public static final boolean DEFAULT_PREF_SEPARATE_DERIVED_ENCODINGS = false;
    public static final String PREF_MISSING_NATURE_MARKER_SEVERITY = "missingNatureMarkerSeverity";
    public static final String PREF_MAX_CONCURRENT_BUILDS = "maxConcurrentBuilds";
    private static ResourcesPlugin plugin;
    private static Workspace workspace;
    private ServiceRegistration<IWorkspace> workspaceRegistration;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private CheckMissingNaturesListener checkMissingNaturesListener;

    static {
        workspace = null;
    }

    public ResourcesPlugin() {
        plugin = this;
    }

    public static String getEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString(PREF_ENCODING);
        if (enc == null || enc.length() == 0) {
            enc = System.getProperty("file.encoding");
        }
        return enc;
    }

    public static ResourcesPlugin getPlugin() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        if (workspace == null) {
            throw new IllegalStateException(Messages.resources_workspaceClosed);
        }
        return workspace;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.debugRegistration.unregister();
        this.debugRegistration = null;
        if (workspace == null) {
            return;
        }
        workspace.removeResourceChangeListener(this.checkMissingNaturesListener);
        InstanceScope.INSTANCE.getNode(PREF_MISSING_NATURE_MARKER_SEVERITY).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.checkMissingNaturesListener);
        if (this.workspaceRegistration != null) {
            this.workspaceRegistration.unregister();
        }
        ResourcesPlugin.getPlugin().savePluginPreferences();
        workspace.close(null);
        workspace = null;
        this.workspaceRegistration = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", PI_RESOURCES);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.RESOURCES_DEBUG_OPTIONS_LISTENER, properties);
        workspace = new Workspace();
        IStatus result = workspace.open(null);
        if (!result.isOK()) {
            this.getLog().log(result);
        }
        this.workspaceRegistration = context.registerService(IWorkspace.class, (Object)workspace, null);
        this.checkMissingNaturesListener = new CheckMissingNaturesListener();
        workspace.addResourceChangeListener(this.checkMissingNaturesListener, 1);
        InstanceScope.INSTANCE.getNode(PI_RESOURCES).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.checkMissingNaturesListener);
    }
}

