/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.util;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.integration.test.installation.common.dialog.CertificatesDialog;
import org.eclipse.reddeer.integration.test.installation.common.dialog.SecurityWarningDialog;
import org.eclipse.reddeer.integration.test.installation.common.dialog.SelectionNeededDialog;
import org.eclipse.reddeer.integration.test.installation.common.dialog.SoftwareUpdateDialog;
import org.eclipse.reddeer.integration.test.installation.common.page.RemediationActionPage;
import org.eclipse.reddeer.integration.test.installation.common.page.ReviewLicensesPage;
import org.eclipse.reddeer.integration.test.installation.common.util.RemediationActionValidator;
import org.eclipse.reddeer.integration.test.installation.common.wait.WaitForOneOfShells;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;

public class InstallationOperator {
    private static Logger LOG = Logger.getLogger(InstallationOperator.class);
    public static final int INSTALLATION_TIMEOUT = 3600;
    @Rule
    public ErrorCollector collector = new ErrorCollector();
    private WizardDialog installWizard;

    public InstallationOperator(WizardDialog installWizard, ErrorCollector collector) {
        this.installWizard = installWizard;
        this.collector = collector;
    }

    public void completeInstallation() {
        if (new WithTextMatcher((Matcher)new RegexMatcher("(.*Remediation Page)|(Confirm Selected Features)")).matches((Object)this.installWizard.getTitle())) {
            this.dealWithRemediationPage();
        }
        if (this.installWizard.getTitle().equals("Install Details")) {
            this.dealWithInstallationDetailsPage();
        }
        if (this.installWizard.getTitle().equals("Review Licenses")) {
            this.dealWithReviewLicensesPage(true);
        }
        new WaitForOneOfShells("Security Warning", "Selection Needed", "Software Updates", "", "Certificates");
        if (SecurityWarningDialog.isAvailable()) {
            this.dealWithSecurityWarningWindow();
        }
        if (SelectionNeededDialog.isAvailable(true)) {
            this.dealWithSelectionNeededWindow(true);
        }
        if (CertificatesDialog.isAvailable()) {
            this.dealWithCertificatesWindow();
        }
        new WaitForOneOfShells("Selection Needed", "Software Updates", "");
        if (SelectionNeededDialog.isAvailable()) {
            this.dealWithSelectionNeededWindow();
        }
        if (SelectionNeededDialog.isAvailable(true)) {
            this.dealWithSelectionNeededWindow(true);
        }
        new WaitForOneOfShells("Software Updates", "");
        if (SelectionNeededDialog.isAvailable(true)) {
            this.dealWithSelectionNeededWindow(true);
        }
        new SoftwareUpdateDialog().no();
    }

    public void updateDryRun() {
        if (new WithTextMatcher((Matcher)new RegexMatcher("(.*Remediation Page)|(Confirm Selected Features)")).matches((Object)this.installWizard.getTitle())) {
            this.dealWithRemediationPage();
        }
        if (this.installWizard.getTitle().equals("Update Details")) {
            this.dealWithUpdateDetailsPage();
        } else {
            this.collector.addError((Throwable)((Object)new AssertionError((Object)"Update Details page hasn't been displayed.")));
        }
        if (this.installWizard.getTitle().equals("Review Licenses")) {
            this.dealWithReviewLicensesPage(false);
        }
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells();
    }

    public void dealWithInstallationDetailsPage() {
        this.capture("Install_Details_Page");
        if (this.installWizard.isNextEnabled()) {
            this.installWizard.next();
        } else {
            this.installWizard.finish(TimePeriod.getCustom((long)3600L));
        }
    }

    public void dealWithUpdateDetailsPage() {
        this.capture("Update_Details_Page");
        if (this.installWizard.isNextEnabled()) {
            this.installWizard.next();
        }
    }

    public void dealWithReviewLicensesPage(boolean clickFinish) {
        this.capture("Review_Licenses_Page");
        ReviewLicensesPage licencePage = new ReviewLicensesPage((TitleAreaDialog)this.installWizard);
        this.collector.checkThat("Licence is accepted by default", (Object)licencePage.isLicenseAccepted(), (Matcher)new IsEqual((Object)false));
        this.collector.checkThat("Finish button is enabled without accepting the licence", (Object)this.installWizard.isFinishEnabled(), (Matcher)new IsEqual((Object)false));
        licencePage.acceptLicense();
        this.collector.checkThat("Finish button is not enabled by accepting the licence", (Object)this.installWizard.isFinishEnabled(), (Matcher)new IsEqual((Object)true));
        if (clickFinish) {
            this.installWizard.finish(TimePeriod.getCustom((long)3600L));
        }
    }

    public void dealWithSecurityWarningWindow() {
        this.collector.addError((Throwable)((Object)new AssertionError((Object)"Security Warning window has been displayed.")));
        this.capture("Security_Warning_Window");
        new SecurityWarningDialog().ok();
    }

    public void dealWithSelectionNeededWindow() {
        this.dealWithSelectionNeededWindow(false);
    }

    public void dealWithSelectionNeededWindow(boolean emptyHeader) {
        LOG.warn("Selection Needed window has been displayed.");
        if (emptyHeader) {
            this.capture("Selection_Needed_Window_No_Header");
            new SelectionNeededDialog("").acceptAll();
        } else {
            this.capture("Selection_Needed_Window");
            new SelectionNeededDialog().acceptAll();
        }
    }

    public void dealWithCertificatesWindow() {
        LOG.warn("Selection Needed window has been displayed.");
        this.capture("Certificates_Window");
        new CertificatesDialog().acceptAll();
    }

    public void dealWithRemediationPage() {
        LOG.warn("Remediation Action page has been displayed.");
        RemediationActionPage remetiationPage = new RemediationActionPage((TitleAreaDialog)this.installWizard);
        if (remetiationPage.isEnabledShowOriginalErrors()) {
            remetiationPage.chooseShowOriginalErrors();
            this.capture("Remediation_Page_Show_Original_Errors");
            LOG.warn("Remediation Action needed. Original error:\n" + remetiationPage.getOriginalError());
        }
        if (remetiationPage.isEnabledKeepMyInstallation()) {
            remetiationPage.chooseKeepMyInstallation();
            this.capture("Remediation_Page_Keep_My_Installation");
        }
        if (remetiationPage.isEnabledUpdateMyInstallation()) {
            remetiationPage.chooseUpdateMyInstallation();
            this.capture("Remediation_Page_Update_My_Installation");
            RemediationActionValidator.validateSolution(remetiationPage, this.collector);
        } else {
            LOG.warn("Remediation Action is needed and 'Update' choice is not available.");
        }
        this.installWizard.next();
    }

    private void capture(String description) {
        try {
            ScreenshotCapturer.getInstance().captureScreenshot(String.valueOf(this.getClass().getName()) + description);
        }
        catch (CaptureScreenshotException e) {
            e.printInfo(LOG);
        }
    }
}

