/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.AbstractStructuredTextReconcilingStrategy;

public abstract class StructuredTextReconcilingStrategy
extends AbstractStructuredTextReconcilingStrategy {
    public StructuredTextReconcilingStrategy(ISourceViewer sourceViewer) {
        super(sourceViewer);
    }

    protected boolean overlaps(Position pos, IStructuredDocumentRegion[] sdRegions) {
        int start = -1;
        int end = -1;
        int i = 0;
        while (i < sdRegions.length) {
            IndexedRegion corresponding;
            if (!sdRegions[i].isDeleted() && (corresponding = this.getCorrespondingNode(sdRegions[i])) != null) {
                if (start == -1 || start > corresponding.getStartOffset()) {
                    start = corresponding.getStartOffset();
                }
                if (end == -1 || end < corresponding.getEndOffset()) {
                    end = corresponding.getEndOffset();
                }
            }
            ++i;
        }
        return pos.overlapsWith(start, end - start);
    }

    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        IndexedRegion indexedRegion = null;
        try {
            if (sModel != null) {
                indexedRegion = sModel.getIndexedRegion(sdRegion.getStart());
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return indexedRegion;
    }
}

