/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.impl.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.workbench.api.Editor;
import org.eclipse.reddeer.workbench.core.lookup.EditorPartLookup;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.reddeer.workbench.handler.TextEditorHandler;
import org.eclipse.reddeer.workbench.impl.editor.AbstractEditor;
import org.eclipse.reddeer.workbench.matcher.EditorPartClassMatcher;
import org.eclipse.reddeer.workbench.matcher.EditorPartTitleMatcher;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hamcrest.Matcher;

public class TextEditor
extends AbstractEditor
implements Editor {
    private static final Logger log = Logger.getLogger(TextEditor.class);

    public TextEditor() {
        super(EditorPartLookup.getInstance().getEditor());
        if (!(this.editorPart instanceof ITextEditor)) {
            throw new WorkbenchLayerException("The active editor is not a text editor, but " + this.editorPart.getClass());
        }
    }

    public TextEditor(String title) {
        super(EditorPartLookup.getInstance().getEditor(new Matcher[]{new EditorPartClassMatcher(ITextEditor.class), new EditorPartTitleMatcher((Matcher<String>)new WithTextMatcher(title))}));
    }

    public TextEditor(Matcher<String> title) {
        super(EditorPartLookup.getInstance().getEditor(new Matcher[]{new EditorPartClassMatcher(ITextEditor.class), new EditorPartTitleMatcher(title)}));
    }

    protected TextEditor(ITextEditor editor) {
        super((IEditorPart)editor);
    }

    public String getText() {
        return TextEditorHandler.getInstance().getDocument(this.getEditorPart()).get();
    }

    public void setText(String text) {
        log.info("Set text to editor");
        TextEditorHandler.getInstance().setText(this.getEditorPart(), text);
    }

    public String getTextAtLine(int line) {
        return TextEditorHandler.getInstance().getTextAtLine(this.getEditorPart(), line);
    }

    public int getNumberOfLines() {
        return TextEditorHandler.getInstance().getNumberOfLines(this.getEditorPart());
    }

    public int getLineOfText(String text) {
        return this.getLineOfText(text, 0);
    }

    public int getLineOfText(String text, int textIndex) {
        return TextEditorHandler.getInstance().getLineOfText(this.getEditorPart(), text, textIndex);
    }

    public void insertText(int line, int offset, String text) {
        log.info("Insert text to editor at line " + line + ", offser " + offset);
        TextEditorHandler.getInstance().insertText(this.getEditorPart(), line, offset, text);
    }

    public void insertText(int offset, String text) {
        log.info("Insert text to editor at offser " + offset);
        TextEditorHandler.getInstance().insertText(this.getEditorPart(), offset, text);
    }

    public void insertLine(int line, String text) {
        log.info("Insert text to editor at line " + line);
        try {
            String delimiter = TextEditorHandler.getInstance().getDocument(this.getEditorPart()).getLineDelimiter(line);
            delimiter = delimiter == null ? System.lineSeparator() : delimiter;
            this.insertText(line, 0, String.valueOf(text) + delimiter);
        }
        catch (BadLocationException e) {
            throw new WorkbenchLayerException("Line provided is invalid for this editor", e);
        }
    }

    public String getSelectedText() {
        return TextEditorHandler.getInstance().getSelectedText(this.getEditorPart());
    }

    public void selectLine(int lineNumber) {
        log.info("Select line " + lineNumber + " in editor");
        TextEditorHandler.getInstance().selectLine(this.getEditorPart(), lineNumber);
    }

    public void selectText(String text) {
        log.info("Select text in editor");
        TextEditorHandler.getInstance().selectText(this.getEditorPart(), text, 0);
    }

    public void selectText(String text, int index) {
        log.info("Select text in editor with index " + index);
        TextEditorHandler.getInstance().selectText(this.getEditorPart(), text, index);
    }

    public int getPositionOfText(String text) {
        return this.getPositionOfText(text, 0);
    }

    public void setCursorPosition(int line, int column) {
        log.info("Set cursor position to [" + line + ", " + column + "]");
        TextEditorHandler.getInstance().setCursorPosition(this.getEditorPart(), line, column);
    }

    public void setCursorPosition(int offset) {
        log.info("Set cursor position to offset: " + offset);
        this.activate();
        TextEditorHandler.getInstance().setCursorPosition(this.getEditorPart(), offset);
    }

    public int getPositionOfText(String text, int index) {
        return TextEditorHandler.getInstance().getPositionOfText(this.getEditorPart(), text, index);
    }

    public Point getCursorPosition() {
        this.activate();
        return TextEditorHandler.getInstance().getCursorPosition(this.getEditorPart());
    }

    protected int getCursorOffset() {
        ITextSelection textSelection = (ITextSelection)this.getEditorPart().getSite().getSelectionProvider().getSelection();
        return textSelection.getOffset();
    }

    public ITextEditor getEditorPart() {
        return (ITextEditor)super.getEditorPart();
    }
}

