/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EJBClientJarCreationHelper {
    protected static final String SERVICE_LOCATOR_JAR_NAME = "serviceLocatorMgr.jar";
    private IProject ejbProject = null;
    protected Map javaFilesToMove = new HashMap();
    protected Set visitedJavaTypes = new HashSet();
    protected int moveResourceCount = 0;
    protected SearchEngine searchEngine = new SearchEngine();
    private MySearchHelper searchHelper = null;

    public EJBClientJarCreationHelper(IProject aEjbProject) {
        this.ejbProject = aEjbProject;
    }

    public Map getFilesToMove() {
        this.searchHelper = new MySearchHelper(this.searchEngine, this.computeBeanTypeNames());
        if (this.ejbProject.exists() && this.ejbProject.isAccessible()) {
            if (JavaEEProjectUtilities.isLegacyJ2EEComponent((IVirtualComponent)ComponentCore.createComponent((IProject)this.ejbProject))) {
                EJBArtifactEdit edit = null;
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForRead(this.ejbProject);
                    org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = edit.getEJBJar();
                    if (ejbJar != null) {
                        EList enterpriseBeans = ejbJar.getEnterpriseBeans();
                        int i = 0;
                        while (i < enterpriseBeans.size()) {
                            EnterpriseBean ejb = (EnterpriseBean)enterpriseBeans.get(i);
                            this.computeJavaTypes(ejb);
                            ++i;
                        }
                    }
                    this.computeRMICJavaTypes();
                }
                finally {
                    if (edit != null) {
                        edit.dispose();
                    }
                }
            } else {
                EnterpriseBeans enterpriseBeans;
                IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this.ejbProject);
                EJBJar ejbJar = (EJBJar)modelProvider.getModelObject();
                if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                    List sessionBeans = enterpriseBeans.getSessionBeans();
                    for (SessionBean sessionBean : sessionBeans) {
                        this.computeJavaTypes(sessionBean);
                    }
                    List entityBeans = enterpriseBeans.getEntityBeans();
                    for (EntityBean entityBean : entityBeans) {
                        this.computeJavaTypes(entityBean);
                    }
                }
                this.computeRMICJavaTypes();
            }
        }
        return this.javaFilesToMove;
    }

    public static void copyOutgoingClasspathEntries(IProject source, IProject target, boolean filterServiceLocator) throws JavaModelException {
        IJavaProject sourceJProject = JemProjectUtilities.getJavaProject((IProject)source);
        IJavaProject targetJProject = JemProjectUtilities.getJavaProject((IProject)target);
        IClasspathEntry[] sourceCp = sourceJProject.getRawClasspath();
        ArrayList<IClasspathEntry> targetCp = new ArrayList<IClasspathEntry>(Arrays.asList(targetJProject.getRawClasspath()));
        int i = 0;
        while (i < sourceCp.length) {
            IClasspathEntry entry = sourceCp[i];
            if (!(EJBClientJarCreationHelper.isContainedInProject(entry, source) || EJBClientJarCreationHelper.contains(targetCp, entry) || EJBClientJarCreationHelper.isServiceLocator(entry) && filterServiceLocator)) {
                targetCp.add(entry);
            }
            ++i;
        }
        IClasspathEntry[] newCp = targetCp.toArray(new IClasspathEntry[targetCp.size()]);
        targetJProject.setRawClasspath(newCp, null);
    }

    private static boolean isContainedInProject(IClasspathEntry entry, IProject project) {
        return !entry.getPath().isEmpty() && project.getName().equals(entry.getPath().segment(0));
    }

    private static boolean contains(List cp, IClasspathEntry entry) {
        int i = 0;
        while (i < cp.size()) {
            IClasspathEntry elmt = (IClasspathEntry)cp.get(i);
            if (elmt.getEntryKind() == entry.getEntryKind() && elmt.getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isServiceLocator(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return path != null && SERVICE_LOCATOR_JAR_NAME.equals(path.lastSegment());
    }

    public static List normalize(String[] mfEntries, IProject earProject, IProject ejbProject, boolean filterServiceLocator) {
        String jarURI = null;
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            if (edit != null && (jarURI = edit.getModuleURI(ComponentCore.createComponent((IProject)ejbProject))) == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        ArrayList<String> result = new ArrayList<String>(mfEntries.length);
        int i = 0;
        while (i < mfEntries.length) {
            String norm = ArchiveUtil.deriveEARRelativeURI((String)mfEntries[i], (String)jarURI);
            if (norm == null) {
                norm = mfEntries[i];
            }
            if (!SERVICE_LOCATOR_JAR_NAME.equals(norm) || !filterServiceLocator) {
                result.add(norm);
            }
            ++i;
        }
        return result;
    }

    private void computeJavaTypes(EnterpriseBean ejb) {
        this.computeJavaTypes(ejb.getHomeInterface());
        this.computeJavaTypes(ejb.getRemoteInterface());
        this.computeJavaTypes(ejb.getLocalInterface());
        this.computeJavaTypes(ejb.getLocalHomeInterface());
        if (ejb.isEntity()) {
            this.computeJavaTypes(((Entity)ejb).getPrimaryKey());
        }
    }

    private void computeJavaTypes(EntityBean entityBean) {
        this.computeJavaTypes(entityBean.getHome());
        this.computeJavaTypes(entityBean.getLocalHome());
        this.computeJavaTypes(entityBean.getLocal());
        this.computeJavaTypes(entityBean.getRemote());
        this.computeJavaTypes(entityBean.getPrimkeyField());
    }

    private void computeJavaTypes(String fqClassName) {
        if (fqClassName == null) {
            return;
        }
        IJavaProject jProj = JemProjectUtilities.getJavaProject((IProject)this.ejbProject);
        try {
            IType type = jProj.findType(fqClassName);
            this.computeJavaTypes(type);
        }
        catch (JavaModelException e) {
            EjbPlugin.logError((CoreException)e);
        }
    }

    private void computeJavaTypes(SessionBean sessionBean) {
        this.computeJavaTypes(sessionBean.getHome());
        this.computeJavaTypes(sessionBean.getLocalHome());
        this.computeJavaTypes(sessionBean.getLocal());
        this.computeJavaTypes(sessionBean.getRemote());
        List businessLocals = sessionBean.getBusinessLocals();
        for (String string : businessLocals) {
            this.computeJavaTypes(string);
        }
        List businessRemotes = sessionBean.getBusinessRemotes();
        for (String string : businessRemotes) {
            this.computeJavaTypes(string);
        }
    }

    private void computeJavaTypes(JavaClass javaClass) {
        if (javaClass == null) {
            return;
        }
        IJavaProject jProj = JemProjectUtilities.getJavaProject((IProject)this.ejbProject);
        IType type = JDOMSearchHelper.findType((String)javaClass.getJavaPackage().getName(), (String)javaClass.getSimpleName(), (IJavaProject)jProj);
        this.computeJavaTypes(type);
    }

    private void computeJavaTypes(IType type) {
        if (type == null || this.visitedJavaTypes.contains(type)) {
            return;
        }
        this.visitedJavaTypes.add(type);
        try {
            IFile file = (IFile)type.getUnderlyingResource();
            if (file != null && this.ejbProject.equals((Object)file.getProject())) {
                if (!file.isDerived()) {
                    this.cacheType(type, file);
                }
                this.computeRequiredReferencedJavaTypes(type);
            }
        }
        catch (JavaModelException e) {
            EjbPlugin.logError((CoreException)e);
            return;
        }
    }

    private void cacheType(IType type, IFile file) {
        ++this.moveResourceCount;
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        this.cacheFile(root, file);
    }

    private void cacheFile(IPackageFragmentRoot root, IFile file) {
        HashSet<IFile> files = (HashSet<IFile>)this.javaFilesToMove.get(root);
        if (files == null) {
            files = new HashSet<IFile>();
            this.javaFilesToMove.put(root, files);
        }
        files.add(file);
    }

    private void computeRequiredReferencedJavaTypes(IType type) throws JavaModelException {
        HashSet result = new HashSet();
        this.searchHelper.searchForReferences(type, result);
        if (!result.isEmpty()) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                this.computeJavaTypes((IType)iter.next());
            }
        }
    }

    private Collection computeBeanTypeNames() {
        Collection<String> names = null;
        if (this.ejbProject.exists() && this.ejbProject.isAccessible()) {
            EJBArtifactEdit edit = null;
            try {
                EList beans;
                edit = EJBArtifactEdit.getEJBArtifactEditForRead(this.ejbProject);
                org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = edit.getEJBJar();
                if (ejbJar != null && !(beans = ejbJar.getEnterpriseBeans()).isEmpty()) {
                    names = new HashSet(beans.size());
                    int i = 0;
                    while (i < beans.size()) {
                        EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                        names.add(bean.getEjbClassName());
                        ++i;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        if (names == null) {
            names = Collections.EMPTY_LIST;
        }
        return names;
    }

    private void computeRMICJavaTypes() {
        try {
            List roots = this.getResourcePackageFragmentRoots();
            int i = 0;
            while (i < roots.size()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)roots.get(i);
                this.computeRMICJavaTypes(root);
                ++i;
            }
        }
        catch (CoreException e) {
            EjbPlugin.logError(e);
        }
    }

    private List getResourcePackageFragmentRoots() throws JavaModelException {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)this.ejbProject);
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1 || this.isClassesFolder(root)) {
                result.add(root);
            }
            ++i;
        }
        return result;
    }

    private boolean isClassesFolder(IPackageFragmentRoot root) throws JavaModelException {
        return root.getKind() == 2 && !root.isArchive() && !root.isExternal();
    }

    private void computeRMICJavaTypes(IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] pkgFragments = root.getChildren();
        IFile aFile = null;
        int i = 0;
        while (i < pkgFragments.length) {
            IJavaElement[] elements = ((IPackageFragment)pkgFragments[i]).getChildren();
            int j = 0;
            while (j < elements.length) {
                IJavaElement unit = elements[j];
                aFile = (IFile)unit.getUnderlyingResource();
                if (this.isRMICStub(aFile) && this.isFileForClientJar(aFile)) {
                    this.cacheFile(root, aFile);
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean isRMICStub(IFile aFile) {
        String name = aFile.getName();
        String ext = aFile.getFileExtension();
        if (name != null && ext != null) {
            name = name.substring(0, name.length() - ext.length() - 1);
        }
        return name != null && name.startsWith("_") && name.endsWith("_Stub");
    }

    private boolean isFileForClientJar(IFile aFile) {
        String name = aFile.getName();
        return !name.startsWith("_EJS") && (!name.startsWith("_") || name.indexOf("InternalHome_") <= 0);
    }

    private static class MySearchHelper
    extends SearchRequestor {
        SearchEngine engine;
        Collection results;
        Collection beanTypeNames;

        MySearchHelper(SearchEngine engine, Collection beanTypeNames) {
            this.engine = engine;
            this.beanTypeNames = beanTypeNames;
        }

        void searchForReferences(IType type, Collection results) throws JavaModelException {
            this.results = results;
            try {
                this.engine.searchDeclarationsOfReferencedTypes((IJavaElement)type, (SearchRequestor)this, null);
            }
            catch (ClassCastException ex) {
                EjbPlugin.logError(ex);
            }
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() == 0 && !match.isInsideDocComment() && !this.isBeanType((IType)match.getElement())) {
                this.results.add(match.getElement());
            }
        }

        private boolean isBeanType(IType type) {
            return this.beanTypeNames.contains(type.getFullyQualifiedName());
        }
    }
}

