/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.preferences;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.hamcrest.Matcher;

public class ClasspathVariablesPreferencePage
extends PreferencePage {
    public ClasspathVariablesPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Java", "Build Path", "Classpath Variables"});
    }

    public List<String> getVariables() {
        LinkedList<String> libraries = new LinkedList<String>();
        for (TableItem ti : this.getClasspathVariablesTable().getItems()) {
            libraries.addLast(ti.getText());
        }
        return libraries;
    }

    public ClasspathVariablesPreferencePage selectVariable(Matcher<?> matcher) {
        new DefaultTableItem((ReferencedComposite)this.getClasspathVariablesTable(), new Matcher[]{matcher}).select();
        return this;
    }

    private Table getClasspathVariablesTable() {
        return new DefaultTable((ReferencedComposite)this);
    }

    public String addVariable(String name, String value, boolean overwriteIfExists) {
        boolean externalJarExists = false;
        Iterator itTableItem = this.getClasspathVariablesTable().getItems().iterator();
        while (itTableItem.hasNext() && !externalJarExists) {
            TableItem tableItem = (TableItem)itTableItem.next();
            if (!tableItem.getText().split(" - ")[0].equals(name)) continue;
            tableItem.select();
            externalJarExists = true;
        }
        DefaultShell variableEntryShell = null;
        if (externalJarExists && overwriteIfExists) {
            new PushButton((ReferencedComposite)this, "Edit...").click();
            variableEntryShell = new DefaultShell("Edit Variable Entry");
            new LabeledText((ReferencedComposite)variableEntryShell, "Path:").setText(value);
        } else {
            new PushButton((ReferencedComposite)this, "New...").click();
            variableEntryShell = new DefaultShell("New Variable Entry");
            new LabeledText((ReferencedComposite)variableEntryShell, "Name:").setText(name);
            new LabeledText((ReferencedComposite)variableEntryShell, "Path:").setText(value);
        }
        new OkButton((ReferencedComposite)variableEntryShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)variableEntryShell));
        return ((TableItem)new DefaultTable((ReferencedComposite)this).getSelectetItems().get(0)).getText();
    }

    public ClasspathVariablesPreferencePage removeVariable(String label) {
        this.selectVariable((Matcher<?>)new WithTextMatcher(label));
        new PushButton((ReferencedComposite)this, "Remove").click();
        return this;
    }
}

