/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.editor;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.gef.api.Palette;
import org.eclipse.reddeer.gef.condition.EditorHasEditParts;
import org.eclipse.reddeer.gef.handler.ViewerHandler;
import org.eclipse.reddeer.gef.impl.editpart.internal.BasicEditPart;
import org.eclipse.reddeer.gef.lookup.ViewerLookup;
import org.eclipse.reddeer.gef.view.PaletteView;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.swt.widgets.Control;

public class GEFEditor
extends DefaultEditor
implements ReferencedComposite {
    protected GraphicalViewer viewer;

    public GEFEditor() {
        this.initGraphicalViewer();
    }

    public GEFEditor(String title) {
        super(title);
        this.initGraphicalViewer();
    }

    protected void initGraphicalViewer() {
        this.viewer = ViewerLookup.getInstance().findGraphicalViewer(this.getEditorPart());
    }

    protected GraphicalViewer getGraphicalViewer() {
        if (this.viewer == null) {
            throw new GEFLayerException("No graphical viewer has been initialized. Graphical viewer is needed for many GED operations.");
        }
        return this.viewer;
    }

    public int getNumberOfEditParts() {
        return ViewerHandler.getInstance().getEditParts(this.viewer).size();
    }

    public void click(int x, int y) {
        ViewerHandler.getInstance().click((EditPartViewer)this.viewer, x, y);
    }

    public Palette getPalette() {
        new PaletteView().open();
        return ViewerHandler.getInstance().getPalette(this.viewer);
    }

    public org.eclipse.reddeer.gef.api.EditPart addToolFromPalette(String tool, int x, int y) {
        return this.addToolFromPalette(tool, null, x, y);
    }

    public org.eclipse.reddeer.gef.api.EditPart addToolFromPalette(String tool, String group, int x, int y) {
        int oldCount = this.getNumberOfEditParts();
        final ViewerListener viewerListener = new ViewerListener();
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                List<EditPart> editParts = ViewerHandler.getInstance().getEditParts(GEFEditor.this.viewer);
                for (EditPart editPart : editParts) {
                    editPart.addEditPartListener((EditPartListener)viewerListener);
                }
            }
        });
        this.getPalette().activateTool(tool, group);
        this.click(x, y);
        return this.getAddedEditPart(viewerListener, oldCount);
    }

    protected org.eclipse.reddeer.gef.api.EditPart getAddedEditPart(ViewerListener viewerListener, int oldCount) {
        new WaitUntil((WaitCondition)new EditorHasEditParts(this, oldCount));
        if (viewerListener.getAddedEditPart() == null) {
            throw new GEFLayerException("No new edit part was detected");
        }
        return new BasicEditPart(viewerListener.getAddedEditPart());
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    private class ViewerListener
    implements EditPartListener {
        private EditPart addedEditPart;

        private ViewerListener() {
        }

        public EditPart getAddedEditPart() {
            return this.addedEditPart;
        }

        public void childAdded(EditPart child, int index) {
            log.info("New edit part " + child);
            this.addedEditPart = child;
        }

        public void partActivated(EditPart editpart) {
        }

        public void partDeactivated(EditPart editpart) {
        }

        public void removingChild(EditPart child, int index) {
        }

        public void selectedStateChanged(EditPart editpart) {
        }
    }
}

