/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner;

import java.util.List;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRequirementsRunner;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunner;
import org.junit.Assert;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runners.Parameterized;
import org.junit.runners.model.Statement;

public class ParameterizedRunner
extends Parameterized {
    private String configId;
    private Requirements requirements;
    private RunListener[] runListeners;
    private List<IBeforeTest> beforeTestExtensions;
    private List<IAfterTest> afterTestExtensions;
    private RequirementsRunner firstChildRunner;

    public ParameterizedRunner(Class<?> clazz, Requirements requirements, String configId, RunListener[] runListeners, List<IBeforeTest> beforeTestExtensions, List<IAfterTest> afterTestExtensions) throws Throwable {
        super(clazz);
        this.requirements = requirements;
        this.configId = configId;
        this.runListeners = runListeners;
        this.beforeTestExtensions = beforeTestExtensions;
        this.afterTestExtensions = afterTestExtensions;
    }

    protected String getName() {
        return String.valueOf(super.getName()) + " " + this.configId;
    }

    protected List<Runner> getChildren() {
        List children = super.getChildren();
        for (Runner runner : children) {
            if (runner instanceof ParameterizedRequirementsRunner) {
                ParameterizedRequirementsRunner testRunner = (ParameterizedRequirementsRunner)runner;
                testRunner.setConfigId(this.configId);
                testRunner.setRequirements(this.requirements);
                testRunner.setRunListeners(this.runListeners);
                testRunner.setAfterTestExtensions(this.afterTestExtensions);
                testRunner.setBeforeTestExtensions(this.beforeTestExtensions);
                if (this.firstChildRunner != null) continue;
                this.firstChildRunner = testRunner;
                continue;
            }
            return null;
        }
        return children;
    }

    protected Statement withBeforeClasses(Statement statement) {
        Assert.assertNotNull((Object)((Object)this.firstChildRunner));
        return this.firstChildRunner.withBeforeClasses(statement);
    }

    protected Statement withAfterClasses(Statement statement) {
        Assert.assertNotNull((Object)((Object)this.firstChildRunner));
        return this.firstChildRunner.withAfterClasses(statement);
    }
}

