/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.browser;

import org.eclipse.reddeer.common.platform.RunningPlatform;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.browser.InternalBrowser;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.swt.test.utils.LabelTestUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BrowserTest
extends SWTLayerTestCase {
    private static final String BROWSER_LABEL = "Test browser:";
    private static TestBrowser testBrowser;

    @Override
    protected void createControls(Shell shell) {
        LabelTestUtils.createLabel((Composite)shell, BROWSER_LABEL);
        testBrowser = new TestBrowser((Composite)shell, 0);
        testBrowser.setSize(400, 400);
        if (RunningPlatform.isWindows()) {
            testBrowser.setUrl(testBrowser.getUrl());
        }
    }

    @Test
    public void evaluateTest() {
        String evaluatedString = (String)new InternalBrowser(0, new Matcher[0]).evaluate("testEvaluate();return \"test\";");
        Assert.assertTrue((boolean)testBrowser.wasEvaluated());
        Assert.assertEquals((Object)"test", (Object)evaluatedString);
    }

    @Test
    public void executeTest() {
        new InternalBrowser().execute("testExecute()");
        Assert.assertTrue((boolean)testBrowser.wasExecuted());
    }

    @Test
    @Ignore
    public void findBrowserByLabel() {
        new InternalBrowser(BROWSER_LABEL);
    }

    @Test
    public void findBrowserByIndex() {
        new InternalBrowser(0, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingBrowserByLabel() {
        new InternalBrowser("@#NON_EXISITNG_LABEL%$");
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingBrowserByIndex() {
        new InternalBrowser(1, new Matcher[0]);
    }

    @Test
    public void navigate() {
        InternalBrowser browser = new InternalBrowser(0, new Matcher[0]);
        browser.setURL("http://www.eclipse.org/swt/snippets/");
        Assert.assertTrue((String)"Browser has to contain text '<title>SWT Snippets</title>' but it doesn't", (boolean)browser.getText().contains("<title>SWT Snippets</title>"));
        browser.setURL("http://www.eclipse.org/swt/widgets/");
        Assert.assertTrue((String)"Browser has to contain text '<title>SWT Widgets</title>' but it doesn't", (boolean)browser.getText().contains("<title>SWT Widgets</title>"));
        browser.back();
        Assert.assertTrue((String)"Browser has to contain text '<title>SWT Snippets</title>' but it doesn't", (boolean)browser.getText().contains("<title>SWT Snippets</title>"));
        browser.forward();
        Assert.assertTrue((String)"Browser has to contain text '<title>SWT Widgets</title>' but it doesn't", (boolean)browser.getText().contains("<title>SWT Widgets</title>"));
    }

    private class TestBrowser
    extends Browser {
        private boolean executed;
        private boolean evaluated;

        public TestBrowser(Composite parent, int style) {
            super(parent, style);
            this.executed = false;
            this.evaluated = false;
            new BrowserFunction(this, "testExecute"){

                public Object function(Object[] arguments) {
                    TestBrowser.this.executed = true;
                    return null;
                }
            };
            new BrowserFunction(this, "testEvaluate"){

                public Object function(Object[] arguments) {
                    TestBrowser.this.evaluated = true;
                    return null;
                }
            };
        }

        protected void checkSubclass() {
        }

        public boolean wasExecuted() {
            return this.executed;
        }

        public boolean wasEvaluated() {
            return this.evaluated;
        }
    }
}

