/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.button;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.api.Button;
import org.eclipse.reddeer.swt.impl.button.ArrowButton;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.button.ToggleButton;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ButtonTest
extends SWTLayerTestCase {
    private static final String PUSH_BUTTON_LABEL_PREFIX = "PUSH-BUTTON";
    private static final String RADIO_BUTTON_LABEL_PREFIX = "RADIO-BUTTON";
    private static final String TOGGLE_BUTTON_LABEL_PREFIX = "TOOGLE-BUTTON";
    private static final String CHECK_BOX_LABEL_PREFIX = "CHECK-BOX";
    private static final String ARROW_BUTTON_LABEL_PREFIX = "ARROW-BUTTON";
    private static final String TOOLTIP_PREFIX = "TOOLTIP FOR: ";
    private static final int NUM_BUTTONS = 3;
    private org.eclipse.reddeer.swt.api.Text selectionText = null;
    private SelectionListener selectionListener;
    Text txSelection;

    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new GridLayout(3, true));
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                org.eclipse.swt.widgets.Button selectedButton = (org.eclipse.swt.widgets.Button)arg0.widget;
                ButtonTest.this.txSelection.setText(selectedButton.getData().toString());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        this.createButtons(PUSH_BUTTON_LABEL_PREFIX, 8, shell);
        this.createButtons(TOGGLE_BUTTON_LABEL_PREFIX, 2, shell);
        this.createButtons(RADIO_BUTTON_LABEL_PREFIX, 16, shell);
        this.createButtons(CHECK_BOX_LABEL_PREFIX, 32, shell);
        this.createButtons(ARROW_BUTTON_LABEL_PREFIX, 4, shell);
        this.txSelection = new Text((Composite)shell, 2048);
        this.txSelection.setText("<text of selected button>");
    }

    private void createButtons(String textPrefix, int style, Shell shell) {
        int i = 0;
        while (i < 3) {
            org.eclipse.swt.widgets.Button button = new org.eclipse.swt.widgets.Button((Composite)shell, style);
            button.setText(String.valueOf(textPrefix) + i);
            button.setToolTipText(TOOLTIP_PREFIX + textPrefix + i);
            button.setData((Object)(String.valueOf(textPrefix) + i));
            button.addSelectionListener(this.selectionListener);
            if (style == 16 && i == 0) {
                button.setSelection(true);
            }
            ++i;
        }
    }

    @Test
    public void findPushButtonByIndexAndCheck() {
        int index = 2;
        this.checkButton(PUSH_BUTTON_LABEL_PREFIX + index, (Button)new PushButton(index, new Matcher[0]));
    }

    @Test
    public void findRadioButtonByIndexAndCheck() {
        int index = 1;
        RadioButton radioButton = new RadioButton(index, new Matcher[0]);
        this.checkButton(RADIO_BUTTON_LABEL_PREFIX + index, (Button)radioButton);
        Assert.assertTrue((String)("Radio Button " + radioButton.getText() + " is not selected"), (boolean)radioButton.isSelected());
        radioButton = new RadioButton(0, new Matcher[0]);
        Assert.assertFalse((String)("Radio Button " + radioButton.getText() + " is selected"), (boolean)radioButton.isSelected());
        radioButton = new RadioButton(2, new Matcher[0]);
        Assert.assertFalse((String)("Radio Button " + radioButton.getText() + " is selected"), (boolean)radioButton.isSelected());
    }

    @Test
    public void findToggleButtonByIndexAndCheck() {
        int index = 2;
        ToggleButton toggleButton = new ToggleButton(index, new Matcher[0]);
        this.checkButton(TOGGLE_BUTTON_LABEL_PREFIX + index, (Button)toggleButton);
        Assert.assertTrue((String)("Toggle Button " + toggleButton.getText() + " is not selected"), (boolean)toggleButton.isSelected());
    }

    @Test
    public void findCheckBoxByIndexAndCheck() {
        int index = 1;
        CheckBox checkBox = new CheckBox(index, new Matcher[0]);
        this.checkButton(CHECK_BOX_LABEL_PREFIX + index, (Button)checkBox);
        Assert.assertTrue((String)("Check Box " + checkBox.getText() + " is not selected"), (boolean)checkBox.isChecked());
    }

    @Test
    public void findArrowButtonByIndexAndCheck() {
        int index = 2;
        this.checkButton(ARROW_BUTTON_LABEL_PREFIX + index, (Button)new ArrowButton(index, new Matcher[0]));
    }

    @Test
    public void findPushButtonByLabelAndCheck() {
        String label = "PUSH-BUTTON0";
        this.checkButton(label, (Button)new PushButton(label));
    }

    @Test
    public void findOkButtonByAndCheck() {
        String label = "PUSH-BUTTON0";
        this.checkButton(label, (Button)new PushButton(label));
    }

    @Test
    public void findRadioButtonByLabelAndCheck() {
        String label = "RADIO-BUTTON1";
        this.checkButton(label, (Button)new RadioButton(label));
    }

    @Test
    public void findToggleButtonByLabelAndCheck() {
        String label = "TOOGLE-BUTTON2";
        this.checkButton(label, (Button)new ToggleButton(label));
    }

    @Test
    public void findCheckBoxByLabelAndCheck() {
        String label = "CHECK-BOX1";
        this.checkButton(label, (Button)new CheckBox(label));
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingPushButtonByIndex() {
        new PushButton(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingRadioButtonByIndex() {
        new RadioButton(4, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingArrowButtonByIndex() {
        new ArrowButton(6, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingCheckBoxByIndex() {
        new CheckBox(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingToggleButtonByIndex() {
        new ToggleButton(4, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingPushButtonByLabel() {
        new PushButton("NON_EXISTING_#$SDFF@S");
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingRadioButtonByLabel() {
        new RadioButton("NON_EXISTING_@QWEDSA@");
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingCheckBoxByLabel() {
        new CheckBox("NON_EXISTING_DASLKJ");
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingToggleButtonByLabel() {
        new ToggleButton("NON_EXISTING_KL2FG");
    }

    private org.eclipse.reddeer.swt.api.Text getSelectionText() {
        if (this.selectionText == null) {
            this.selectionText = new DefaultText(0, new Matcher[0]);
        }
        return this.selectionText;
    }

    @Test
    public void toggleRadioButton() {
        int index = 1;
        RadioButton radioButton = new RadioButton(index, new Matcher[0]);
        if (radioButton.isSelected()) {
            new RadioButton(index - 1, new Matcher[0]).click();
        }
        Assert.assertTrue((String)("Radio Button " + radioButton.getText() + " is selected"), (!radioButton.isSelected() ? 1 : 0) != 0);
        radioButton.toggle(true);
        Assert.assertTrue((String)("Radio Button " + radioButton.getText() + " is not selected"), (boolean)radioButton.isSelected());
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(RADIO_BUTTON_LABEL_PREFIX + index));
        int pushButtonIndex = 0;
        new PushButton(0, new Matcher[0]).click();
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
        radioButton.toggle(true);
        Assert.assertTrue((String)"Selection Listener was invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
    }

    @Test
    public void toggleCheckBox() {
        int index = 1;
        CheckBox checkBox = new CheckBox(index, new Matcher[0]);
        if (checkBox.isChecked()) {
            checkBox.click();
        }
        Assert.assertTrue((String)("Check Box " + checkBox.getText() + " is checked"), (!checkBox.isChecked() ? 1 : 0) != 0);
        checkBox.toggle(true);
        Assert.assertTrue((String)("Check Box " + checkBox.getText() + " is not checked"), (boolean)checkBox.isChecked());
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(CHECK_BOX_LABEL_PREFIX + index));
        int pushButtonIndex = 0;
        new PushButton(0, new Matcher[0]).click();
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
        checkBox.toggle(true);
        Assert.assertTrue((String)"Selection Listener was invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
    }

    @Test
    public void toggleToggleButton() {
        int index = 1;
        ToggleButton toggleButton = new ToggleButton(index, new Matcher[0]);
        if (toggleButton.isSelected()) {
            toggleButton.click();
        }
        Assert.assertTrue((String)("Toggle Button " + toggleButton.getText() + " is checked"), (!toggleButton.isSelected() ? 1 : 0) != 0);
        toggleButton.toggle(true);
        Assert.assertTrue((String)("Toggle Button " + toggleButton.getText() + " is not checked"), (boolean)toggleButton.isSelected());
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(TOGGLE_BUTTON_LABEL_PREFIX + index));
        int pushButtonIndex = 0;
        new PushButton(0, new Matcher[0]).click();
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
        toggleButton.toggle(true);
        Assert.assertTrue((String)"Selection Listener was invoked", (boolean)this.getSelectionText().getText().equals(PUSH_BUTTON_LABEL_PREFIX + pushButtonIndex));
    }

    private void checkButton(String expectedText, Button button) {
        if (!expectedText.startsWith(ARROW_BUTTON_LABEL_PREFIX)) {
            Assert.assertTrue((String)("Expected button text is " + expectedText + "\nbut Button text is " + button.getText()), (boolean)button.getText().equals(expectedText));
        }
        String expectedToolTipText = TOOLTIP_PREFIX + expectedText;
        Assert.assertTrue((String)("Expected button tooltip text is " + expectedToolTipText + "\nbut Button tool tip text is " + button.getToolTipText()), (boolean)button.getToolTipText().equals(expectedToolTipText));
        button.click();
        Assert.assertTrue((String)"Selection Listener was not invoked", (boolean)this.getSelectionText().getText().equals(expectedText));
    }
}

