/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.list;

import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.swt.impl.list.DefaultList;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class DefaultListTest
extends SWTLayerTestCase {
    @Override
    public void createControls(Shell shell) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)shell, 2562);
        int i = 0;
        while (i < 5) {
            list.add("Item " + i);
            ++i;
        }
        list.setVisible(true);
        shell.pack();
    }

    @Test
    public void testGetListItems() {
        DefaultList list = new DefaultList();
        String[] items = list.getListItems();
        int i = 0;
        while (i < 5) {
            Assert.assertTrue((String)("Item " + i + " is not contained in returned list."), (boolean)Arrays.asList(items).contains("Item " + i));
            ++i;
        }
    }

    @Test
    public void testSelectSpecificItem() {
        DefaultList list = new DefaultList();
        list.select(2);
        Assert.assertTrue((String)"Item number 2 is not selected.", (list.getSelectionIndex() == 2 ? 1 : 0) != 0);
        list.select(3);
        Assert.assertFalse((String)"Item number 2 should not be selected.", (list.getSelectionIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Item number 3 is not selected.", (list.getSelectionIndex() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectSpecificItems() {
        DefaultList list = new DefaultList();
        list.select(new int[]{0, 1, 3});
        List<Integer> indices = Arrays.asList(list.getSelectionIndices()[0], list.getSelectionIndices()[1], list.getSelectionIndices()[2]);
        Assert.assertTrue((String)"Items with indices 0, 1 and 3 are not selected.", (indices.contains(0) && indices.contains(1) && indices.contains(3) ? 1 : 0) != 0);
        list.select(2);
        Assert.assertTrue((String)"Items was not unselected before next selection.", (list.getSelectedItems().length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetIndex() {
        DefaultList list = new DefaultList();
        list.select(1);
        Assert.assertTrue((String)"Items with indices 0, 1 and 3 are not selected.", (list.getSelectionIndex() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeselectAllItems() {
        DefaultList list = new DefaultList();
        list.select(new int[]{0, 1, 2});
        list.deselectAll();
        Assert.assertTrue((String)"There are still some selected items altought there should be none.", (list.getSelectedItems().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectAllItems() {
        DefaultList list = new DefaultList();
        list.select(new int[]{0, 1, 2});
        list.selectAll();
        Assert.assertTrue((String)"All items should be selected.", (list.getSelectedItems().length == 5 ? 1 : 0) != 0);
    }
}

