/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.menu;

import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.After;
import org.junit.Before;

public class AbstractMenuTest {
    public final String SHELL_TEXT = "MenuShell";
    public Text text;
    public Shell shell;
    Tree tree;

    @Before
    public void createMenus() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractMenuTest.this.shell = new Shell();
                AbstractMenuTest.this.shell.setMenuBar(AbstractMenuTest.this.getShellMenuBar(AbstractMenuTest.this.shell));
                AbstractMenuTest.this.shell.setMenu(AbstractMenuTest.this.getShellContextMenu(AbstractMenuTest.this.shell));
                AbstractMenuTest.this.shell.setText("MenuShell");
                AbstractMenuTest.this.tree = new Tree((Composite)AbstractMenuTest.this.shell, 4);
                ToolBar toolbar = new ToolBar((Composite)AbstractMenuTest.this.shell, 0x800000);
                ToolItem toolItem = new ToolItem(toolbar, 4);
                toolItem.setToolTipText("toolItemMenu");
                ToolItem toolItem1 = new ToolItem(toolbar, 8);
                toolItem1.setToolTipText("genericToolItem");
                DropdownSelectionListener dropdownListener = new DropdownSelectionListener(toolItem);
                dropdownListener.add("ToolItemMenuItem1");
                dropdownListener.add("ToolItemMenuItem2");
                dropdownListener.add("ToolItemMenuItem3");
                toolItem.addSelectionListener((SelectionListener)dropdownListener);
                RowDataFactory.swtDefaults().applyTo((Control)toolbar);
                TreeItem item = new TreeItem(AbstractMenuTest.this.tree, 0);
                item.setText("TreeItem1");
                TreeItem item2 = new TreeItem(AbstractMenuTest.this.tree, 0);
                item2.setText("TreeItem2");
                AbstractMenuTest.this.tree.setMenu(AbstractMenuTest.this.getTreeMenu(AbstractMenuTest.this.tree));
                AbstractMenuTest.this.text = new Text((Composite)AbstractMenuTest.this.shell, 0);
                AbstractMenuTest.this.text.setText("Test");
                AbstractMenuTest.this.text.setSize(100, 100);
                RowLayoutFactory.fillDefaults().applyTo((Composite)AbstractMenuTest.this.shell);
                RowDataFactory.swtDefaults().applyTo((Control)AbstractMenuTest.this.tree);
                RowDataFactory.swtDefaults().applyTo((Control)AbstractMenuTest.this.text);
                AbstractMenuTest.this.shell.layout();
                AbstractMenuTest.this.shell.open();
            }
        });
    }

    @After
    public void closeShell() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractMenuTest.this.shell != null && !AbstractMenuTest.this.shell.isDisposed()) {
                    AbstractMenuTest.this.shell.close();
                }
            }
        });
    }

    public Menu getShellMenuBar(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        MenuItem item = new MenuItem(menu, 64);
        item.setText("ShellMenuBarItem");
        Menu menu2 = new Menu((Decorations)shell, 4);
        item.setMenu(menu2);
        MenuItem item1 = new MenuItem(menu2, 64);
        item1.setText("ShellMenuBarItem1");
        return menu;
    }

    public Menu getShellContextMenu(Shell shell) {
        Menu menu = new Menu((Control)shell);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("ShellContextMenuItem");
        return menu;
    }

    public Menu getTreeMenu(final Tree tree) {
        Menu menu = new Menu((Control)tree);
        final MenuItem item1 = new MenuItem(menu, 8);
        this.addSelectionListener(item1);
        final MenuItem item2 = new MenuItem(menu, 8);
        this.addSelectionListener(item2);
        final MenuItem item3 = new MenuItem(menu, 64);
        this.addSelectionListener(item3);
        Menu menu2 = new Menu(menu);
        item3.setMenu(menu2);
        final MenuItem item4 = new MenuItem(menu2, 8);
        this.addSelectionListener(item4);
        final MenuItem item5 = new MenuItem(menu2, 8);
        this.addSelectionListener(item5);
        final MenuItem item6 = new MenuItem(menu, 32);
        final MenuItem item7 = new MenuItem(menu, 16);
        final MenuItem item8 = new MenuItem(menu, 64);
        Menu menu3 = new Menu(menu);
        item8.setMenu(menu3);
        menu3.setEnabled(false);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                String menuText = tree.getSelection()[0].getText();
                item1.setText(String.valueOf(menuText) + "MenuItem1");
                item2.setText(String.valueOf(menuText) + "MenuItem2");
                item3.setText(String.valueOf(menuText) + "MenuItemWithMenu");
                item4.setText(String.valueOf(menuText) + "MenuItemWithMenuEnabledChild");
                item5.setText(String.valueOf(menuText) + "MenuItemWithMenuDisabledChild");
                item5.setEnabled(false);
                item6.setText(String.valueOf(menuText) + "MenuItemCheck");
                item7.setText(String.valueOf(menuText) + "MenuItemRadio");
                item8.setText("DisabledMenu");
                super.menuShown(e);
            }
        });
        return menu;
    }

    public void addSelectionListener(final MenuItem item) {
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMenuTest.this.text.setText("selected " + item.getText());
            }
        });
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.dropdown = dropdown;
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    DropdownSelectionListener.this.dropdown.setText(selected.getText());
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            }
        }
    }
}

