/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.table;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.TableContainsItem;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.matcher.CheckedTableItemMatcher;
import org.eclipse.reddeer.swt.test.impl.table.AbstractTableTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTableTest
extends AbstractTableTest {
    @Test
    public void testMultiSelectionTable() {
        new DefaultTable().select(new int[]{1, 2, 3, 4, 5});
    }

    @Test
    public void testMultiSelectionTableWithSingleSelection() {
        new DefaultTable().select(new int[]{1});
    }

    @Test(expected=RedDeerException.class)
    public void testMultiSelectionTableCheck() {
        new DefaultTable().getItem(2).setChecked(true);
    }

    @Test
    public void testSingleSelectionTable() {
        new DefaultTable(1, new Matcher[0]).select(new int[]{1});
    }

    @Test
    public void testTableContainsItem() {
        Assert.assertTrue((boolean)new DefaultTable(1, new Matcher[0]).containsItem("x"));
        Assert.assertTrue((boolean)new DefaultTable(1, new Matcher[0]).containsItem("line 5 in nowhere", 6));
        Assert.assertFalse((boolean)new DefaultTable(1, new Matcher[0]).containsItem("this is not in table"));
    }

    @Test
    public void testDeselect() {
        DefaultTable table = new DefaultTable();
        table.select(new int[]{1});
        int selected = 0;
        List items = table.getItems();
        int i = 0;
        while (i < items.size()) {
            selected += ((TableItem)items.get(i)).isSelected() ? 1 : 0;
            ++i;
        }
        Assert.assertTrue((String)"Table should have at least one selected item", (selected >= 1 ? 1 : 0) != 0);
        table.deselectAll();
        selected = 0;
        items = table.getItems();
        i = 0;
        while (i < items.size()) {
            selected += ((TableItem)items.get(i)).isSelected() ? 1 : 0;
            ++i;
        }
        Assert.assertTrue((String)"Table should have no selected items", (selected == 0 ? 1 : 0) != 0);
    }

    @Test(expected=RedDeerException.class)
    public void testSingleSelectionTableWithMultiSelection() {
        new DefaultTable(1, new Matcher[0]).select(new int[]{1, 2, 3, 4});
    }

    @Test(expected=RedDeerException.class)
    public void testSingleSelectionTableCheck() {
        new DefaultTable(1, new Matcher[0]).getItem(1).setChecked(true);
    }

    @Test
    public void testSelectTableItem() {
        new DefaultTable(1, new Matcher[0]).getItem("line 100 in nowhere", 6).select();
        Assert.assertTrue((boolean)new DefaultTable(1, new Matcher[0]).getItem("line 100 in nowhere", 6).isSelected());
    }

    @Test
    public void testCheckTableSelection() {
        new DefaultTable(2, new Matcher[0]).select(new int[]{1});
    }

    @Test(expected=RedDeerException.class)
    public void testCheckTableWithMultiSelection() {
        new DefaultTable(2, new Matcher[0]).select(new int[]{1, 2, 3, 4});
    }

    @Test
    public void testCheckTable() {
        DefaultTable t = new DefaultTable(2, new Matcher[0]);
        t.getItem(1).setChecked(true);
        MatcherAssert.assertThat((Object)t.getItems(new Matcher[]{new CheckedTableItemMatcher()}).size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void doubleClickOnTableItem() {
        TableItem item = new DefaultTable(1, new Matcher[0]).getItem(0);
        Assert.assertEquals((Object)"x", (Object)item.getText());
        item.doubleClick();
        Assert.assertEquals((Object)"double click", (Object)item.getText());
    }

    @Test
    public void waitForTableItem() {
        new WaitUntil((WaitCondition)new TableContainsItem((Table)new DefaultTable(1, new Matcher[0]), "!", 2));
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void waitForNonExistingTableItem() {
        new WaitUntil((WaitCondition)new TableContainsItem((Table)new DefaultTable(1, new Matcher[0]), "this does not exist", 2));
    }

    @Test
    public void indexOfTest() {
        DefaultTable table = new DefaultTable();
        Assert.assertEquals((long)1L, (long)table.indexOf(table.getItem(1)));
    }

    @Test
    public void testHeaders() {
        DefaultTable table = new DefaultTable();
        List headers = table.getHeaders();
        Assert.assertTrue((String)"Header on index 0 is not correct", (boolean)((String)headers.get(0)).equals(" "));
        Assert.assertTrue((String)"Header on index 1 is not correct", (boolean)((String)headers.get(1)).equals("C"));
        Assert.assertTrue((String)"Header on index 2 is not correct", (boolean)((String)headers.get(2)).equals("!"));
        Assert.assertTrue((String)"Header on index 3 is not correct", (boolean)((String)headers.get(3)).equals("Description"));
        Assert.assertTrue((String)"Header on index 4 is not correct", (boolean)((String)headers.get(4)).equals("Resource"));
        Assert.assertTrue((String)"Header on index 5 is not correct", (boolean)((String)headers.get(5)).equals("In Folder"));
        Assert.assertTrue((String)"Header on index 6 is not correct", (boolean)((String)headers.get(6)).equals("Location"));
    }

    @Test
    public void testGetIndexOfHeader() {
        DefaultTable table = new DefaultTable();
        Assert.assertTrue((String)"Header index is not correct for header ' '", (table.getHeaderIndex(" ") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header 'C'", (table.getHeaderIndex("C") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header '!'", (table.getHeaderIndex("!") == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header 'Description'", (table.getHeaderIndex("Description") == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header 'Resource'", (table.getHeaderIndex("Resource") == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header 'In Folder'", (table.getHeaderIndex("In Folder") == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Header index is not correct for header 'Location'", (table.getHeaderIndex("Location") == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHeaderOnSpecifiedIndex() {
        DefaultTable table = new DefaultTable();
        Assert.assertTrue((String)"Header on index 0 is not correct", (boolean)table.getHeader(0).equals(" "));
        Assert.assertTrue((String)"Header on index 1 is not correct", (boolean)table.getHeader(1).equals("C"));
        Assert.assertTrue((String)"Header on index 2 is not correct", (boolean)table.getHeader(2).equals("!"));
        Assert.assertTrue((String)"Header on index 3 is not correct", (boolean)table.getHeader(3).equals("Description"));
        Assert.assertTrue((String)"Header on index 4 is not correct", (boolean)table.getHeader(4).equals("Resource"));
        Assert.assertTrue((String)"Header on index 5 is not correct", (boolean)table.getHeader(5).equals("In Folder"));
        Assert.assertTrue((String)"Header on index 6 is not correct", (boolean)table.getHeader(6).equals("Location"));
    }

    @Test(expected=SWTLayerException.class)
    public void testGetNegativeIndexHeader() {
        new DefaultTable().getHeader(-1);
    }

    @Test(expected=SWTLayerException.class)
    public void testGetTooHighIndexHeader() {
        new DefaultTable().getHeader(10);
    }

    @Test(expected=SWTLayerException.class)
    public void testGetIndexOfNonexistingHeader() {
        new DefaultTable().getHeaderIndex("I do not exist");
    }

    @Test
    public void testGetSelectedItemsSingle() {
        DefaultTable table = new DefaultTable();
        table.select(new int[]{2});
        List selectedTableItems = table.getSelectetItems();
        int numSelected = selectedTableItems.size();
        Assert.assertTrue((String)("Only one Table Item has to be selected but " + numSelected + " are."), (numSelected == 1 ? 1 : 0) != 0);
        TableItem expectedSelectedItem = table.getItem(2);
        TableItem selectedItem = (TableItem)selectedTableItems.get(0);
        Assert.assertTrue((String)("Selected tree item is not correct: " + selectedItem.getText()), (boolean)expectedSelectedItem.getText(6).equals(selectedItem.getText(6)));
    }

    @Test
    public void testGetSelectedItemsMulti() {
        DefaultTable table = new DefaultTable();
        table.select(new int[]{1, 3});
        List selectedTableItems = table.getSelectetItems();
        int numSelected = selectedTableItems.size();
        Assert.assertTrue((String)("Two Table Item has to be selected but " + numSelected + " are."), (numSelected == 2 ? 1 : 0) != 0);
        TableItem expectedSelectedItem = table.getItem(1);
        TableItem selectedItem = (TableItem)selectedTableItems.get(0);
        Assert.assertTrue((String)("Selected tree item is not correct: " + selectedItem.getText()), (boolean)expectedSelectedItem.getText(6).equals(selectedItem.getText(6)));
        expectedSelectedItem = table.getItem(3);
        selectedItem = (TableItem)selectedTableItems.get(1);
        Assert.assertTrue((String)("Selected tree item is not correct: " + selectedItem.getText()), (boolean)expectedSelectedItem.getText(6).equals(selectedItem.getText(6)));
    }
}

