/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.tree;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;

public abstract class AbstractTreeTest
extends SWTLayerTestCase {
    protected static final int TREE_COLUMN_COUNT = 3;
    private Tree swtTree;

    @Override
    protected void createControls(Shell shell) {
        this.swtTree = new Tree((Composite)shell, 2082);
        TreeColumn column = new TreeColumn(this.swtTree, 16384);
        column.setText("Column1");
        column.setWidth(200);
        TreeColumn column2 = new TreeColumn(this.swtTree, 0x1000000);
        column2.setText("Column2");
        column2.setWidth(200);
        TreeColumn column3 = new TreeColumn(this.swtTree, 131072);
        column3.setText("Column3");
        column3.setWidth(200);
    }

    protected void createTreeItems(Tree tree) {
        this.createTreeItems(tree, 0);
    }

    protected void createTreeItems(Tree tree, int cellIndex) {
        Assert.assertTrue((String)String.format("cellIndex set to %d, cannot fit into testing tree with %d columns", cellIndex, 3), (cellIndex < 3 ? 1 : 0) != 0);
        this.removeTreeItems(tree);
        TreeItem itemA = this.createTreeItem(tree, "A", cellIndex);
        TreeItem itemAA = this.createTreeItem(itemA, "AA", cellIndex);
        this.createTreeItem(itemAA, "AAA", cellIndex);
        this.createTreeItem(itemAA, "AAB", cellIndex);
        TreeItem itemB = this.createTreeItem(tree, "B", cellIndex);
        this.createTreeItem(itemB, "BB", cellIndex);
        this.createTreeItem(tree, "C", cellIndex);
    }

    protected TreeItem createTreeItem(Tree tree, String text) {
        return this.createTreeItem(tree, text, 0);
    }

    private TreeItem createTreeItem(final Tree tree, final String text, final int cellIndex) {
        return (TreeItem)Display.syncExec((ResultRunnable)new ResultRunnable<TreeItem>(){

            public TreeItem run() {
                TreeItem item = new TreeItem(tree, 0);
                item.setText(cellIndex, text);
                return item;
            }
        });
    }

    private TreeItem createTreeItem(final TreeItem treeItem, final String text, final int cellIndex) {
        return (TreeItem)Display.syncExec((ResultRunnable)new ResultRunnable<TreeItem>(){

            public TreeItem run() {
                TreeItem item = new TreeItem(treeItem, 0);
                item.setText(cellIndex, text);
                return item;
            }
        });
    }

    protected void removeTreeItems(final Tree tree) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                tree.removeAll();
            }
        });
    }
}

