/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.impl.view;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatchers;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.api.View;
import org.eclipse.reddeer.workbench.condition.ViewIsOpen;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchShellLookup;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.reddeer.workbench.handler.WorkbenchPartHandler;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.eclipse.reddeer.workbench.lookup.ViewLookup;
import org.eclipse.reddeer.workbench.part.AbstractWorkbenchPart;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public abstract class AbstractView
extends AbstractWorkbenchPart
implements View {
    private static final String SHOW_VIEW = "Show View";
    protected static final Logger log = Logger.getLogger(AbstractView.class);
    protected String[] path;
    protected Matcher<String> viewTitle;

    public AbstractView(String viewTitle) {
        this((Matcher<String>)new WithTextMatcher((Matcher)new RegexMatcher("\\*?" + viewTitle)));
    }

    public AbstractView(Matcher<String> viewTitle) {
        super(null);
        this.viewTitle = viewTitle;
        this.path = ViewLookup.getInstance().findRegisteredViewPath(viewTitle);
    }

    @Override
    public void activate() {
        this.checkOpen();
        log.info("Activate view " + this.getTitle());
        this.cTabItem.activate();
        WorkbenchPartHandler.getInstance().focusChildControl(WorkbenchPartLookup.getInstance().getActiveWorkbenchPart());
    }

    @Override
    public String getTitle() {
        this.checkOpen();
        return super.getTitle();
    }

    @Override
    public String getTitleToolTip() {
        this.checkOpen();
        return super.getTitleToolTip();
    }

    @Override
    public Image getTitleImage() {
        this.checkOpen();
        return super.getTitleImage();
    }

    @Override
    public boolean isActive() {
        this.checkOpen();
        return super.isActive();
    }

    @Override
    public void close() {
        this.checkOpen();
        this.activate();
        log.info("Close view '" + this.getTitle() + "'");
        this.cTabItem.close();
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            log.info("View '" + this.viewTitle + "' is already open. Activate.");
        } else {
            log.info("Open '" + this.viewTitle + "' view via menu.");
            this.openViaMenu();
        }
        this.activate();
    }

    private void openViaMenu() {
        WithTextMatchers m = new WithTextMatchers((Matcher[])new RegexMatcher[]{new RegexMatcher("Window.*"), new RegexMatcher("Show View.*"), new RegexMatcher("Other...*")});
        ShellMenuItem menu = new ShellMenuItem((org.eclipse.reddeer.swt.api.Shell)new WorkbenchShell(), m.getMatchers());
        menu.select();
        DefaultShell showView = new DefaultShell(SHOW_VIEW);
        new DefaultTreeItem(this.path).select();
        WidgetIsFound openButton = new WidgetIsFound(Button.class, new Matcher[]{new WithMnemonicTextMatcher("Open")});
        Object button = openButton.test() ? new PushButton("Open") : new OkButton();
        button.click();
        new GroupWait(new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)showView)), WaitProvider.waitUntil((WaitCondition)new ViewIsOpen(this))});
    }

    @Override
    public boolean isOpen() {
        if (this.cTabItem != null && !this.cTabItem.isDisposed()) {
            return true;
        }
        Shell workbenchShell = WorkbenchShellLookup.getInstance().getWorkbenchShell();
        Class<CTabItem> clazz = CTabItem.class;
        WidgetIsFound found = new WidgetIsFound(clazz, (Control)workbenchShell, new Matcher[]{new WithTextMatcher(this.viewTitle)});
        return found.test();
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new WorkbenchLayerException("View '" + this.viewTitle + "' is not open");
        }
        if (this.cTabItem == null || this.cTabItem.isDisposed()) {
            this.cTabItem = new DefaultCTabItem((ReferencedComposite)new WorkbenchShell(), new Matcher[]{this.viewTitle});
        }
    }
}

