/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.matcher.MatcherBuilder;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ObjectUtil;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.ClassMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.core.resolver.WidgetResolver;
import org.eclipse.reddeer.core.util.DiagnosticTool;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class WidgetLookup {
    private static WidgetLookup instance = null;
    private static final Logger logger = Logger.getLogger(WidgetLookup.class);

    private WidgetLookup() {
    }

    public static WidgetLookup getInstance() {
        if (instance == null) {
            instance = new WidgetLookup();
        }
        return instance;
    }

    public <T extends Widget> T activeWidget(ReferencedComposite refComposite, Class<T> clazz, int index, Matcher ... matchers) {
        return this.activeWidget(refComposite, clazz, index, TimePeriod.SHORT, matchers);
    }

    public <T extends Widget> T activeWidget(ReferencedComposite refComposite, Class<T> clazz, int index, TimePeriod timePeriod, Matcher ... matchers) {
        logger.debug("Looking up active widget with class type " + clazz.getName() + this.createRererencedCompositeDebugMsg(refComposite) + ", index " + index + " and " + this.createMatcherDebugMsg(matchers));
        Control parentControl = this.getParentControl(refComposite);
        WidgetIsFound found = new WidgetIsFound(clazz, parentControl, index, matchers);
        try {
            new WaitUntil((WaitCondition)found, timePeriod);
        }
        catch (WaitTimeoutExpiredException ex) {
            String exceptionText = "No matching widget found with " + found.getAndMatcher().toString();
            exceptionText = String.valueOf(exceptionText) + "\n" + new DiagnosticTool().getDiagnosticInformation(parentControl);
            logger.error("Active widget with class type " + clazz.getName() + " and index " + index + " was not found");
            throw new CoreLayerException(exceptionText, ex);
        }
        logger.debug("Active widget with class type " + clazz.getName() + " and index " + index + " was found");
        return (T)found.getResult();
    }

    private String createRererencedCompositeDebugMsg(ReferencedComposite refComposite) {
        StringBuilder sb = new StringBuilder();
        if (refComposite == null) {
            sb.append(" with no referenced composite specified");
        } else {
            sb.append(" with referenced composite " + refComposite.getClass());
        }
        return sb.toString();
    }

    public <T extends Widget> List<T> activeWidgets(ReferencedComposite refComposite, Class<T> clazz, Matcher<?> ... matchers) {
        logger.debug("Looking up active widgets with class type " + clazz.getName() + " and " + this.createMatcherDebugMsg(matchers));
        ClassMatcher cm = new ClassMatcher(clazz);
        Matcher[] allMatchers = MatcherBuilder.getInstance().addMatcher(matchers, (Matcher)cm);
        AndMatcher am = new AndMatcher(allMatchers);
        List<T> foundWidgets = this.activeWidgets(refComposite.getControl(), (Matcher)am);
        logger.debug("Found " + foundWidgets.size() + " widgets");
        return foundWidgets;
    }

    private Control getParentControl(ReferencedComposite refComposite) {
        if (refComposite == null) {
            return this.findParent();
        }
        return refComposite.getControl();
    }

    public Control findParent() {
        logger.debug("No parent specified, finding one");
        Control parent = this.getActiveWidgetParentControl();
        logger.debug("Parent found successfully");
        if (parent == null) {
            logger.error("Unable to determine active parent");
            throw new CoreLayerException("Unable to determine active parent");
        }
        return parent;
    }

    public <T extends Widget> List<T> activeWidgets(Control refComposite, Matcher matcher) {
        logger.trace("Looking up widgets with specified parent and matchers");
        List<T> widgets = this.findControls((Widget)refComposite, matcher, true);
        logger.trace(String.valueOf(widgets.size()) + " widget(s) found");
        return widgets;
    }

    public <T extends Widget> T activeWidget(Control refComposite, Matcher matcher, int index) {
        String widgetDescription = "widget with index " + index;
        logger.trace("Looking up " + widgetDescription + " with specified parent and matchers");
        T widget = this.findControl((Widget)refComposite, matcher, true, index);
        logger.trace(String.valueOf(widgetDescription) + (widget != null ? " is found" : "is not found"));
        return widget;
    }

    public boolean isExtraShellActive() {
        Shell activeWorkbenchParentShell = null;
        if (this.getWorkbenchLookup() != null) {
            activeWorkbenchParentShell = this.getWorkbenchLookup().getShellForActiveWorkbench();
        }
        Shell activeShell = ShellLookup.getInstance().getActiveShell();
        return activeWorkbenchParentShell == null || activeWorkbenchParentShell != activeShell;
    }

    public Control getActiveWidgetParentControl() {
        Shell control = null;
        Shell activeWorkbenchParentShell = null;
        if (this.getWorkbenchLookup() != null) {
            activeWorkbenchParentShell = this.getWorkbenchLookup().getShellForActiveWorkbench();
        }
        Shell activeShell = ShellLookup.getInstance().getActiveShell();
        if (!(activeWorkbenchParentShell != null && activeWorkbenchParentShell.equals(activeShell) || activeShell == null)) {
            logger.trace("Setting active shell with title \"" + ShellHandler.getInstance().getText(activeShell) + "\" as the parent");
            control = activeShell;
        } else if (this.getWorkbenchLookup() != null && this.getWorkbenchLookup().getActiveWorkbenchPartTitle() != null) {
            logger.trace("Setting workbench part with title \"" + this.getWorkbenchLookup().getActiveWorkbenchPartTitle() + "\"as the parent");
            control = this.getWorkbenchLookup().getActiveWorkbenchPartControl();
        }
        return control;
    }

    public <T extends Widget> T getProperWidget(List<T> widgets, int index) {
        Widget widget = null;
        if (widgets.size() > index) {
            logger.trace("Selecting widget with the specified index (" + index + ")");
            widget = (Widget)widgets.get(index);
        } else {
            logger.trace("The specified index is bigger than the size of found widgets (" + index + " > " + widgets.size() + ")");
        }
        return (T)widget;
    }

    public <T extends Widget> List<T> findActiveParentControls(Matcher<T> matcher, boolean recursive) {
        List<T> findControls = this.findControls((Widget)this.getActiveWidgetParentControl(), matcher, recursive);
        return findControls;
    }

    private <T extends Widget> List<T> findControls(Widget parentWidget, Matcher<T> matcher, boolean recursive) {
        return this.findControlsUI(parentWidget, matcher, recursive);
    }

    private <T extends Widget> T findControl(Widget parentWidget, Matcher<T> matcher, boolean recursive, int index) {
        return this.findControlUI(parentWidget, matcher, recursive, new Index(index));
    }

    public Control getFocusControl() {
        Control c = (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                Control focusControl = Display.getDisplay().getFocusControl();
                return focusControl;
            }
        });
        return c;
    }

    private <T extends Widget> List<T> findControlsUI(final Widget parentWidget, Matcher<T> matcher, boolean recursive) {
        if (parentWidget == null || parentWidget.isDisposed()) {
            return new ArrayList();
        }
        if (!this.visible(parentWidget)) {
            return new ArrayList();
        }
        LinkedHashSet<Object> controls = new LinkedHashSet<Object>();
        if (matcher.matches((Object)parentWidget) && !controls.contains(parentWidget)) {
            try {
                controls.add(parentWidget);
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("The specified matcher should only match against is declared type.", exception);
            }
        }
        if (recursive) {
            List children = (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<Widget>>(){

                public List<Widget> run() {
                    List<Widget> children;
                    block2: {
                        children = null;
                        try {
                            children = WidgetResolver.getInstance().getChildren(parentWidget);
                        }
                        catch (SWTException e) {
                            if (parentWidget.isDisposed()) break block2;
                            throw e;
                        }
                    }
                    return children;
                }
            });
            controls.addAll(this.findControlsUI(children, matcher, recursive));
        }
        return new ArrayList(controls);
    }

    private <T extends Widget> T findControlUI(final Widget parentWidget, Matcher<T> matcher, boolean recursive, Index index) {
        if (parentWidget == null || parentWidget.isDisposed() || !this.visible(parentWidget)) {
            return null;
        }
        if (matcher.matches((Object)parentWidget)) {
            try {
                Widget control = parentWidget;
                if (index.isFirst()) {
                    return (T)control;
                }
                index.passed();
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("The specified matcher should only match against is declared type.", exception);
            }
        }
        if (recursive) {
            List children = (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<Widget>>(){

                public List<Widget> run() {
                    return WidgetResolver.getInstance().getChildren(parentWidget);
                }
            });
            return this.findControlUI(children, matcher, recursive, index);
        }
        return null;
    }

    private <T extends Widget> List<T> findControlsUI(List<Widget> widgets, Matcher<T> matcher, boolean recursive) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        for (Widget w : widgets) {
            list.addAll(this.findControlsUI(w, matcher, recursive));
        }
        return new ArrayList(list);
    }

    private <T extends Widget> T findControlUI(List<Widget> widgets, Matcher<T> matcher, boolean recursive, Index index) {
        for (Widget w : widgets) {
            T control = this.findControlUI(w, matcher, recursive, index);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    private boolean visible(final Widget w) {
        if (w.isDisposed()) {
            return false;
        }
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return !(w instanceof Control) || ((Control)w).getVisible();
            }
        });
    }

    private String createMatcherDebugMsg(Matcher<?>[] matchers) {
        StringBuilder sb = new StringBuilder();
        if (matchers.length == 0) {
            sb.append("no matchers specified");
        } else {
            sb.append("following matchers specified (");
        }
        int ind = 0;
        while (ind < matchers.length) {
            sb.append(matchers[ind].toString());
            if (ind < matchers.length - 1) {
                sb.append(", ");
            } else {
                sb.append(")");
            }
            ++ind;
        }
        return sb.toString();
    }

    private WorkbenchPartLookup getWorkbenchLookup() {
        try {
            WorkbenchPartLookup wp = WorkbenchPartLookup.getInstance();
            return wp;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.trace("Workbench not available");
            return null;
        }
    }

    public <T extends Control> String getLabel(final T control) {
        String label = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                Composite parent = control.getParent();
                if (parent != null) {
                    List<Widget> children = WidgetResolver.getInstance().getChildren((Widget)parent);
                    for (Widget child : children) {
                        Object layoutData;
                        if (!(child instanceof Label) && !(child instanceof CLabel) || !((layoutData = ((Control)child).getLayoutData()) instanceof FormData)) continue;
                        FormData formData = (FormData)layoutData;
                        if (formData.right == null || !control.equals(formData.right.control)) continue;
                        if (child instanceof Label) {
                            return ((Label)child).getText();
                        }
                        if (!(child instanceof CLabel)) continue;
                        return ((CLabel)child).getText();
                    }
                }
                return null;
            }
        });
        if (label == null && ControlHandler.getInstance().getParent(control) != null) {
            final List<Control> allWidgets = this.findAllParentWidgets((Control)ControlHandler.getInstance().getParent(control));
            label = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

                public String run() {
                    int widgetIndex = allWidgets.indexOf(control);
                    if (widgetIndex < 0) {
                        return null;
                    }
                    ListIterator listIterator = allWidgets.listIterator(widgetIndex);
                    while (listIterator.hasPrevious()) {
                        CLabel cLabel;
                        Label label;
                        Widget previousWidget = (Widget)listIterator.previous();
                        if (previousWidget instanceof Label && (label = (Label)previousWidget).getImage() == null) {
                            return label.getText();
                        }
                        if (!(previousWidget instanceof CLabel) || (cLabel = (CLabel)previousWidget).getImage() != null) continue;
                        return cLabel.getText();
                    }
                    return null;
                }
            });
        }
        if (label != null) {
            label = label.replaceAll("&", "").split("\t")[0];
        }
        return label;
    }

    public List<Control> findAllParentWidgets(Control control) {
        Object parent = null;
        Shell controlShell = ControlHandler.getInstance().getShell(control);
        Shell activeWorkbenchParentShell = null;
        if (this.getWorkbenchLookup() != null) {
            activeWorkbenchParentShell = this.getWorkbenchLookup().getShellForActiveWorkbench();
        }
        parent = controlShell.equals(activeWorkbenchParentShell) ? this.getWorkbenchLookup().getActiveWorkbenchPartControl() : controlShell;
        List<Control> allWidgets = this.findControls((Widget)parent, (Matcher)new BaseMatcher<Control>(){

            public boolean matches(Object obj) {
                return true;
            }

            public void describeTo(Description desc) {
            }
        }, true);
        return allWidgets;
    }

    public List<Widget> getPathToWidget(final Widget widget, final Class<?> ... classFilter) {
        final Control firstParent = this.getParent(widget);
        List parents = (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<Widget>>(){

            public List<Widget> run() {
                LinkedList<Widget> result = new LinkedList<Widget>();
                if (WidgetLookup.this.isClassOf(widget.getClass(), classFilter)) {
                    result.add(widget);
                }
                Control control = firstParent;
                while (control != null) {
                    if (WidgetLookup.this.isClassOf(control.getClass(), classFilter)) {
                        result.addFirst((Widget)control);
                    }
                    control = control.getParent();
                }
                return result;
            }
        });
        return parents;
    }

    private boolean isClassOf(Class<?> clazz, Class<?>[] classes) {
        boolean filterPassed = false;
        if (classes != null && classes.length > 0) {
            int index = 0;
            while (!filterPassed && index < classes.length) {
                if (clazz.getName().equals(classes[index].getName())) {
                    filterPassed = true;
                }
                ++index;
            }
        } else {
            filterPassed = true;
        }
        return filterPassed;
    }

    private Control getParent(Widget widget) {
        Object o = ObjectUtil.invokeMethod((Object)widget, (String)"getParent");
        if (o == null) {
            return null;
        }
        if (o instanceof Control) {
            return (Control)o;
        }
        throw new RedDeerException("Return value of method getObject() on class " + o.getClass() + " should be Control, but was " + o.getClass());
    }

    private static class Index {
        private int value;

        public Index(int index) {
            this.value = index;
        }

        public boolean isFirst() {
            return this.value <= 0;
        }

        public void passed() {
            --this.value;
        }
    }
}

