/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui;

import java.io.File;
import java.io.FileWriter;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.ProjectItem;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.AbstractExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public abstract class AbstractResourceTest {
    public static final String PROJECT_NAME = "ProjectItemTestProject";
    public static final String PROJECT_ITEM_TEXT = "src";
    public static final String DEFAULT_PACKAGE_TEXT = "(default package)";
    protected static final String JAVA_CLASS_NAME = "TestClass";
    protected static final String JAVA_CLASS_NAME_1 = "TestClass1";
    protected static final String JAVA_CLASS_FILE_NAME = "TestClass.java";
    protected static AbstractExplorer explorer;
    protected ProjectItem projectItem;

    public AbstractResourceTest(AbstractExplorer explorer) {
        AbstractResourceTest.explorer = explorer;
    }

    @BeforeClass
    public static void importProject() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME);
        dialog.finish();
        AbstractResourceTest.createJavaClass(JAVA_CLASS_NAME);
        AbstractResourceTest.createJavaClass(JAVA_CLASS_NAME_1);
    }

    @Before
    public void setUp() {
        explorer.open();
        this.projectItem = explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{PROJECT_ITEM_TEXT});
        new ConsoleView().open();
    }

    @After
    public void tearDown() {
        explorer.close();
    }

    @AfterClass
    public static void deleteProject() {
        explorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)explorer.getProject(PROJECT_NAME), (boolean)true);
        explorer = null;
    }

    @Test
    public void select() {
        this.projectItem.select();
        this.projectItem.getTreeItem().collapse();
        Assert.assertTrue((String)"Project item src is not selected", (boolean)this.projectItem.isSelected());
    }

    protected void open(String ... projectItemPath) {
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{PROJECT_ITEM_TEXT}).select();
        EditorHandler.getInstance().closeAll(true);
        explorer.getProject(PROJECT_NAME).getProjectItem(projectItemPath).open();
        Assert.assertTrue((String)"Active Editor has to have title TestClass.java", (boolean)new DefaultEditor().getTitle().equals(JAVA_CLASS_FILE_NAME));
    }

    protected void selectNonVisibleItem(String ... projectItemPath) {
        explorer.activate();
        DefaultProject project = explorer.getProject(PROJECT_NAME);
        project.getProjectItem(new String[]{PROJECT_ITEM_TEXT}).select();
        EditorHandler.getInstance().closeAll(true);
        explorer.activate();
        ProjectItem projectItem = project.getProjectItem(projectItemPath);
        project.collapse();
        project.select();
        projectItem.select();
        Assert.assertTrue((String)"Project item is not selected.", (boolean)projectItem.isSelected());
    }

    @Test
    public void asyncDelete() throws Exception {
        this.projectItem.select();
        BasicNewFileResourceWizard wizard = new BasicNewFileResourceWizard();
        wizard.open();
        WizardNewFileCreationPage filePage = new WizardNewFileCreationPage((ReferencedComposite)wizard);
        filePage.setFileName("text.txt");
        filePage.setFolderPath(new String[]{PROJECT_NAME, PROJECT_ITEM_TEXT, "files"});
        wizard.finish();
        new DefaultEditor("text.txt").close();
        String rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath();
        File file = new File(String.valueOf(rootPath) + "/" + PROJECT_NAME + "/src/text.txt");
        FileWriter out = new FileWriter(file);
        out.write("Hello World");
        out.flush();
        out.close();
        ProjectItem folder = explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{PROJECT_ITEM_TEXT, "files"});
        folder.delete();
        Assert.assertFalse((String)"Project ProjectItemTestProject contains project item src but it should be deleted.", (boolean)explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{PROJECT_ITEM_TEXT}).containsResource(new String[]{"files"}));
    }

    @Test
    public void testExpand() {
        this.projectItem.collapse();
        Assert.assertFalse((boolean)this.projectItem.isExpanded());
        Assert.assertFalse((boolean)this.projectItem.getTreeItem().isExpanded());
        this.projectItem.expand();
        Assert.assertTrue((boolean)this.projectItem.isExpanded());
        Assert.assertTrue((boolean)this.projectItem.getTreeItem().isExpanded());
    }

    protected static void createJavaClass(String javaClassName) {
        NewClassCreationWizard newJavaClassDialog = new NewClassCreationWizard();
        newJavaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)newJavaClassDialog);
        wizardPage.setName(javaClassName);
        newJavaClassDialog.finish();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
    }
}

