/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.perspectives;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatchers;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;

public abstract class AbstractPerspective {
    protected final Logger log = Logger.getLogger(this.getClass());
    private String perspectiveLabel;

    public AbstractPerspective(String perspectiveLabel) {
        this.perspectiveLabel = perspectiveLabel;
        if (!this.isPerspectiveAvailable()) {
            throw new EclipseLayerException("Perspective " + perspectiveLabel + " isn't available");
        }
    }

    public void open() {
        this.log.info("Open perspective: '" + this.getPerspectiveLabel() + "'");
        if (this.isOpened()) {
            this.log.debug("Perspective '" + this.getPerspectiveLabel() + "' is already opened.");
        } else {
            this.log.debug("Trying to open perspective: '" + this.getPerspectiveLabel() + "'");
            new DefaultToolItem((ReferencedComposite)new DefaultShell(), "Open Perspective").click();
            DefaultShell perspectiveShell = new DefaultShell("Open Perspective");
            DefaultTable table = new DefaultTable();
            try {
                table.select(new String[]{this.getPerspectiveLabel()});
            }
            catch (CoreLayerException coreLayerException) {
                table.select(new String[]{String.valueOf(this.getPerspectiveLabel()) + " (default)"});
            }
            WidgetIsFound openButton = new WidgetIsFound(Button.class, new Matcher[]{new WithMnemonicTextMatcher("Open")});
            Object button = openButton.test() ? new PushButton("Open") : new OkButton();
            button.click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)perspectiveShell));
        }
    }

    public void reset() {
        ShellMenuItem menu;
        if (!this.isOpened()) {
            throw new EclipseLayerException("Trying to reset perspective that is not open");
        }
        WithTextMatchers m = new WithTextMatchers((Matcher[])new RegexMatcher[]{new RegexMatcher("Window.*"), new RegexMatcher("Reset Perspective...")});
        try {
            menu = new ShellMenuItem(m.getMatchers());
        }
        catch (CoreLayerException coreLayerException) {
            m = new WithTextMatchers((Matcher[])new RegexMatcher[]{new RegexMatcher("Window.*"), new RegexMatcher("Perspective.*"), new RegexMatcher("Reset Perspective...")});
            menu = new ShellMenuItem(m.getMatchers());
        }
        menu.select();
        new DefaultShell("Reset Perspective");
        new YesButton().click();
    }

    public String getPerspectiveLabel() {
        return this.perspectiveLabel;
    }

    public boolean isOpened() {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return AbstractPerspective.this.getActivePerspective().getLabel().equals(AbstractPerspective.this.perspectiveLabel);
            }
        });
    }

    private boolean isPerspectiveAvailable() {
        IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithLabel(this.perspectiveLabel);
        return perspective != null;
    }

    private IPerspectiveDescriptor getActivePerspective() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
    }
}

