/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.screenshot;

import java.io.File;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.junit.AssumptionViolatedException;

public class ScreenshotCapturer {
    private static final Logger logger = new Logger(ScreenshotCapturer.class);
    public static final String SEPARATOR = System.getProperty("file.separator");
    private static ScreenshotCapturer instance;

    private ScreenshotCapturer() {
    }

    public static ScreenshotCapturer getInstance() {
        if (instance == null) {
            instance = new ScreenshotCapturer();
        }
        return instance;
    }

    public void captureScreenshotOnFailure(String config, String name) throws CaptureScreenshotException {
        if (RedDeerProperties.CAPTURE_SCREENSHOT.getBooleanValue()) {
            String path = this.getPath(config);
            this.createDirectories(path);
            this.captureScreenshot(String.valueOf(path) + name + ".png");
        } else {
            logger.warn("Screenshot has not been captured on failure, because RedDeer property whether screenshot should be captured or not is set to false.");
        }
    }

    private String getPath(String config) {
        String path = RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getValue() != null ? RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getValue() : "." + SEPARATOR + "target" + SEPARATOR + "screenshots";
        if (!SEPARATOR.equals(Character.valueOf(path.charAt(path.length() - 1)))) {
            path = String.valueOf(path) + SEPARATOR;
        }
        if (config != null) {
            path = String.valueOf(path) + config + SEPARATOR;
        }
        return path;
    }

    public String captureScreenshot(String screenshotFileName) throws CaptureScreenshotException {
        String alteredFileName = this.getAlteredScreenshotFileName(screenshotFileName);
        final String fileName = this.createMissingDirectories(alteredFileName);
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                GC gc = new GC((Drawable)display);
                Image image = null;
                try {
                    try {
                        logger.debug("Capturing Screenshot: " + fileName);
                        image = new Image((Device)display, display.getBounds().width, display.getBounds().height);
                        gc.copyArea(image, display.getBounds().x, display.getBounds().y);
                        ImageLoader imageLoader = new ImageLoader();
                        imageLoader.data = new ImageData[]{image.getImageData()};
                        imageLoader.save(fileName, 5);
                        logger.debug("Screenshot successfully captured. Saved in " + new File(fileName).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error("Capturing screenshot failed", (Throwable)ex);
                        ScreenshotCapturer.this.handleCorruptedScreenshot(fileName);
                        gc.dispose();
                        if (image != null) {
                            image.dispose();
                        }
                    }
                }
                finally {
                    gc.dispose();
                    if (image != null) {
                        image.dispose();
                    }
                }
            }
        });
        return fileName;
    }

    private void handleCorruptedScreenshot(String fileName) {
        logger.debug("Screenshot capturing failed.");
        if (new File(fileName).exists()) {
            try {
                logger.debug("Corrupted image will be deleted on exit.");
                new File(fileName).deleteOnExit();
            }
            catch (Exception exception) {}
        }
    }

    private String createMissingDirectories(String fileName) throws CaptureScreenshotException {
        if (!fileName.contains(SEPARATOR)) {
            String path = "." + SEPARATOR + "target" + SEPARATOR + "custom-screenshots";
            this.createDirectories(path);
            return String.valueOf(path) + SEPARATOR + fileName;
        }
        this.createDirectories(fileName.substring(0, fileName.lastIndexOf(SEPARATOR)));
        return fileName;
    }

    public static final String getScreenshotFileName(Class<?> testClass, String testMethod, String detail) {
        return String.valueOf(testClass.getName()) + (testMethod != null ? "." + testMethod : "") + (detail != null ? "@" + detail : "");
    }

    public void createDirectories(String path) throws CaptureScreenshotException {
        try {
            String[] dirs = SEPARATOR.equals("\\") ? path.split("\\\\") : path.split(SEPARATOR);
            int index = dirs.length;
            boolean checkpoint = false;
            String tmpPath = "";
            int i = 0;
            while (i < dirs.length) {
                if (!new File(tmpPath = String.valueOf(tmpPath) + dirs[i] + SEPARATOR).exists()) {
                    if (!checkpoint) {
                        checkpoint = true;
                        index = i;
                    }
                    if (!new File(tmpPath).mkdir()) {
                        int k = i - 1;
                        while (k >= index) {
                            new File(tmpPath).delete();
                            --k;
                        }
                        throw new RuntimeException("Directories for screenshot storage have not been created successfully. Screenshot will not be captured and created directories were removed.");
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new CaptureScreenshotException(ex.getMessage(), ex.getCause());
        }
    }

    public static boolean shouldCaptureScreenshotOnException(Throwable throwable) {
        return !(throwable instanceof AssumptionViolatedException);
    }

    private String getAlteredScreenshotFileName(String screenshotFileName) {
        String fileName = screenshotFileName;
        String fileExtension = ".png";
        if (!screenshotFileName.contains(fileExtension)) {
            fileName = String.valueOf(fileName) + fileExtension;
        }
        String partialFileName = fileName.substring(0, fileName.lastIndexOf("."));
        int counter = 2;
        if (new File(fileName).exists()) {
            while (new File(String.valueOf(partialFileName) + "(" + counter + ")" + fileExtension).exists()) {
                ++counter;
            }
            return String.valueOf(partialFileName) + "(" + counter + ")" + fileExtension;
        }
        return String.valueOf(partialFileName) + fileExtension;
    }
}

