/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.openperspective;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.eclipse.ui.perspectives.AbstractPerspective;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.requirements.exception.RequirementsLayerException;

public class OpenPerspectiveRequirement
implements Requirement<OpenPerspective> {
    private OpenPerspective openPerspective;

    public void fulfill() {
        try {
            AbstractPerspective perspective = this.getPerspectiveInstance();
            perspective.open();
            if (this.openPerspective.reset()) {
                perspective.reset();
            }
        }
        catch (Exception e) {
            throw new RequirementsLayerException("Unable to fullffill requirement 'Open Perspective'", e);
        }
    }

    public void setDeclaration(OpenPerspective openPerspective) {
        this.openPerspective = openPerspective;
    }

    private AbstractPerspective getPerspectiveInstance() throws InstantiationException, IllegalAccessException {
        AbstractPerspective perspectiveInstance = null;
        perspectiveInstance = this.openPerspective.value().newInstance();
        return perspectiveInstance;
    }

    public void cleanUp() {
    }

    public OpenPerspective getDeclaration() {
        return this.openPerspective;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface OpenPerspective {
        public Class<? extends AbstractPerspective> value();

        public boolean reset() default true;
    }
}

