/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.ui.views;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.AbstractTreeItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class TreeEventsListener
implements SelectionListener,
TreeListener,
FocusListener,
Listener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private boolean focusGained = false;
    private boolean focusLost = false;
    private boolean checkEvent = false;
    private boolean selectionEvent = false;
    private boolean mouseDoubleClickEvent = false;
    private TreeItem collapsedTreeItem = null;
    private TreeItem expandedTreeItem = null;
    private TreeItem selectedTreeItem = null;
    private TreeItem defaultSelectedTreeItem = null;
    private Tree tree;

    public TreeEventsListener(Tree tree) {
        this.tree = tree;
    }

    public void addListeners() {
        final TreeEventsListener tel = this;
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeEventsListener.this.tree.addSelectionListener((SelectionListener)tel);
                TreeEventsListener.this.tree.addFocusListener((FocusListener)tel);
                TreeEventsListener.this.tree.addTreeListener((TreeListener)tel);
                TreeEventsListener.this.tree.addListener(8, (Listener)tel);
            }
        });
    }

    public void removeListeners() {
        final TreeEventsListener tel = this;
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeEventsListener.this.tree.removeSelectionListener((SelectionListener)tel);
                TreeEventsListener.this.tree.removeFocusListener((FocusListener)tel);
                TreeEventsListener.this.tree.removeTreeListener((TreeListener)tel);
            }
        });
    }

    public void focusGained(FocusEvent arg0) {
        this.logger.debug("Calling method focusGained()");
        this.focusGained = true;
    }

    public void focusLost(FocusEvent arg0) {
        this.logger.debug("Calling method focusLost()");
        this.focusLost = true;
    }

    public void treeCollapsed(TreeEvent arg0) {
        this.logger.debug("Calling method treeCollapsed()");
        this.collapsedTreeItem = new TestTreeItem((org.eclipse.swt.widgets.TreeItem)arg0.item);
    }

    public void treeExpanded(TreeEvent arg0) {
        this.logger.debug("Calling method treeExpanded()");
        this.expandedTreeItem = new TestTreeItem((org.eclipse.swt.widgets.TreeItem)arg0.item);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.logger.debug("Calling method widgetDefaultSelected()");
        this.defaultSelectedTreeItem = arg0.item != null ? new TestTreeItem((org.eclipse.swt.widgets.TreeItem)arg0.item) : null;
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.logger.debug("Calling method widgetSelected()");
        this.checkEvent = arg0.detail == 32;
        this.logger.debug("It was check event: " + this.checkEvent);
        this.selectedTreeItem = arg0.item != null ? new TestTreeItem((org.eclipse.swt.widgets.TreeItem)arg0.item) : null;
        this.selectionEvent = true;
    }

    public void resetListeningWatchers() {
        this.focusGained = false;
        this.focusLost = false;
        this.checkEvent = false;
        this.selectionEvent = false;
        this.mouseDoubleClickEvent = false;
        this.collapsedTreeItem = null;
        this.expandedTreeItem = null;
        this.selectedTreeItem = null;
        this.defaultSelectedTreeItem = null;
    }

    public boolean wasFocusGained() {
        return this.focusGained;
    }

    public boolean wasFocusLost() {
        return this.focusLost;
    }

    public boolean wasCheckEvent() {
        return this.checkEvent;
    }

    public boolean wasSelectionEvent() {
        return this.selectionEvent;
    }

    public boolean wasMouseDoubleClickEvent() {
        return this.mouseDoubleClickEvent;
    }

    public TreeItem getCollapsedTreeItem() {
        return this.collapsedTreeItem;
    }

    public TreeItem getExpandedTreeItem() {
        return this.expandedTreeItem;
    }

    public TreeItem getSelectedTreeItem() {
        return this.selectedTreeItem;
    }

    public TreeItem getDefaultSelectedTreeItem() {
        return this.defaultSelectedTreeItem;
    }

    public void handleEvent(Event arg0) {
        this.logger.debug("Calling method handleEvent() with event type: " + arg0.type);
        switch (arg0.type) {
            case 8: {
                this.logger.debug("SWT.MouseDoubleClick event was fired");
                this.mouseDoubleClickEvent = true;
                break;
            }
        }
    }

    private class TestTreeItem
    extends AbstractTreeItem {
        public TestTreeItem(org.eclipse.swt.widgets.TreeItem swtTreeItem) {
            super(swtTreeItem);
        }
    }
}

