/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.wizard;

import java.util.Collection;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.ui.test.wizard.RedDeerWizardTestCase;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestPluginWizard;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestPluginWizardPage;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RedDeerTestPluginWizardTest
extends RedDeerWizardTestCase {
    private static final String APPLICATION = "org.eclipse.ui.ide.workbench";
    private static final String PRODUCT = "org.eclipse.platform.ide";
    private static final String PLUGIN_NAME = "reddeer.test.plugin";
    private static final String PLUGIN_ID = "test.plugin";
    private static final String PLUGIN_PROVIDER = "Eclipse.org - RedDeer";
    private static final String VERSION = "8.2.9.qualifier";

    @BeforeClass
    public static void setup() {
        wizard = new RedDeerTestPluginWizard();
        projectName = PLUGIN_ID;
    }

    @Test
    public void testOpen() {
        Assert.assertEquals((Object)("New " + "RedDeer Test Plug-in".replace("-", "")), (Object)new DefaultShell().getText());
        Assert.assertTrue((String)"Product id radio is not selected", (boolean)new RadioButton("Product id:").isSelected());
        Assert.assertTrue((String)"Product combo is not enabled", (boolean)new DefaultCombo().isEnabled());
        Assert.assertFalse((String)"Application id radio is selected", (boolean)new RadioButton("Application id:").isSelected());
        Assert.assertFalse((String)"Application combo not enabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        Assert.assertFalse((String)"Finish button is enabled", (boolean)new FinishButton().isEnabled());
    }

    @Test
    public void testCreate() {
        this.fillInWizard();
        wizard.finish();
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        DefaultProject project = null;
        try {
            project = explorer.getProject(PLUGIN_ID);
        }
        catch (RedDeerException redDeerException) {
            Assert.fail((String)"Cannot retrieve created plug-in project");
        }
        this.checkProjectResources(project);
        this.checkManifest(project);
        this.checkExampleTest(project);
    }

    private void checkExampleTest(DefaultProject project) {
        project.getProjectItem(new String[]{"src", "org.reddeer.test", "RedDeerTest.java"}).open();
        ContentOutline view = new ContentOutline();
        view.open();
        Collection outline = view.outlineElements();
        TreeItem testMethod = null;
        for (TreeItem item : outline) {
            if (!item.getText().equals("RedDeerTest")) continue;
            for (TreeItem member : item.getItems()) {
                if (!member.getText().equals("redDeerTestExample() : void")) continue;
                testMethod = member;
            }
        }
        Assert.assertNotNull((String)"Cannot locate example test method", testMethod);
    }

    private void checkManifest(DefaultProject project) {
        project.getProjectItem(new String[]{"META-INF", "MANIFEST.MF"}).open();
        Assert.assertTrue((boolean)new LabeledText("ID:").getText().equals(PLUGIN_ID));
        Assert.assertTrue((boolean)new LabeledText("Version:").getText().equals(VERSION));
        Assert.assertTrue((boolean)new LabeledText("Name:").getText().equals(PLUGIN_NAME));
        Assert.assertTrue((boolean)new LabeledText("Vendor:").getText().equals(PLUGIN_PROVIDER));
    }

    private void checkProjectResources(DefaultProject project) {
        Assert.assertTrue((String)"Project does not contain build.properties file", (boolean)project.containsResource(new String[]{"build.properties"}));
        Assert.assertTrue((String)"Project does not contain pluginCustomization.ini file", (boolean)project.containsResource(new String[]{"pluginCustomization.ini"}));
        Assert.assertTrue((String)"Project does not contain MANIFEST.MF file", (boolean)project.containsResource(new String[]{"META-INF", "MANIFEST.MF"}));
        Assert.assertTrue((String)"Project does not contain example test", (boolean)project.containsResource(new String[]{"src", "org.reddeer.test", "RedDeerTest.java"}));
        Assert.assertTrue((String)"Project does not contain RedDeerTest.launch file", (boolean)project.containsResource(new String[]{"RedDeerTest.launch"}));
    }

    private void fillInWizard() {
        RedDeerTestPluginWizardPage page = new RedDeerTestPluginWizardPage((ReferencedComposite)wizard);
        page.setPluginName(PLUGIN_NAME);
        page.setPluginId(PLUGIN_ID);
        page.setVersion(VERSION);
        page.setProvider(PLUGIN_PROVIDER);
        page.setApplication(true);
        Assert.assertTrue((String)"Application combo was not enabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        page.selectApplication(APPLICATION);
        page.toggleExampleTest(true);
        Assert.assertTrue((String)"'Example test' checkbox was not checked", (boolean)new CheckBox().isChecked());
        page.setProduct(true);
        Assert.assertFalse((String)"Application combo was not disabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        Assert.assertTrue((String)"Product combo was not enabled", (boolean)new DefaultCombo().isEnabled());
        page.selectProduct(PRODUCT);
        Assert.assertTrue((String)"Finish button is not enabled", (boolean)new FinishButton().isEnabled());
    }

    @Override
    String getWizardText() {
        return "New RedDeer Test Plugin";
    }
}

