/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.impl.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.handler.MenuItemHandler;
import org.eclipse.reddeer.core.lookup.MenuLookup;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.core.util.InstanceValidator;
import org.eclipse.reddeer.jface.text.contentassist.ContentAssistant;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenu;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.keyboard.KeyboardFactory;
import org.eclipse.reddeer.workbench.api.Editor;
import org.eclipse.reddeer.workbench.api.EditorFile;
import org.eclipse.reddeer.workbench.condition.ContentAssistantShellIsOpened;
import org.eclipse.reddeer.workbench.condition.EditorIsDirty;
import org.eclipse.reddeer.workbench.core.lookup.EditorPartLookup;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchShellLookup;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditorFile;
import org.eclipse.reddeer.workbench.impl.editor.Marker;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.eclipse.reddeer.workbench.matcher.EditorPartTitleMatcher;
import org.eclipse.reddeer.workbench.part.AbstractWorkbenchPart;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.hamcrest.Matcher;

public abstract class AbstractEditor
extends AbstractWorkbenchPart
implements Editor {
    protected static final Logger log = Logger.getLogger(AbstractEditor.class);
    protected IEditorPart editorPart;

    public AbstractEditor() {
        this(EditorPartLookup.getInstance().getEditor());
    }

    public AbstractEditor(String title) {
        this((Matcher<String>)new WithTextMatcher(title));
    }

    public AbstractEditor(Matcher<String> title) {
        this(new Matcher[]{new EditorPartTitleMatcher(title)});
    }

    public AbstractEditor(Matcher<IEditorPart> ... matchers) {
        this(EditorPartLookup.getInstance().getEditor(matchers));
    }

    protected AbstractEditor(IEditorPart part) {
        super((CTabItem)new DefaultCTabItem((ReferencedComposite)new WorkbenchShellReferenced(), new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher("\\*?" + Pattern.quote(part.getTitle())))}));
        InstanceValidator.checkNotNull((Object)part, (String)"part");
        this.editorPart = part;
        this.activate();
    }

    @Override
    public boolean isDirty() {
        return EditorHandler.getInstance().isDirty(this.editorPart);
    }

    @Override
    public void save() {
        this.activate();
        log.info("Save editor");
        ShellMenuItem saveItem = new ShellMenuItem((Shell)new WorkbenchShell(), new String[]{"File", "Save"});
        if (!saveItem.isEnabled()) {
            throw new WorkbenchLayerException("Menu item 'Save' is not enabled");
        }
        saveItem.select();
        new WaitWhile((WaitCondition)new EditorIsDirty(this));
        this.activate();
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean save) {
        this.activate();
        if (save) {
            log.info("Close editor and save it");
        } else {
            log.info("Close editor and do not save it");
        }
        EditorHandler.getInstance().close(save, this.editorPart);
    }

    @Override
    public void activate() {
        EditorHandler.getInstance().activate((IWorkbenchPart)this.editorPart);
    }

    @Override
    public boolean isActive() {
        return this.editorPart.equals(EditorPartLookup.getInstance().getActiveEditor());
    }

    @Override
    public ContentAssistant openContentAssistant() {
        boolean hasAssistMenuChildren;
        ShellMenuItem assistMenu = null;
        try {
            assistMenu = new ShellMenuItem(new String[]{"Edit", "Content Assist"});
        }
        catch (RedDeerException redDeerException) {
            log.info("Content assist menu not found, open via keyboard shortcut");
            return this.openContentAssistantViaKeyboard();
        }
        boolean bl = hasAssistMenuChildren = MenuItemHandler.getInstance().getMenuFromMenuItem((org.eclipse.swt.widgets.MenuItem)assistMenu.getSWTWidget()) != null;
        if (hasAssistMenuChildren) {
            return this.openContentAssistant(ContentAssistantEnum.DEFAULT);
        }
        return this.openContentAssistant("Edit", "Content Assist");
    }

    @Override
    public ContentAssistant openContentAssistant(ContentAssistantEnum assistantType) {
        return this.openContentAssistant(assistantType.getLabel());
    }

    @Override
    public ContentAssistant openContentAssistant(String assistantLabel) {
        return this.openContentAssistant("Edit", "Content Assist", assistantLabel);
    }

    private ContentAssistant openContentAssistant(String ... assistantMenuPath) {
        ShellMenuItem menu;
        String assistantLabel = assistantMenuPath[assistantMenuPath.length - 1];
        this.activate();
        log.info("Open editor's " + assistantLabel + " content assistant");
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        try {
            menu = new ShellMenuItem(assistantMenuPath);
        }
        catch (RedDeerException e) {
            throw new WorkbenchLayerException("Content assistant " + assistantLabel + " does not exist!", e);
        }
        if (!menu.isEnabled()) {
            throw new WorkbenchLayerException("Content assistant " + assistantLabel + " is disabled!");
        }
        org.eclipse.swt.widgets.Shell[] shells = ShellLookup.getInstance().getShells();
        menu.select();
        return this.getContentAssistantShell(shells);
    }

    private ContentAssistant openContentAssistantViaKeyboard() {
        org.eclipse.swt.widgets.Shell[] shells = ShellLookup.getInstance().getShells();
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] sequence = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (sequence.length > 0 && sequence[0].getTriggers().length > 0) {
            if (!(sequence[0].getTriggers()[0] instanceof KeyStroke)) {
                throw new WorkbenchLayerException("Unable to find key combination which invokes Content Assistant");
            }
        } else {
            throw new WorkbenchLayerException("Unable to find key combination which invokes Content Assistant");
        }
        KeyStroke k = (KeyStroke)sequence[0].getTriggers()[0];
        KeyboardFactory.getKeyboard().invokeKeyCombination(new int[]{k.getModifierKeys(), k.getNaturalKey()});
        return this.getContentAssistantShell(shells);
    }

    private ContentAssistant getContentAssistantShell(org.eclipse.swt.widgets.Shell[] shells) {
        ContentAssistantShellIsOpened caw = new ContentAssistantShellIsOpened(shells);
        new WaitUntil((WaitCondition)caw);
        return new ContentAssistant(caw.getContentAssistTable());
    }

    @Override
    public List<ContentAssistantEnum> getAvailableContentAssistants() {
        this.activate();
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        List availableMenus = new ShellMenuItem(new String[]{"Edit", "Content Assist"}).getAvailableChildItems();
        ArrayList<ContentAssistantEnum> result = new ArrayList<ContentAssistantEnum>(availableMenus.size());
        for (MenuItem availableMenu : availableMenus) {
            String label = MenuItemHandler.getInstance().getLabelFromText(availableMenu.getText());
            ContentAssistantEnum assistantType = ContentAssistantEnum.resolveLabel(label);
            if (assistantType == null) continue;
            result.add(assistantType);
        }
        return result;
    }

    @Override
    public ContentAssistant openOpenOnAssistant() {
        this.activate();
        log.info("Open editor's open on assistant");
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        org.eclipse.swt.widgets.Shell[] shells1 = ShellLookup.getInstance().getShells();
        new ShellMenuItem(new String[]{"Navigate", "Open Hyperlink"}).select();
        try {
            ContentAssistantShellIsOpened caw = new ContentAssistantShellIsOpened(shells1);
            new WaitUntil((WaitCondition)caw);
            return new ContentAssistant(caw.getContentAssistTable());
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            return null;
        }
    }

    @Override
    public ContentAssistant openQuickFixContentAssistant() {
        this.activate();
        log.info("Open editor's quick fix assistant");
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        org.eclipse.swt.widgets.Shell[] shells1 = ShellLookup.getInstance().getShells();
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] sequence = bindingService.getActiveBindingsFor("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        if (sequence.length > 0 && sequence[0].getTriggers().length > 0) {
            if (!(sequence[0].getTriggers()[0] instanceof KeyStroke)) {
                throw new WorkbenchLayerException("Unable to find key combination which invokes Quickfix Content Assistant");
            }
        } else {
            throw new WorkbenchLayerException("Unable to find key combination which invokes Quickfix Content Assistant");
        }
        KeyStroke k = (KeyStroke)sequence[0].getTriggers()[0];
        KeyboardFactory.getKeyboard().invokeKeyCombination(new int[]{k.getModifierKeys(), k.getNaturalKey()});
        ContentAssistantShellIsOpened caw = new ContentAssistantShellIsOpened(shells1);
        new WaitUntil((WaitCondition)caw);
        return new ContentAssistant(caw.getContentAssistTable());
    }

    @Override
    public List<Marker> getMarkers() {
        this.activate();
        return EditorHandler.getInstance().getMarkers(this.editorPart);
    }

    @Override
    public ContentAssistant getAutoContentAssistant(Runnable execute) {
        this.activate();
        org.eclipse.swt.widgets.Shell[] shells1 = ShellLookup.getInstance().getShells();
        execute.run();
        ContentAssistantShellIsOpened caw = new ContentAssistantShellIsOpened(shells1);
        new WaitUntil((WaitCondition)caw, TimePeriod.DEFAULT, false);
        return caw.getContentAssistTable() == null ? null : new ContentAssistant(caw.getContentAssistTable());
    }

    @Override
    public EditorFile getAssociatedFile() {
        IEditorInput editorInput = this.editorPart.getEditorInput();
        IFile iFile = (IFile)editorInput.getAdapter(IFile.class);
        if (iFile == null) {
            throw new WorkbenchLayerException("No file is associated to the editor");
        }
        return new DefaultEditorFile(iFile);
    }

    @Override
    public Menu getContextMenu() {
        Control registeredControl = this.getRegisteredControl();
        if (registeredControl == null) {
            throw new WorkbenchLayerException("No control is registered with the editor");
        }
        return new DefaultMenu(MenuLookup.getInstance().getControlMenu(registeredControl));
    }

    protected Control getRegisteredControl() {
        IEditorPart editorPart = this.getEditorPart();
        return (Control)editorPart.getAdapter(Control.class);
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public static enum ContentAssistantEnum {
        DEFAULT("Default"),
        JAVA_TYPE("Java Type Proposals"),
        JAVA_NON_TYPE("Java Non-Type Proposals"),
        JAVA("Java Proposals"),
        TEMPLATE("Template Proposals"),
        WORD("Word Proposals"),
        SWT_TEMPLATE("SWT Template Proposals"),
        JAXB("JAXB Proposals"),
        JPA("JPA Proposals"),
        JAX_RS("JAX-WS Proposals"),
        API_TOOLS("API Tools Proposals"),
        ADAPTIVE_TEMPLATE_RECOMMENDERS("Adaptive Template Proposals (Code Recommenders)"),
        CHAIN_RECOMMENDERS("Chain Proposals (Code Recommenders)"),
        JAVA_RECOMMENDERS("Java Proposals (Code Recommenders)"),
        PARAMETER_HINTS("Parameter Hints");

        private String label;

        public String getLabel() {
            return this.label;
        }

        private ContentAssistantEnum(String label) {
            this.label = label;
        }

        public static ContentAssistantEnum resolveLabel(String label) {
            ContentAssistantEnum[] contentAssistantEnumArray = ContentAssistantEnum.values();
            int n = contentAssistantEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentAssistantEnum value = contentAssistantEnumArray[n2];
                if (value.getLabel().equals(label)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class WorkbenchShellReferenced
    implements ReferencedComposite {
        private WorkbenchShellReferenced() {
        }

        public Control getControl() {
            return WorkbenchShellLookup.getInstance().getWorkbenchShell();
        }
    }
}

