/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.part;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.workbench.api.WorkbenchPart;
import org.eclipse.reddeer.workbench.handler.WorkbenchPartHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractWorkbenchPart
implements WorkbenchPart {
    protected static final Logger log = Logger.getLogger(AbstractWorkbenchPart.class);
    protected CTabItem cTabItem;

    public AbstractWorkbenchPart(CTabItem cTabItem) {
        this.cTabItem = cTabItem;
    }

    @Override
    public String getTitle() {
        return this.cTabItem.getText();
    }

    @Override
    public Image getTitleImage() {
        return this.cTabItem.getImage();
    }

    @Override
    public String getTitleToolTip() {
        return this.cTabItem.getToolTipText();
    }

    public Control getControl() {
        return this.cTabItem.getControl();
    }

    @Override
    public boolean isActive() {
        return this.cTabItem.isActive();
    }

    @Override
    public void minimize() {
        this.activate();
        log.info("Minimize workbench part");
        WorkbenchPartHandler.getInstance().performAction(ActionFactory.MINIMIZE);
    }

    @Override
    public void maximize() {
        this.activate();
        log.info("Maximize workbench part");
        WorkbenchPartHandler.getInstance().performAction(ActionFactory.MAXIMIZE);
    }

    @Override
    public void restore() {
        this.activate();
        log.info("Restore workbench part");
        WorkbenchPartHandler.getInstance().performAction(ActionFactory.MAXIMIZE);
    }
}

