/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Rectangle;

class InlinedAnnotationDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    InlinedAnnotationDrawingStrategy() {
    }

    @Override
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (!(annotation instanceof AbstractInlinedAnnotation)) {
            return;
        }
        if (!((AbstractInlinedAnnotation)annotation).isInVisibleLines()) {
            return;
        }
        InlinedAnnotationDrawingStrategy.draw((AbstractInlinedAnnotation)annotation, gc, textWidget, offset, length, color);
    }

    public static void draw(AbstractInlinedAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (annotation instanceof LineHeaderAnnotation) {
            InlinedAnnotationDrawingStrategy.draw((LineHeaderAnnotation)annotation, gc, textWidget, offset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.draw((LineContentAnnotation)annotation, gc, textWidget, offset, length, color);
        }
    }

    private static void draw(LineHeaderAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (annotation.isMarkedDeleted()) {
            textWidget.redraw();
            textWidget.setCaretOffset(textWidget.getCaretOffset());
            return;
        }
        int lineIndex = -1;
        try {
            lineIndex = textWidget.getLineAtOffset(offset);
        }
        catch (Exception exception) {
            return;
        }
        int previousLineIndex = lineIndex - 1;
        if (gc != null) {
            Rectangle clipping;
            int x = textWidget.getLocationAtOffset((int)offset).x;
            int y = 0;
            int height = annotation.getHeight();
            if (lineIndex > 0) {
                int previousOffset = textWidget.getOffsetAtLine(previousLineIndex);
                y = textWidget.getLocationAtOffset((int)previousOffset).y + height;
            }
            if ((clipping = gc.getClipping()).contains(x, y)) {
                gc.setBackground(textWidget.getBackground());
                Rectangle client = textWidget.getClientArea();
                textWidget.drawBackground(gc, x, y, client.width, height);
                annotation.draw(gc, textWidget, offset, length, color, x, y);
                return;
            }
            if (clipping.y - height != y) {
                return;
            }
        }
        if (previousLineIndex < 0) {
            return;
        }
        int previousOffset = textWidget.getOffsetAtLine(previousLineIndex);
        int lineLength = offset - previousOffset;
        textWidget.redrawRange(previousOffset, lineLength, true);
    }

    private static void draw(LineContentAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(offset);
        }
        catch (Exception exception) {
            return;
        }
        if (annotation.isMarkedDeleted()) {
            if (style != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            int x = bounds.x;
            int y = bounds.y;
            annotation.draw(gc, textWidget, offset, length, color, x, y);
            int width = annotation.getWidth();
            if (width != 0) {
                GlyphMetrics metrics;
                GlyphMetrics glyphMetrics = metrics = style != null ? style.metrics : null;
                if (metrics == null || metrics.width != width) {
                    if (metrics == null) {
                        metrics = new GlyphMetrics(0, 0, width);
                    } else {
                        metrics.width = width;
                    }
                    if (style == null) {
                        style = new StyleRange();
                        style.start = offset;
                        style.length = 1;
                        style.background = textWidget.getBackground();
                        style.foreground = textWidget.getForeground();
                    }
                    style.metrics = metrics;
                    textWidget.setStyleRange(style);
                    return;
                }
                String s = textWidget.getText(offset, offset);
                int charWidth = gc.stringExtent((String)s).x;
                int charX = x + bounds.width - charWidth;
                int charY = y;
                if (style != null) {
                    if (style.background != null) {
                        gc.setBackground(style.background);
                        gc.fillRectangle(charX, charY, charWidth + 1, bounds.height);
                    }
                    if (style.foreground != null) {
                        gc.setForeground(style.foreground);
                    }
                }
                gc.drawString(s, charX, charY, true);
            }
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }
}

