/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.shared.target.AddBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationContentProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.UpdateTargetJob;
import org.eclipse.pde.ui.target.ITargetLocationEditor;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class TargetLocationsGroup {
    private TreeViewer fTreeViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpdateButton;
    private Button fReloadButton;
    private Button fShowContentButton;
    private ITargetDefinition fTarget;
    private ListenerList<ITargetChangedListener> fChangeListeners = new ListenerList();
    private ListenerList<ITargetChangedListener> fReloadListeners = new ListenerList();

    public static TargetLocationsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetLocationsGroup createInDialog(Composite parent) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    private TargetLocationsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void addTargetReloadListener(ITargetChangedListener listener) {
        this.fReloadListeners.add((Object)listener);
    }

    private void createFormContents(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        comp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        comp.setLayoutData((Object)new GridData(1808));
        Tree atree = toolkit.createTree(comp, 770);
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_0, 8);
        this.fEditButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_1, 8);
        this.fRemoveButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_2, 8);
        this.fUpdateButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_3, 8);
        this.fUpdateButton.setToolTipText(Messages.TargetLocationsGroup_update);
        this.fReloadButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_4, 8);
        this.fReloadButton.setToolTipText(Messages.TargetLocationsGroup_reload);
        this.fShowContentButton = toolkit.createButton(comp, Messages.TargetLocationsGroup_1, 32);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
        toolkit.paintBordersFor(comp);
    }

    private void createDialogContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        Tree atree = new Tree(comp, 2818);
        atree.setFont(comp.getFont());
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = SWTFactory.createComposite(comp, 2, 1, 1808);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_0, null);
        this.fEditButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_1, null);
        this.fRemoveButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_2, null);
        this.fUpdateButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_3, null);
        this.fReloadButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_4, null);
        this.fShowContentButton = SWTFactory.createCheckButton(comp, Messages.TargetLocationsGroup_1, null, false, 2);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
    }

    private void initializeTreeViewer(Tree tree) {
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new TargetLocationContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TargetLocationLabelProvider(true, false));
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IStatus && !(e2 instanceof IStatus)) {
                    return 1;
                }
                if (e2 instanceof IStatus && !(e1 instanceof IStatus)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(event -> this.updateButtons());
        this.fTreeViewer.addDoubleClickListener(event -> {
            if (!event.getSelection().isEmpty()) {
                this.handleEdit();
            }
        });
        this.fTreeViewer.setAutoExpandLevel(-1);
    }

    private void initializeButtons() {
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        this.fAddButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fAddButton);
        this.fEditButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleEdit()));
        this.fEditButton.setLayoutData((Object)new GridData());
        this.fEditButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fEditButton);
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        this.fRemoveButton.setLayoutData((Object)new GridData());
        this.fRemoveButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fRemoveButton);
        this.fUpdateButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleUpdate()));
        this.fUpdateButton.setLayoutData((Object)new GridData());
        this.fUpdateButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fUpdateButton);
        this.fReloadButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleReload()));
        this.fReloadButton.setLayoutData((Object)new GridData());
        this.fReloadButton.setEnabled(true);
        SWTFactory.setButtonDimensionHint(this.fReloadButton);
        this.fShowContentButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ((TargetLocationContentProvider)this.fTreeViewer.getContentProvider()).setShowLocationContent(this.fShowContentButton.getSelection());
            this.fTreeViewer.refresh();
            this.fTreeViewer.expandAll();
        }));
        this.fShowContentButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fShowContentButton);
    }

    public void setInput(ITargetDefinition target) {
        this.fTarget = target;
        this.fTreeViewer.setInput((Object)this.fTarget);
        this.updateButtons();
    }

    private void handleAdd() {
        AddBundleContainerWizard wizard = new AddBundleContainerWizard(this.fTarget);
        Shell parent = this.fTreeViewer.getTree().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        if (dialog.open() != 1) {
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
        }
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        for (Object currentSelection : selection) {
            EditBundleContainerWizard editWizard;
            if (currentSelection instanceof ITargetLocation) {
                EditBundleContainerWizard wizard;
                ITargetLocation location = (ITargetLocation)currentSelection;
                ITargetLocationEditor editor = (ITargetLocationEditor)Platform.getAdapterManager().getAdapter((Object)location, ITargetLocationEditor.class);
                if (editor != null) {
                    Shell parent;
                    WizardDialog wizard2;
                    if (!editor.canEdit(this.fTarget, location)) continue;
                    IWizard editWizard2 = editor.getEditWizard(this.fTarget, location);
                    if (editWizard2 == null || (wizard2 = new WizardDialog(parent = this.fTreeViewer.getTree().getShell(), editWizard2)).open() != 0) break;
                    this.contentsChanged(false);
                    this.fTreeViewer.refresh();
                    this.updateButtons();
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)location), true);
                    break;
                }
                if (!(location instanceof AbstractBundleContainer)) continue;
                Shell parent = this.fTreeViewer.getTree().getShell();
                WizardDialog dialog = new WizardDialog(parent, (IWizard)(wizard = new EditBundleContainerWizard(this.fTarget, location)));
                if (dialog.open() != 0) break;
                this.contentsChanged(false);
                this.fTreeViewer.refresh();
                this.updateButtons();
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)location), true);
                break;
            }
            if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
            IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)currentSelection;
            Shell parent = this.fTreeViewer.getTree().getShell();
            WizardDialog wizard = new WizardDialog(parent, (IWizard)(editWizard = new EditBundleContainerWizard(this.fTarget, (ITargetLocation)wrapper.getParent())));
            if (wizard.open() != 0) break;
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)wrapper.getParent()), true);
            break;
        }
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        if (!selection.isEmpty() && containers != null && containers.length > 0) {
            ArrayList toRemove = new ArrayList();
            boolean removedSite = false;
            boolean removedContainer = false;
            for (Object currentSelection : selection) {
                if (currentSelection instanceof ITargetLocation) {
                    if (currentSelection instanceof IUBundleContainer) {
                        removedSite = true;
                    }
                    removedContainer = true;
                    toRemove.add(currentSelection);
                }
                if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
                toRemove.add(currentSelection);
            }
            if (removedContainer) {
                HashSet<ITargetLocation> newContainers = new HashSet<ITargetLocation>();
                if (this.fTarget.getTargetLocations() != null) {
                    newContainers.addAll(Arrays.asList(this.fTarget.getTargetLocations()));
                }
                newContainers.removeAll(toRemove);
                if (newContainers.size() > 0) {
                    this.fTarget.setTargetLocations(newContainers.toArray(new ITargetLocation[newContainers.size()]));
                } else {
                    this.fTarget.setTargetLocations(null);
                }
                this.contentsChanged(removedSite || !this.fTarget.getStatus().isOK());
                this.fTreeViewer.refresh(false);
                this.updateButtons();
            } else {
                for (Object object : toRemove) {
                    if (!(object instanceof IUContentProvider.IUWrapper)) continue;
                    ((IUContentProvider.IUWrapper)object).getParent().removeInstallableUnit(((IUContentProvider.IUWrapper)object).getIU());
                }
                this.contentsChanged(removedSite);
                this.fTreeViewer.refresh(true);
                this.updateButtons();
            }
        }
    }

    private void handleUpdate() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        HashMap<ITargetLocation, Set<Object>> toUpdate = new HashMap<ITargetLocation, Set<Object>>();
        for (Object currentSelection : selection) {
            if (currentSelection instanceof ITargetLocation) {
                toUpdate.put((ITargetLocation)currentSelection, new HashSet(0));
                continue;
            }
            if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
            IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)currentSelection;
            HashSet<String> iuSet = (HashSet<String>)toUpdate.get(wrapper.getParent());
            if (iuSet == null) {
                iuSet = new HashSet<String>();
                iuSet.add(wrapper.getIU().getId());
                toUpdate.put((ITargetLocation)wrapper.getParent(), iuSet);
                continue;
            }
            if (iuSet.isEmpty()) continue;
            iuSet.add(wrapper.getIU().getId());
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                UIJob job = new UIJob(Messages.UpdateTargetJob_UpdateJobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IStatus result = event.getJob().getResult();
                        if (!result.isOK()) {
                            if (!TargetLocationsGroup.this.fTreeViewer.getControl().isDisposed()) {
                                ErrorDialog.openError((Shell)TargetLocationsGroup.this.fTreeViewer.getTree().getShell(), (String)Messages.TargetLocationsGroup_TargetUpdateErrorDialog, (String)result.getMessage(), (IStatus)result);
                            }
                        } else if (result.getCode() != 101) {
                            if (!TargetLocationsGroup.this.fTreeViewer.getControl().isDisposed()) {
                                TargetLocationsGroup.this.contentsChanged(true);
                                TargetLocationsGroup.this.fTreeViewer.refresh(true);
                                TargetLocationsGroup.this.updateButtons();
                            }
                            try {
                                ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
                                if (service != null) {
                                    ITargetHandle currentTarget = service.getWorkspaceTargetHandle();
                                    if (TargetLocationsGroup.this.fTarget.getHandle().equals(currentTarget)) {
                                        LoadTargetDefinitionJob.load((ITargetDefinition)TargetLocationsGroup.this.fTarget);
                                    }
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        UpdateTargetJob.update(this.fTarget, toUpdate, (IJobChangeListener)listener);
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.isEmpty()) {
            this.fRemoveButton.setEnabled(false);
            this.fUpdateButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
        }
        boolean canRemove = false;
        boolean canEdit = false;
        boolean canUpdate = false;
        for (Object currentSelection : selection) {
            if (currentSelection instanceof ITargetLocation) {
                ITargetLocation location;
                canRemove = true;
                if (!canEdit) {
                    location = (ITargetLocation)currentSelection;
                    ITargetLocationEditor editor = (ITargetLocationEditor)Platform.getAdapterManager().getAdapter((Object)location, ITargetLocationEditor.class);
                    if (editor != null) {
                        canEdit = editor.canEdit(this.fTarget, location);
                    }
                    if (location instanceof AbstractBundleContainer) {
                        canEdit = true;
                    }
                }
                if (!canUpdate) {
                    location = (ITargetLocation)currentSelection;
                    ITargetLocationUpdater updater = (ITargetLocationUpdater)Platform.getAdapterManager().getAdapter((Object)location, ITargetLocationUpdater.class);
                    if (updater != null) {
                        canUpdate = updater.canUpdate(this.fTarget, location);
                    }
                }
            } else if (currentSelection instanceof IUContentProvider.IUWrapper) {
                canRemove = true;
                canEdit = true;
                canUpdate = true;
            }
            if (canRemove && canEdit && canUpdate) break;
        }
        this.fRemoveButton.setEnabled(canRemove);
        this.fEditButton.setEnabled(canEdit && this.fTarget.isResolved());
        this.fUpdateButton.setEnabled(canUpdate);
    }

    private void handleReload() {
        try {
            P2TargetUtils.forceCheckTarget((ITargetDefinition)this.fTarget);
            P2TargetUtils.deleteProfile((ITargetHandle)this.fTarget.getHandle());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        UIJob job = new UIJob("Reloading..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TargetLocationsGroup.this.contentsReload();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void contentsChanged(boolean force) {
        for (ITargetChangedListener listener : this.fChangeListeners) {
            listener.contentsChanged(this.fTarget, this, true, force);
        }
    }

    private void contentsReload() {
        for (ITargetChangedListener listener : this.fReloadListeners) {
            listener.contentsChanged(this.fTarget, this, true, true);
        }
    }
}

