/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    static PrinterData[] printerList;
    static long findPrinter;
    static PrinterData findData;
    PrinterData data;
    long printer;
    long printJob;
    long settings;
    long pageSetup;
    long surface;
    long cairo;
    boolean isGCCreated = false;
    static byte[] settingsData;
    static int start;
    static int end;
    static final String GTK_LPR_BACKEND = "GtkPrintBackendLpr";
    static final String GTK_FILE_BACKEND = "GtkPrintBackendFile";
    static boolean disablePrinting;

    static {
        disablePrinting = System.getProperty("org.eclipse.swt.internal.gtk.disablePrinting") != null;
    }

    static void gtk_init() {
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        if (!GTK.gtk_init_check(new long[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
    }

    public static PrinterData[] getPrinterList() {
        printerList = new PrinterData[0];
        if (disablePrinting) {
            return printerList;
        }
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_List", 2);
        long GtkPrinterFunc_List = printerCallback.getAddress();
        if (GtkPrinterFunc_List == 0L) {
            SWT.error(3);
        }
        GTK.gtk_enumerate_printers(GtkPrinterFunc_List, 0L, 0L, true);
        GDK.gdk_threads_leave();
        printerCallback.dispose();
        return printerList;
    }

    static long GtkPrinterFunc_List(long printer, long user_data) {
        int length = printerList.length;
        PrinterData[] newList = new PrinterData[length + 1];
        System.arraycopy(printerList, 0, newList, 0, length);
        printerList = newList;
        Printer.printerList[length] = Printer.printerDataFromGtkPrinter(printer);
        if (Printer.printerList[length].driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    public static PrinterData getDefaultPrinterData() {
        findData = null;
        if (disablePrinting) {
            return null;
        }
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_Default", 2);
        long GtkPrinterFunc_Default = printerCallback.getAddress();
        if (GtkPrinterFunc_Default == 0L) {
            SWT.error(3);
        }
        GTK.gtk_enumerate_printers(GtkPrinterFunc_Default, 0L, 0L, true);
        GDK.gdk_threads_leave();
        printerCallback.dispose();
        return findData;
    }

    static long GtkPrinterFunc_Default(long printer, long user_data) {
        if (GTK.gtk_printer_is_default(printer)) {
            findData = Printer.printerDataFromGtkPrinter(printer);
            return 1L;
        }
        return 0L;
    }

    static long gtkPrinterFromPrinterData(PrinterData data) {
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_FindNamedPrinter", 2);
        long GtkPrinterFunc_FindNamedPrinter = printerCallback.getAddress();
        if (GtkPrinterFunc_FindNamedPrinter == 0L) {
            SWT.error(3);
        }
        findPrinter = 0L;
        findData = data;
        GTK.gtk_enumerate_printers(GtkPrinterFunc_FindNamedPrinter, 0L, 0L, true);
        GDK.gdk_threads_leave();
        printerCallback.dispose();
        return findPrinter;
    }

    static long GtkPrinterFunc_FindNamedPrinter(long printer, long user_data) {
        PrinterData pd = Printer.printerDataFromGtkPrinter(printer);
        if (pd.driver.equals(Printer.findData.driver) && pd.name.equals(Printer.findData.name) || pd.driver.equals(GTK_FILE_BACKEND) && Printer.findData.printToFile && Printer.findData.driver == null && Printer.findData.name == null) {
            findPrinter = printer;
            OS.g_object_ref(printer);
            return 1L;
        }
        return 0L;
    }

    static PrinterData printerDataFromGtkPrinter(long printer) {
        long backend = GTK.gtk_printer_get_backend(printer);
        long address = OS.G_OBJECT_TYPE_NAME(backend);
        int length = C.strlen(address);
        byte[] buffer = new byte[length];
        C.memmove(buffer, address, (long)length);
        String backendType = new String(Converter.mbcsToWcs(buffer));
        address = GTK.gtk_printer_get_name(printer);
        length = C.strlen(address);
        buffer = new byte[length];
        C.memmove(buffer, address, (long)length);
        String name = new String(Converter.mbcsToWcs(buffer));
        return new PrinterData(backendType, name);
    }

    static void restore(byte[] data, long settings, long page_setup) {
        settingsData = data;
        end = 0;
        start = 0;
        while (end < settingsData.length && settingsData[end] != 0) {
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] keyBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] valueBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, valueBuffer, 0, valueBuffer.length);
            GTK.gtk_print_settings_set(settings, keyBuffer, valueBuffer);
            if (!DEBUG) continue;
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(keyBuffer))) + ": " + new String(Converter.mbcsToWcs(valueBuffer)));
        }
        ++end;
        GTK.gtk_page_setup_set_orientation(page_setup, Printer.restoreInt("orientation"));
        GTK.gtk_page_setup_set_top_margin(page_setup, Printer.restoreDouble("top_margin"), 3);
        GTK.gtk_page_setup_set_bottom_margin(page_setup, Printer.restoreDouble("bottom_margin"), 3);
        GTK.gtk_page_setup_set_left_margin(page_setup, Printer.restoreDouble("left_margin"), 3);
        GTK.gtk_page_setup_set_right_margin(page_setup, Printer.restoreDouble("right_margin"), 3);
        byte[] name = Printer.restoreBytes("paper_size_name", true);
        byte[] display_name = Printer.restoreBytes("paper_size_display_name", true);
        byte[] ppd_name = Printer.restoreBytes("paper_size_ppd_name", true);
        double width = Printer.restoreDouble("paper_size_width");
        double height = Printer.restoreDouble("paper_size_height");
        boolean custom = Printer.restoreBoolean("paper_size_is_custom");
        long paper_size = 0L;
        paper_size = custom ? (ppd_name.length > 0 ? GTK.gtk_paper_size_new_from_ppd(ppd_name, display_name, width, height) : GTK.gtk_paper_size_new_custom(name, display_name, width, height, 3)) : GTK.gtk_paper_size_new(name);
        GTK.gtk_page_setup_set_paper_size(page_setup, paper_size);
        GTK.gtk_paper_size_free(paper_size);
    }

    static byte[] uriFromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        int length = filename.length();
        if (length == 0) {
            return null;
        }
        char[] chars = new char[length];
        filename.getChars(0, length, chars, 0);
        long[] error = new long[1];
        long utf8Ptr = OS.g_utf16_to_utf8(chars, chars.length, null, null, error);
        if (error[0] != 0L || utf8Ptr == 0L) {
            return null;
        }
        long localePtr = OS.g_filename_from_utf8(utf8Ptr, -1L, null, null, error);
        OS.g_free(utf8Ptr);
        if (error[0] != 0L || localePtr == 0L) {
            return null;
        }
        long uriPtr = OS.g_filename_to_uri(localePtr, 0L, error);
        OS.g_free(localePtr);
        if (error[0] != 0L || uriPtr == 0L) {
            return null;
        }
        length = C.strlen(uriPtr);
        byte[] uri = new byte[length + 1];
        C.memmove(uri, uriPtr, (long)length);
        OS.g_free(uriPtr);
        return uri;
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            long filePrinter;
            PrinterData defaultData = null;
            if (data.printToFile && (filePrinter = Printer.gtkPrinterFromPrinterData(data)) != 0L) {
                defaultData = Printer.printerDataFromGtkPrinter(filePrinter);
                OS.g_object_unref(filePrinter);
            }
            if (defaultData == null && (defaultData = Printer.getDefaultPrinterData()) == null) {
                SWT.error(2);
            }
            data.driver = defaultData.driver;
            data.name = defaultData.name;
        }
        return data;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    static int restoreInt(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Integer.parseInt(new String(value));
    }

    static double restoreDouble(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Double.parseDouble(new String(value));
    }

    static boolean restoreBoolean(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Boolean.valueOf(new String(value));
    }

    static byte[] restoreBytes(String key, boolean nullTerminate) {
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        byte[] keyBuffer = new byte[++end - start];
        System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        int length = end - start;
        ++end;
        if (nullTerminate) {
            ++length;
        }
        byte[] valueBuffer = new byte[length];
        System.arraycopy(settingsData, start, valueBuffer, 0, length);
        if (DEBUG) {
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(keyBuffer))) + ": " + new String(Converter.mbcsToWcs(valueBuffer)));
        }
        return valueBuffer;
    }

    @Override
    public long internal_new_GC(GCData data) {
        long drawable = 0L;
        long gc = this.cairo;
        if (gc == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((data.style & (mask = 0x6000000)) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = drawable;
            if (GTK.GTK3) {
                data.backgroundRGBA = this.getSystemColor((int)1).handleRGBA;
                data.foregroundRGBA = this.getSystemColor((int)2).handleRGBA;
            } else {
                data.background = this.getSystemColor((int)1).handle;
                data.foreground = this.getSystemColor((int)2).handle;
            }
            data.font = this.getSystemFont();
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            data.width = (int)(GTK.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x);
            data.height = (int)(GTK.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y);
            if (this.cairo == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_identity_matrix(this.cairo);
            double printX = GTK.gtk_page_setup_get_left_margin(this.pageSetup, 1);
            double printY = GTK.gtk_page_setup_get_top_margin(this.pageSetup, 1);
            Cairo.cairo_translate(this.cairo, printX, printY);
            Cairo.cairo_scale(this.cairo, (float)screenDPI.x / (float)dpi.x, (float)screenDPI.y / (float)dpi.y);
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(this.cairo, matrix);
            data.identity = matrix;
            data.cairo = this.cairo;
            this.isGCCreated = true;
        }
        return gc;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        byte[] buffer = Converter.wcsToMbcs(jobName, true);
        this.printJob = GTK.gtk_print_job_new(buffer, this.printer, this.settings, this.pageSetup);
        if (this.printJob == 0L) {
            return false;
        }
        this.surface = GTK.gtk_print_job_get_surface(this.printJob, null);
        if (this.surface == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        return true;
    }

    @Override
    protected void destroy() {
        if (this.printer != 0L) {
            OS.g_object_unref(this.printer);
        }
        if (this.settings != 0L) {
            OS.g_object_unref(this.settings);
        }
        if (this.pageSetup != 0L) {
            OS.g_object_unref(this.pageSetup);
        }
        if (this.cairo != 0L) {
            Cairo.cairo_destroy(this.cairo);
        }
        if (this.printJob != 0L) {
            OS.g_object_unref(this.printJob);
        }
        this.printJob = 0L;
        this.cairo = 0L;
        this.pageSetup = 0L;
        this.settings = 0L;
        this.printer = 0L;
    }

    public void endJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        GTK.gtk_print_job_send(this.printJob, 0L, 0L, 0L);
        OS.g_object_unref(this.printJob);
        this.printJob = 0L;
    }

    public void cancelJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.g_object_unref(this.printJob);
        this.printJob = 0L;
    }

    public boolean startPage() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return false;
        }
        double width = GTK.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double height = GTK.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        int type = Cairo.cairo_surface_get_type(this.surface);
        switch (type) {
            case 2: {
                Cairo.cairo_ps_surface_set_size(this.surface, width, height);
                break;
            }
            case 1: {
                Cairo.cairo_pdf_surface_set_size(this.surface, width, height);
            }
        }
        return true;
    }

    public void endPage() {
        this.checkDevice();
        Cairo.cairo_show_page(this.cairo);
    }

    @Override
    public Point getDPI() {
        this.checkDevice();
        int resolution = GTK.gtk_print_settings_get_resolution(this.settings);
        if (DEBUG) {
            System.out.println("print_settings.resolution=" + resolution);
        }
        if (resolution == 0) {
            return new Point(72, 72);
        }
        return new Point(resolution, resolution);
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double width = GTK.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double height = GTK.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double width = GTK.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double height = GTK.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    Point getIndependentDPI() {
        return new Point(72, 72);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double printWidth = GTK.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double printHeight = GTK.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double paperWidth = GTK.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double paperHeight = GTK.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double printX = -GTK.gtk_page_setup_get_left_margin(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double printY = -GTK.gtk_page_setup_get_top_margin(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double hTrim = paperWidth - printWidth;
        double vTrim = paperHeight - printHeight;
        return new Rectangle(x + (int)printX, y + (int)printY, width + (int)hTrim, height + (int)vTrim);
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        if (disablePrinting) {
            SWT.error(2);
        }
        this.printer = Printer.gtkPrinterFromPrinterData(this.data);
        if (this.printer == 0L) {
            SWT.error(2);
        }
    }

    @Override
    protected void init() {
        byte[] uri;
        this.settings = GTK.gtk_print_settings_new();
        this.pageSetup = GTK.gtk_page_setup_new();
        if (this.data.otherData != null) {
            Printer.restore(this.data.otherData, this.settings, this.pageSetup);
        }
        if (this.data.printToFile && this.data.fileName != null && (uri = Printer.uriFromFilename(this.data.fileName)) != null) {
            GTK.gtk_print_settings_set(this.settings, GTK.GTK_PRINT_SETTINGS_OUTPUT_URI, uri);
        }
        GTK.gtk_print_settings_set_n_copies(this.settings, this.data.copyCount);
        GTK.gtk_print_settings_set_collate(this.settings, this.data.collate);
        if (this.data.duplex != -1) {
            int duplex = this.data.duplex == 1 ? 1 : (this.data.duplex == 2 ? 2 : 0);
            GTK.gtk_print_settings_set_duplex(this.settings, duplex);
            String cupsDuplexType = null;
            if (duplex == 1) {
                cupsDuplexType = "DuplexNoTumble";
            } else if (duplex == 2) {
                cupsDuplexType = "DuplexTumble";
            }
            if (cupsDuplexType != null) {
                byte[] keyBuffer = Converter.wcsToMbcs("cups-Duplex", true);
                byte[] valueBuffer = Converter.wcsToMbcs(cupsDuplexType, true);
                GTK.gtk_print_settings_set(this.settings, keyBuffer, valueBuffer);
            }
        }
        int orientation = this.data.orientation == 2 ? 1 : 0;
        GTK.gtk_page_setup_set_orientation(this.pageSetup, orientation);
        GTK.gtk_print_settings_set_orientation(this.settings, orientation);
        super.init();
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

