/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.lang.reflect.Type;
import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    long fixedHandle;
    long redrawWindow;
    long enableWindow;
    long provider;
    int drawCount;
    int backgroundAlpha = 255;
    long enterNotifyEventId;
    long dragGesture;
    long zoomGesture;
    long rotateGesture;
    long panGesture;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Control labelRelation;
    String cssBackground;
    String cssForeground = " ";
    boolean reparentOnVisibility;
    LinkedList<Event> dragDetectionQueue;
    static Callback enterNotifyEventFunc;
    static int enterNotifyEventSignalId;
    static int GTK_POINTER_WINDOW;
    static int SWT_GRAB_WIDGET;
    static Callback gestureZoom;
    static Callback gestureRotation;
    static Callback gestureSwipe;
    static Callback gestureBegin;
    static Callback gestureEnd;

    static {
        gestureZoom = new Callback(Control.class, "magnifyProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Long.TYPE});
        if (gestureZoom.getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureRotation = new Callback(Control.class, "rotateProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureSwipe = new Callback(Control.class, "swipeProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureBegin = new Callback(Control.class, "gestureBeginProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureEnd = new Callback(Control.class, "gestureEndProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
    }

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    void connectPaint() {
        long paintHandle = this.paintHandle();
        int paintMask = 2;
        GTK.gtk_widget_add_events(paintHandle, paintMask);
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(19), false);
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    GdkRGBA defaultBackground() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        return this.display.getSystemColor((int)22).handleRGBA;
    }

    @Override
    void deregister() {
        long imHandle;
        super.deregister();
        if (this.fixedHandle != 0L) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((imHandle = this.imHandle()) != 0L) {
            this.display.removeWidget(imHandle);
        }
    }

    void drawBackground(Control control, long window, long region, int x, int y, int width, int height) {
        this.drawBackground(control, window, 0L, region, x, y, width, height);
    }

    void drawBackground(Control control, long window, long cr, long region, int x, int y, int width, int height) {
        long cairo;
        long l = cairo = cr != 0L ? cr : GDK.gdk_cairo_create(window);
        if (cairo == 0L) {
            this.error(2);
        }
        if (region != 0L) {
            GDK.gdk_cairo_region(cairo, region);
            Cairo.cairo_clip(cairo);
        }
        if (control.backgroundImage != null) {
            Point pt = this.display.mapInPixels(this, control, 0, 0);
            Cairo.cairo_translate(cairo, -pt.x, -pt.y);
            x += pt.x;
            y += pt.y;
            long pattern = Cairo.cairo_pattern_create_for_surface(control.backgroundImage.surface);
            if (pattern == 0L) {
                this.error(2);
            }
            Cairo.cairo_pattern_set_extend(pattern, 1);
            if ((this.style & 0x8000000) != 0) {
                double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                Cairo.cairo_pattern_set_matrix(pattern, matrix);
            }
            Cairo.cairo_set_source(cairo, pattern);
            Cairo.cairo_pattern_destroy(pattern);
        } else if (GTK.GTK3) {
            GdkRGBA rgba = control.getBackgroundGdkRGBA();
            Cairo.cairo_set_source_rgba(cairo, rgba.red, rgba.green, rgba.blue, rgba.alpha);
        } else {
            GdkColor color = control.getBackgroundGdkColor();
            Cairo.cairo_set_source_rgba_compatibility(cairo, color);
        }
        Cairo.cairo_rectangle(cairo, x, y, width, height);
        Cairo.cairo_fill(cairo);
        if (cairo != cr) {
            Cairo.cairo_destroy(cairo);
        }
    }

    boolean drawGripper(GC gc, int x, int y, int width, int height, boolean vertical) {
        int orientation;
        long paintHandle = this.paintHandle();
        long window = this.gtk_widget_get_window(paintHandle);
        if (window == 0L) {
            return false;
        }
        int n = orientation = vertical ? 0 : 1;
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        if (GTK.GTK3) {
            long context = GTK.gtk_widget_get_style_context(paintHandle);
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_PANE_SEPARATOR);
            GTK.gtk_style_context_set_state(context, 0L);
            GTK.gtk_render_handle(context, gc.handle, x, y, width, height);
            GTK.gtk_style_context_restore(context);
        } else {
            GTK.gtk_paint_handle(GTK.gtk_widget_get_style(paintHandle), window, 0, 2, null, paintHandle, new byte[1], x, y, width, height, orientation);
        }
        return true;
    }

    void drawWidget(GC gc) {
    }

    void enableWidget(boolean enabled) {
        GTK.gtk_widget_set_sensitive(this.handle, enabled);
    }

    long enterExitHandle() {
        return this.eventHandle();
    }

    long eventHandle() {
        return this.handle;
    }

    long eventWindow() {
        long eventHandle = this.eventHandle();
        GTK.gtk_widget_realize(eventHandle);
        return this.gtk_widget_get_window(eventHandle);
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        long focusHandle = shell.vboxHandle;
        GTK.gtk_widget_set_can_focus(focusHandle, true);
        GTK.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return;
        }
        GTK.gtk_widget_set_can_focus(focusHandle, false);
    }

    void fixStyle() {
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(long handle) {
        long childStyle;
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
        if (!GTK.GTK3 && (childStyle = this.parent.childStyle()) != 0L) {
            GdkColor color = new GdkColor();
            GTK.gtk_style_get_bg(childStyle, 0, color);
            this.setBackgroundGdkColor(color);
        }
    }

    long focusHandle() {
        return this.handle;
    }

    long fontHandle() {
        return this.handle;
    }

    long gestureHandle() {
        return this.handle;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    @Override
    void hookEvents() {
        long focusHandle = this.focusHandle();
        int focusMask = 19456;
        GTK.gtk_widget_add_events(focusHandle, focusMask);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[38], 0, this.display.getClosure(38), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[28], 0, this.display.getClosure(28), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[20], 0, this.display.getClosure(20), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
        OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        long eventHandle = this.eventHandle();
        int eventMask = 10486532;
        GTK.gtk_widget_add_events(eventHandle, eventMask);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[43], 0, this.display.getClosure(43), false);
        long enterExitHandle = this.enterExitHandle();
        int enterExitMask = 12288;
        GTK.gtk_widget_add_events(enterExitHandle, enterExitMask);
        OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
        this.setZoomGesture();
        this.setDragGesture();
        this.setRotateGesture();
        long blockHandle = this.fixedHandle != 0L ? this.fixedHandle : eventHandle;
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[2], 0, this.display.getClosure(3), true);
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[4], 0, this.display.getClosure(5), true);
        OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[33], 0, this.display.getClosure(34), true);
        OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        if (focusHandle != eventHandle) {
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        this.connectPaint();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.getClosure(40), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.getClosure(56), false);
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            OS.g_signal_connect_closure(imHandle, OS.commit, this.display.getClosure(9), false);
            OS.g_signal_connect_closure(imHandle, OS.preedit_changed, this.display.getClosure(39), false);
        }
        OS.g_signal_connect_closure_by_id(this.paintHandle(), this.display.signalIds[48], 0, this.display.getClosure(48), false);
        long topHandle = this.topHandle();
        OS.g_signal_connect_closure_by_id(topHandle, this.display.signalIds[30], 0, this.display.getClosure(30), true);
        if (enterNotifyEventFunc == null && GTK.GTK3 && GTK.GTK_VERSION < OS.VERSION(3, 11, 9)) {
            enterNotifyEventFunc = new Callback(Control.class, "enterNotifyEventProc", 4);
            if (enterNotifyEventFunc.getAddress() == 0L) {
                SWT.error(3);
            }
            enterNotifyEventSignalId = OS.g_signal_lookup(OS.enter_notify_event, GTK.GTK_TYPE_WIDGET());
            byte[] buffer = Converter.wcsToMbcs("gtk-pointer-window", true);
            GTK_POINTER_WINDOW = OS.g_quark_from_string(buffer);
            buffer = Converter.wcsToMbcs("swt-grab-widget", true);
            SWT_GRAB_WIDGET = OS.g_quark_from_string(buffer);
        }
    }

    boolean hooksPaint() {
        return this.hooks(9) || this.filters(9);
    }

    @Override
    long hoverProc(long widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        int[] mask = new int[1];
        this.gdk_window_get_device_position(0L, x, y, mask);
        this.sendMouseEvent(32, 0, 0, x[0], y[0], false, mask[0]);
        return 0L;
    }

    @Override
    long topHandle() {
        if (this.fixedHandle != 0L) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    long paintHandle() {
        long topHandle = this.topHandle();
        long paintHandle = this.handle;
        while (paintHandle != topHandle) {
            if (GTK.gtk_widget_get_has_window(paintHandle)) break;
            paintHandle = GTK.gtk_widget_get_parent(paintHandle);
        }
        return paintHandle;
    }

    @Override
    long paintWindow() {
        long paintHandle = this.paintHandle();
        GTK.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_window(paintHandle);
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        long topHandle = this.topHandle();
        GTK.gtk_widget_realize(topHandle);
        if (GTK.GTK3) {
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(topHandle, allocation);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                GTK.gtk_widget_get_preferred_size(topHandle, null, null);
            }
            GTK.gtk_widget_size_allocate(topHandle, allocation);
            GTK.gtk_widget_draw(topHandle, gc.handle);
            return true;
        }
        long window = this.gtk_widget_get_window(topHandle);
        GCData data = gc.getGCData();
        GDK.gdk_window_process_updates(window, true);
        long drawable = data.drawable;
        if (drawable == 0L) {
            drawable = GDK.gdk_get_default_root_window();
        }
        this.printWidget(gc, drawable, GDK.gdk_drawable_get_depth(drawable), 0, 0);
        return true;
    }

    void printWidget(GC gc, long drawable, int depth, int x, int y) {
        boolean obscured = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        long topHandle = this.topHandle();
        long window = this.gtk_widget_get_window(topHandle);
        this.printWindow(true, this, gc, drawable, depth, window, x, y);
        if (obscured) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean first, Control control, GC gc, long drawable, int depth, long window, int x, int y) {
        if (GDK.gdk_drawable_get_depth(window) != depth) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        int[] width = new int[1];
        int[] height = new int[1];
        this.gdk_window_get_size(window, width, height);
        rect.width = width[0];
        rect.height = height[0];
        GDK.gdk_window_begin_paint_rect(window, rect);
        long[] real_drawable = new long[1];
        int[] x_offset = new int[1];
        int[] y_offset = new int[1];
        GDK.gdk_window_get_internal_paint_info(window, real_drawable, x_offset, y_offset);
        long[] userData = new long[1];
        GDK.gdk_window_get_user_data(window, userData);
        if (userData[0] != 0L) {
            long eventPtr = GDK.gdk_event_new(2);
            GdkEventExpose event = new GdkEventExpose();
            event.type = 2;
            event.window = OS.g_object_ref(window);
            event.area_width = rect.width;
            event.area_height = rect.height;
            event.region = GDK.gdk_region_rectangle(rect);
            OS.memmove(eventPtr, event, (long)GdkEventExpose.sizeof);
            GTK.gtk_widget_send_expose(userData[0], eventPtr);
            GDK.gdk_event_free(eventPtr);
        }
        int destX = x;
        int destY = y;
        int destWidth = width[0];
        int destHeight = height[0];
        if (!first) {
            int[] cX = new int[1];
            int[] cY = new int[1];
            GDK.gdk_window_get_position(window, cX, cY);
            long parentWindow = GDK.gdk_window_get_parent(window);
            int[] pW = new int[1];
            int[] pH = new int[1];
            this.gdk_window_get_size(parentWindow, pW, pH);
            destX = x - cX[0];
            destY = y - cY[0];
            destWidth = Math.min(cX[0] + width[0], pW[0]);
            destHeight = Math.min(cY[0] + height[0], pH[0]);
        }
        GCData gcData = gc.getGCData();
        long cairo = gcData.cairo;
        long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
        long xVisual = GDK.gdk_x11_visual_get_xvisual(GDK.gdk_visual_get_system());
        long xDrawable = GDK.GDK_PIXMAP_XID(real_drawable[0]);
        long surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width[0], height[0]);
        if (surface == 0L) {
            this.error(2);
        }
        Cairo.cairo_save(cairo);
        Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
        Cairo.cairo_clip(cairo);
        Cairo.cairo_translate(cairo, destX, destY);
        long pattern = Cairo.cairo_pattern_create_for_surface(surface);
        if (pattern == 0L) {
            this.error(2);
        }
        Cairo.cairo_pattern_set_filter(pattern, 2);
        Cairo.cairo_set_source(cairo, pattern);
        if (gcData.alpha != 255) {
            Cairo.cairo_paint_with_alpha(cairo, (float)gcData.alpha / 255.0f);
        } else {
            Cairo.cairo_paint(cairo);
        }
        Cairo.cairo_restore(cairo);
        Cairo.cairo_pattern_destroy(pattern);
        Cairo.cairo_surface_destroy(surface);
        GDK.gdk_window_end_paint(window);
        long children = GDK.gdk_window_get_children(window);
        if (children != 0L) {
            long windows = children;
            while (windows != 0L) {
                long child = OS.g_list_data(windows);
                if (GDK.gdk_window_is_visible(child)) {
                    Widget widget;
                    long[] data = new long[1];
                    GDK.gdk_window_get_user_data(child, data);
                    if (data[0] != 0L && ((widget = this.display.findWidget(data[0])) == null || widget == control)) {
                        int[] x_pos = new int[1];
                        int[] y_pos = new int[1];
                        GDK.gdk_window_get_position(child, x_pos, y_pos);
                        this.printWindow(false, control, gc, drawable, depth, child, x + x_pos[0], y + y_pos[0]);
                    }
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(children);
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    Point computeSizeInPixels(int wHint, int hHint) {
        return this.computeSizeInPixels(wHint, hHint, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0 || this.backgroundAlpha == 0) {
                if (mode == 1 || this.backgroundAlpha == 0) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkForeground() {
        if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0) && GTK.GTK_VERSION >= OS.VERSION(3, 0, 0)) {
            this.setForegroundGdkRGBA(this.topHandle(), this.display.COLOR_WIDGET_FOREGROUND_RGBA);
        }
    }

    void checkBorder() {
        if (this.getBorderWidthInPixels() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    long childStyle() {
        return this.parent.childStyle();
    }

    @Override
    void createWidget(int index) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.checkBackground();
        this.checkForeground();
        if ((this.state & 0x8000) != 0) {
            this.setParentBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        this.setRelations();
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        wHint = DPIUtil.autoScaleUp(wHint);
        hHint = DPIUtil.autoScaleUp(hHint);
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(wHint, hHint, changed));
    }

    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    Point computeNativeSize(long h, int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = hHint;
        if (GTK.GTK3) {
            if (wHint == -1 && hHint == -1) {
                GtkRequisition requisition = new GtkRequisition();
                GTK.gtk_widget_get_preferred_size(h, null, requisition);
                width = requisition.width;
                height = requisition.height;
            } else if (wHint == -1 || hHint == -1) {
                int[] natural_size = new int[1];
                if (wHint == -1) {
                    GTK.gtk_widget_get_preferred_width_for_height(h, height, null, natural_size);
                    width = natural_size[0];
                } else {
                    GTK.gtk_widget_get_preferred_height_for_width(h, width, null, natural_size);
                    height = natural_size[0];
                }
            }
            return new Point(width, height);
        }
        if (wHint == -1 && hHint == -1) {
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(h, requisition);
            width = GTK.GTK_WIDGET_REQUISITION_WIDTH(h);
            height = GTK.GTK_WIDGET_REQUISITION_HEIGHT(h);
        } else if (wHint == -1 || hHint == -1) {
            int[] reqWidth = new int[1];
            int[] reqHeight = new int[1];
            GTK.gtk_widget_get_size_request(h, reqWidth, reqHeight);
            GTK.gtk_widget_set_size_request(h, wHint, hHint);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(h, requisition);
            GTK.gtk_widget_set_size_request(h, reqWidth[0], reqHeight[0]);
            width = wHint == -1 ? requisition.width : wHint;
            height = hHint == -1 ? requisition.height : hHint;
        }
        return new Point(width, height);
    }

    void forceResize() {
        long topHandle = this.topHandle();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(topHandle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        GTK.gtk_widget_size_allocate(topHandle, allocation);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        return this._getAccessible();
    }

    Accessible _getAccessible() {
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int height;
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        rect = DPIUtil.autoScaleUp(rect);
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    void setBoundsInPixels(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    void setBoundsInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    void markLayout(boolean changed, boolean all) {
    }

    @Override
    void modifyStyle(long handle, long style) {
        super.modifyStyle(handle, style);
        if (this.region != null) {
            GDK.gdk_window_shape_combine_region(this.gtk_widget_get_window(this.topHandle()), this.region.handle, 0, 0);
        }
    }

    void moveHandle(int x, int y) {
        long topHandle = this.topHandle();
        long parentHandle = this.parent.parentingHandle();
        if (GTK.GTK3) {
            OS.swt_fixed_move(parentHandle, topHandle, x, y);
        } else {
            boolean reset = GTK.gtk_widget_get_visible(parentHandle);
            this.gtk_widget_set_visible(parentHandle, false);
            GTK.gtk_fixed_move(parentHandle, topHandle, x, y);
            this.gtk_widget_set_visible(parentHandle, reset);
        }
    }

    void resizeHandle(int width, int height) {
        long topHandle = this.topHandle();
        if (GTK.GTK3) {
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(topHandle), topHandle, width, height);
            if (topHandle != this.handle) {
                Point sizes = this.resizeCalculationsGTK3(this.handle, width, height);
                width = sizes.x;
                height = sizes.y;
                OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.handle), this.handle, width, height);
            }
        } else {
            GTK.gtk_widget_set_size_request(topHandle, width, height);
            if (topHandle != this.handle) {
                GTK.gtk_widget_set_size_request(this.handle, width, height);
            }
        }
    }

    Point resizeCalculationsGTK3(long widget, int width, int height) {
        Point sizes = new Point(width, height);
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            GtkRequisition minimumSize = new GtkRequisition();
            GtkRequisition naturalSize = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(widget, minimumSize, naturalSize);
            int smallestWidth = Math.min(minimumSize.width, naturalSize.width);
            int smallestHeight = Math.min(minimumSize.height, naturalSize.height);
            sizes.x = width - (smallestWidth - width) < 0 ? smallestWidth : width;
            sizes.y = height - (smallestHeight - height) < 0 ? smallestHeight : height;
        }
        return sizes;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int oldX;
        width = Math.min(width, Short.MAX_VALUE);
        height = Math.min(height, Short.MAX_VALUE);
        long topHandle = this.topHandle();
        boolean sendMove = move;
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        if ((this.parent.style & 0x8000000) != 0) {
            int clientWidth = this.parent.getClientWidth();
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            oldX = clientWidth - oldWidth - allocation.x;
            if (move) {
                sendMove &= x != oldX;
                x = clientWidth - (resize ? width : oldWidth) - x;
            } else {
                move = true;
                x = clientWidth - (resize ? width : oldWidth) - oldX;
                y = allocation.y;
            }
        }
        boolean sameOrigin = true;
        boolean sameExtent = true;
        if (move) {
            oldX = allocation.x;
            int oldY = allocation.y;
            boolean bl = sameOrigin = x == oldX && y == oldY;
            if (!sameOrigin) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_move(this.enableWindow, x, y);
                }
                this.moveHandle(x, y);
            }
        }
        int clientWidth = 0;
        if (resize) {
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int oldHeight = (this.state & 0x400) != 0 ? 0 : allocation.height;
            boolean bl = sameExtent = width == oldWidth && height == oldHeight;
            if (!sameExtent && (this.style & 0x8000000) != 0) {
                clientWidth = this.getClientWidth();
            }
            if (!(sameExtent || width == 0 && height == 0)) {
                int newWidth = Math.max(1, width);
                int newHeight = Math.max(1, height);
                if (this.redrawWindow != 0L) {
                    GDK.gdk_window_resize(this.redrawWindow, newWidth, newHeight);
                }
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_resize(this.enableWindow, newWidth, newHeight);
                }
                this.resizeHandle(newWidth, newHeight);
            }
        }
        if (!sameOrigin || !sameExtent) {
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(topHandle, requisition);
            if (move) {
                allocation.x = x;
                allocation.y = y;
            }
            if (resize) {
                allocation.width = width;
                allocation.height = height;
            }
            if (GTK.GTK_VERSION >= OS.VERSION(3, 8, 0) && !GTK.gtk_widget_get_visible(topHandle)) {
                GTK.gtk_widget_show(topHandle);
                this.gtk_widget_get_preferred_size(topHandle, requisition);
                GTK.gtk_widget_size_allocate(topHandle, allocation);
                GTK.gtk_widget_hide(topHandle);
            } else {
                GTK.gtk_widget_size_allocate(topHandle, allocation);
            }
        }
        if (!sameExtent) {
            this.state = width == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n = this.state = height == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if ((this.state & 0x600) != 0) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_hide(this.enableWindow);
                }
                GTK.gtk_widget_hide(topHandle);
            } else if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                GTK.gtk_widget_show(topHandle);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(clientWidth);
            }
        }
        int result = 0;
        if (move && !sameOrigin) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (sendMove) {
                this.sendEvent(10);
            }
            result |= 0x80;
        }
        if (resize && !sameExtent) {
            this.sendEvent(11);
            result |= 0x100;
        }
        return result;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        if ((this.parent.style & 0x8000000) != 0) {
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            x = this.parent.getClientWidth() - width - x;
        }
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.autoScaleUp(location);
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        Point loc = DPIUtil.autoScaleUp(new Point(x, y));
        this.setBounds(loc.x, loc.y, 0, 0, true, false);
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        return new Point(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        size = DPIUtil.autoScaleUp(size);
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    void setSizeInPixels(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long window = this.gtk_widget_get_window(this.topHandle());
        long shape_region = region == null ? 0L : region.handle;
        GDK.gdk_window_shape_combine_region(window, shape_region, 0, 0);
        this.region = region;
    }

    void setRelations() {
        Widget widget;
        long handle;
        long parentHandle = this.parent.parentingHandle();
        long list = GTK.gtk_container_get_children(parentHandle);
        if (list == 0L) {
            return;
        }
        int count = OS.g_list_length(list);
        if (count > 1 && (handle = OS.g_list_nth_data(list, count - 2)) != 0L && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
            Control sibling = (Control)widget;
            sibling.addRelation(this);
        }
        OS.g_list_free(list);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        Point size = DPIUtil.autoScaleUp(new Point(width, height));
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    void setSizeInPixels(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    @Override
    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(long widget) {
        return widget == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int oldWidth) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        long window = this.eventWindow();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        GDK.gdk_window_get_origin(window, origin_x, origin_y);
        x -= DPIUtil.autoScaleDown(origin_x[0]);
        y -= DPIUtil.autoScaleDown(origin_y[0]);
        if ((this.style & 0x8000000) != 0) {
            x = DPIUtil.autoScaleDown(this.getClientWidth()) - x;
        }
        return new Point(x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        long window = this.eventWindow();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        GDK.gdk_window_get_origin(window, origin_x, origin_y);
        if ((this.style & 0x8000000) != 0) {
            x = DPIUtil.autoScaleDown(this.getClientWidth()) - x;
        }
        return new Point(x += DPIUtil.autoScaleDown(origin_x[0]), y += DPIUtil.autoScaleDown(origin_y[0]));
    }

    Point toDisplayInPixels(int x, int y) {
        this.checkWidget();
        long window = this.eventWindow();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        GDK.gdk_window_get_origin(window, origin_x, origin_y);
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        return new Point(x += origin_x[0], y += origin_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    Point toDisplayInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplayInPixels(point.x, point.y);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        if (this.labelRelation != null) {
            this._getAccessible().removeRelation(9, this.labelRelation._getAccessible());
            this.labelRelation = null;
        }
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, true, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean dragging = false;
        if (!OS.isX11()) {
            double[] offsetX = new double[1];
            double[] offsetY = new double[1];
            double[] startX = new double[1];
            double[] startY = new double[1];
            if (!GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) return false;
            GTK.gtk_gesture_drag_get_offset(this.dragGesture, offsetX, offsetY);
            if (!GTK.gtk_drag_check_threshold(this.handle, (int)startX[0], (int)startY[0], (int)startX[0] + (int)offsetX[0], (int)startY[0] + (int)offsetY[0])) return dragging;
            return true;
        }
        boolean quit = false;
        Point startPos = null;
        Point currPos = null;
        if (GTK.GTK3) {
            startPos = this.display.getCursorLocationInPixels();
        }
        while (!quit) {
            long eventPtr = 0L;
            long timeout = System.currentTimeMillis() + 500L;
            this.display.sendPreExternalEventDispatchEvent();
            while (System.currentTimeMillis() < timeout) {
                eventPtr = GDK.gdk_event_get();
                if (eventPtr != 0L) break;
                if (GTK.GTK3) {
                    currPos = this.display.getCursorLocationInPixels();
                    dragging = GTK.gtk_drag_check_threshold(this.handle, startPos.x, startPos.y, currPos.x, currPos.y);
                    if (!dragging) continue;
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            this.display.sendPostExternalEventDispatchEvent();
            if (dragging) {
                return true;
            }
            if (eventPtr == 0L) {
                return dragOnTimeout;
            }
            switch (GDK.GDK_EVENT_TYPE(eventPtr)) {
                case 3: {
                    GdkEventMotion gdkMotionEvent = new GdkEventMotion();
                    OS.memmove(gdkMotionEvent, eventPtr, (long)GdkEventMotion.sizeof);
                    if ((gdkMotionEvent.state & 0x100) != 0) {
                        if (GTK.gtk_drag_check_threshold(this.handle, x, y, (int)gdkMotionEvent.x, (int)gdkMotionEvent.y)) {
                            dragging = true;
                            quit = true;
                        }
                    } else {
                        quit = true;
                    }
                    int[] newX = new int[1];
                    int[] newY = new int[1];
                    this.gdk_window_get_device_position(gdkMotionEvent.window, newX, newY, null);
                    break;
                }
                case 8: 
                case 9: {
                    GdkEventKey gdkEvent = new GdkEventKey();
                    OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
                    if (gdkEvent.keyval != 65307) break;
                    quit = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    GDK.gdk_event_put(eventPtr);
                    quit = true;
                    break;
                }
                default: {
                    GTK.gtk_main_do_event(eventPtr);
                }
            }
            GDK.gdk_event_free(eventPtr);
        }
        return dragging;
    }

    boolean filterKey(int keyval, long event) {
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            return GTK.gtk_im_context_filter_keypress(imHandle, event);
        }
        return false;
    }

    Control findBackgroundControl() {
        if (((this.state & 0x2000) != 0 || this.backgroundImage != null) && this.backgroundAlpha > 0) {
            return this;
        }
        return this.parent != null && (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    void fixParentGdkWindow() {
        assert (GTK.GTK3);
        this.parent.setParentGdkWindow(this);
    }

    static void gtk_widget_reparent(Control control, long newParentHandle) {
        if (GTK.GTK3) {
            long widget = control.topHandle();
            long parentContainer = GTK.gtk_widget_get_parent(widget);
            assert (parentContainer != 0L) : "Improper use of Control.gtk_widget_reparent. Widget currently has no parent.";
            if (parentContainer != 0L) {
                OS.g_object_ref(widget);
                GTK.gtk_container_remove(parentContainer, widget);
                GTK.gtk_container_add(newParentHandle, widget);
                OS.g_object_unref(widget);
                control.fixParentGdkWindow();
            }
        } else {
            GTK.gtk_widget_reparent(control.topHandle(), newParentHandle);
        }
    }

    @Override
    long fixedMapProc(long widget) {
        GTK.gtk_widget_set_mapped(widget, true);
        long widgetList = GTK.gtk_container_get_children(widget);
        if (widgetList != 0L) {
            long widgets = widgetList;
            while (widgets != 0L) {
                long child = OS.g_list_data(widgets);
                if (GTK.gtk_widget_get_visible(child) && GTK.gtk_widget_get_child_visible(child) && !GTK.gtk_widget_get_mapped(child)) {
                    GTK.gtk_widget_map(child);
                }
                widgets = OS.g_list_next(widgets);
            }
            OS.g_list_free(widgetList);
        }
        if (GTK.gtk_widget_get_has_window(widget)) {
            GDK.gdk_window_show_unraised(this.gtk_widget_get_window(widget));
        }
        return 0L;
    }

    void fixModal(long group, long modalGroup) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(long focusHandle) {
        if (GTK.gtk_widget_has_focus(focusHandle)) {
            return true;
        }
        GTK.gtk_widget_realize(focusHandle);
        GTK.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return false;
        }
        Shell shell = this.getShell();
        long shellHandle = shell.shellHandle;
        long handle = GTK.gtk_window_get_focus(shellHandle);
        while (handle != 0L) {
            if (handle == focusHandle) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(handle);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            handle = GTK.gtk_widget_get_parent(handle);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        if (GTK.GTK3) {
            if (this.backgroundAlpha == 0) {
                Color color = Color.gtk_new((Device)this.display, this.getBackgroundGdkRGBA(), 0);
                return color;
            }
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            return Color.gtk_new((Device)this.display, control.getBackgroundGdkRGBA(), this.backgroundAlpha);
        }
        if (this.backgroundAlpha == 0) {
            Color color = Color.gtk_new((Device)this.display, this.getBackgroundGdkColor(), 0);
            return color;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new((Device)this.display, control.getBackgroundGdkColor(), this.backgroundAlpha);
    }

    GdkRGBA getBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        return this.getBgGdkRGBA();
    }

    GdkColor getBackgroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getBgGdkColor();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        long fontHandle = this.fontHandle();
        if ((this.state & 0x2000) == 0) {
            return this.defaultBackground();
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            if (this.provider != 0L) {
                return this.display.gtk_css_parse_background(this.provider, null);
            }
            return this.defaultBackground();
        }
        long context = GTK.gtk_widget_get_style_context(fontHandle);
        GdkRGBA rgba = new GdkRGBA();
        GTK.gtk_style_context_get_background_color(context, 0, rgba);
        return rgba;
    }

    GdkRGBA getContextColorGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        long fontHandle = this.fontHandle();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            return this.display.gtk_css_parse_foreground(this.provider, null);
        }
        long context = GTK.gtk_widget_get_style_context(fontHandle);
        GdkRGBA rgba = this.display.styleContextGetColor(context, 0);
        return rgba;
    }

    GdkRGBA getBgGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        return this.getContextBackgroundGdkRGBA();
    }

    GdkColor getBgGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        long fontHandle = this.fontHandle();
        GTK.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        long style = GTK.gtk_widget_get_style(fontHandle);
        if (style != 0L) {
            GTK.gtk_style_get_bg(style, 0, color);
        }
        return color;
    }

    GdkRGBA getBaseGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        return this.getContextBackgroundGdkRGBA();
    }

    GdkColor getBaseGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        long fontHandle = this.fontHandle();
        GTK.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        GTK.gtk_style_get_base(GTK.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    public int getBorderWidth() {
        return DPIUtil.autoScaleDown(this.getBorderWidthInPixels());
    }

    int getBorderWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        if (this.handle == 0L || (this.state & 0x200) != 0) {
            return 0;
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        return allocation.width;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    long getFontDescription() {
        long fontHandle = this.fontHandle();
        long[] fontDesc = new long[1];
        if (GTK.GTK3) {
            long context = GTK.gtk_widget_get_style_context(fontHandle);
            if (GTK.GTK_VERSION < OS.VERSION(3, 8, 0)) {
                return GTK.gtk_style_context_get_font(context, 0);
            }
            if (GTK.GTK_VERSION >= OS.VERSION(3, 18, 0)) {
                GTK.gtk_style_context_save(context);
                GTK.gtk_style_context_set_state(context, 0L);
                GTK.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, fontDesc, 0L);
                GTK.gtk_style_context_restore(context);
                return fontDesc[0];
            }
            GTK.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, fontDesc, 0L);
            return fontDesc[0];
        }
        GTK.gtk_widget_realize(fontHandle);
        return GTK.gtk_style_get_font_desc(GTK.gtk_widget_get_style(fontHandle));
    }

    public Color getForeground() {
        this.checkWidget();
        Color color = GTK.GTK3 ? Color.gtk_new((Device)this.display, this.getForegroundGdkRGBA()) : Color.gtk_new((Device)this.display, this.getForegroundGdkColor());
        return color;
    }

    GdkRGBA getForegroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        return this.getContextColorGdkRGBA();
    }

    GdkColor getForegroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        long fontHandle = this.fontHandle();
        GTK.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        long style = GTK.gtk_widget_get_style(fontHandle);
        if (style != 0L) {
            GTK.gtk_style_get_fg(style, 0, color);
        }
        return color;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        long fontHandle = this.fontHandle();
        GTK.gtk_widget_realize(fontHandle);
        GdkColor color = new GdkColor();
        GTK.gtk_style_get_text(GTK.gtk_widget_get_style(fontHandle), 0, color);
        return color;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        long screen = GDK.gdk_screen_get_default();
        if (screen != 0L) {
            int monitorNumber = GDK.gdk_screen_get_monitor_at_window(screen, this.paintWindow());
            Monitor[] monitors = this.display.getMonitors();
            if (monitorNumber >= 0 && monitorNumber < monitors.length) {
                return monitors[monitorNumber];
            }
        }
        return this.display.getPrimaryMonitor();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    Point getThickness(long widget) {
        if (GTK.GTK3) {
            int xthickness = 0;
            int ythickness = 0;
            GtkBorder tmp = new GtkBorder();
            long context = GTK.gtk_widget_get_style_context(widget);
            if (GTK.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                GTK.gtk_style_context_get_padding(context, 0, tmp);
            } else {
                GTK.gtk_style_context_get_padding(context, GTK.gtk_widget_get_state_flags(widget), tmp);
            }
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_FRAME);
            xthickness += tmp.left;
            ythickness += tmp.top;
            if (GTK.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                GTK.gtk_style_context_get_border(context, 0, tmp);
            } else {
                GTK.gtk_style_context_get_border(context, GTK.gtk_widget_get_state_flags(widget), tmp);
            }
            GTK.gtk_style_context_restore(context);
            return new Point(xthickness += tmp.left, ythickness += tmp.top);
        }
        long style = GTK.gtk_widget_get_style(widget);
        return new Point(GTK.gtk_style_get_xthickness(style), GTK.gtk_style_get_ythickness(style));
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        return this.gtk_button_press_event(widget, event, true);
    }

    long gtk_button_press_event(long widget, long event, boolean sendMouseDown) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0L;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        long result = 0L;
        if (gdkEvent.type == 4) {
            boolean dragging = false;
            this.display.clickCount = 1;
            long nextEvent = GDK.gdk_event_peek();
            if (nextEvent != 0L) {
                int eventType = GDK.GDK_EVENT_TYPE(nextEvent);
                if (eventType == 5) {
                    this.display.clickCount = 2;
                }
                if (eventType == 6) {
                    this.display.clickCount = 3;
                }
                GDK.gdk_event_free(nextEvent);
            }
            if (OS.isX11() && (this.state & 0x800000) != 0 && this.hooks(29) && gdkEvent.button == 1) {
                boolean[] consume = new boolean[1];
                if (this.dragDetect((int)gdkEvent.x, (int)gdkEvent.y, true, true, consume)) {
                    dragging = true;
                    if (consume[0]) {
                        result = 1L;
                    }
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (sendMouseDown && !this.sendMouseEvent(3, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state)) {
                result = 1L;
            }
            if (this.isDisposed()) {
                return 1L;
            }
            if (OS.isX11() && dragging) {
                Point scaledEvent = DPIUtil.autoScaleDown(new Point((int)gdkEvent.x, (int)gdkEvent.y));
                this.sendDragEvent(gdkEvent.button, gdkEvent.state, scaledEvent.x, scaledEvent.y, false);
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if ((this.state & 0x20) != 0 && gdkEvent.button == 3 && this.showMenu((int)gdkEvent.x_root, (int)gdkEvent.y_root)) {
                result = 1L;
            }
        } else {
            this.display.clickCount = 2;
            result = this.sendMouseEvent(8, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            if (this.isDisposed()) {
                return 1L;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this, 3);
        }
        return result;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        return this.sendMouseEvent(4, gdkEvent.button, this.display.clickCount, 0, false, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
    }

    @Override
    long gtk_commit(long imcontext, long text) {
        if (text == 0L) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        this.sendIMKeyEvent(1, null, chars);
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long widget, long event) {
        byte[] buffer = null;
        if (this.toolTipText != null && this.toolTipText.length() != 0) {
            char[] chars = this.fixMnemonic(this.toolTipText, false);
            buffer = Converter.wcsToMbcs(chars, true);
        }
        long toolHandle = this.getShell().handle;
        GTK.gtk_widget_set_tooltip_text(toolHandle, buffer);
        if (this.display.currentControl == this) {
            return 0L;
        }
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove(gdkEvent, event, (long)GdkEventCrossing.sizeof);
        if (gdkEvent.subwindow != 0L && this.checkSubwindow()) {
            return 0L;
        }
        if (gdkEvent.mode != 0 && gdkEvent.mode != 2) {
            return 0L;
        }
        if ((gdkEvent.state & 0x700) != 0) {
            return 0L;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
        }
        return 0L;
    }

    boolean checkSubwindow() {
        return false;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                if (widget != this.eventHandle() || (this.state & 0x20) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(widget)) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                Display display = this.display;
                if (gdkEventFocus.in != 0) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    long grabHandle = GTK.gtk_grab_get_current();
                    if (grabHandle != 0L && OS.G_OBJECT_TYPE(grabHandle) == GTK.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
            }
        }
        return 0L;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkRectangle rect = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
        Event event = new Event();
        event.count = 1;
        Rectangle eventBounds = DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height));
        if ((this.style & 0x8000000) != 0) {
            eventBounds.x = DPIUtil.autoScaleDown(this.getClientWidth()) - eventBounds.width - eventBounds.x;
        }
        event.setBounds(eventBounds);
        GCData data = new GCData();
        if (GTK.GTK_VERSION <= OS.VERSION(3, 9, 0) || GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            data.cairo = cairo;
        }
        GC gc = event.gc = GC.gtk_new(this, data);
        gc.setClipping(eventBounds.x, eventBounds.y, eventBounds.width, eventBounds.height);
        this.drawWidget(gc);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
        Event event = new Event();
        event.count = gdkEvent.count;
        Rectangle eventRect = new Rectangle(gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.width - event.x;
        }
        GCData data = new GCData();
        data.damageRgn = gdkEvent.region;
        GC gc = event.gc = GC.gtk_new(this, data);
        this.drawWidget(gc);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        return 1L;
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        if (this.handle != 0L) {
            long imHandle;
            long oldIMHandle;
            Control oldControl = this.display.imControl;
            if (oldControl != this && oldControl != null && !oldControl.isDisposed() && (oldIMHandle = oldControl.imHandle()) != 0L) {
                GTK.gtk_im_context_reset(oldIMHandle);
            }
            if ((this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0L) {
                GTK.gtk_im_context_focus_in(imHandle);
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long imHandle;
        if (this.handle != 0L && (this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0L) {
            GTK.gtk_im_context_focus_out(imHandle);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        if (!this.hasFocus()) {
            if (this.display.getActiveShell() == null) {
                GdkEventKey gdkEvent = new GdkEventKey();
                OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
                if (this.filterKey(gdkEvent.keyval, event)) {
                    return 1L;
                }
            }
            return 0L;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
        if (this.translateMnemonic(gdkEvent.keyval, gdkEvent)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.filterKey(gdkEvent.keyval, event)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.translateTraversal(gdkEvent)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        return super.gtk_key_press_event(widget, event);
    }

    @Override
    long gtk_key_release_event(long widget, long event) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long imHandle = this.imHandle();
        if (imHandle != 0L && GTK.gtk_im_context_filter_keypress(imHandle, event)) {
            return 1L;
        }
        return super.gtk_key_release_event(widget, event);
    }

    @Override
    long gtk_leave_notify_event(long widget, long event) {
        if (this.display.currentControl != this) {
            return 0L;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int result = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            GdkEventCrossing gdkEvent = new GdkEventCrossing();
            OS.memmove(gdkEvent, event, (long)GdkEventCrossing.sizeof);
            if (gdkEvent.mode != 0 && gdkEvent.mode != 2) {
                return 0L;
            }
            if ((gdkEvent.state & 0x700) != 0) {
                return 0L;
            }
            result = this.sendMouseEvent(7, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            this.display.currentControl = null;
        }
        return result;
    }

    @Override
    long gtk_mnemonic_activate(long widget, long arg1) {
        int result = 0;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, eventPtr, (long)GdkEventKey.sizeof);
            if (keyEvent.type == 8) {
                long focusHandle;
                Control focusControl = this.display.getFocusControl();
                long l = focusHandle = focusControl != null ? focusControl.focusHandle() : 0L;
                if (focusHandle != 0L) {
                    this.display.mnemonicControl = this;
                    GTK.gtk_widget_event(focusHandle, eventPtr);
                    this.display.mnemonicControl = null;
                }
                result = 1;
            }
            GDK.gdk_event_free(eventPtr);
        }
        return result;
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, event, (long)GdkEventMotion.sizeof);
        if (!OS.isX11()) {
            boolean[] consume;
            boolean dragging = false;
            if ((this.state & 0x800000) != 0 && this.hooks(29) && this.dragDetect((int)gdkEvent.x, (int)gdkEvent.y, true, true, consume = new boolean[1])) {
                dragging = true;
                if (consume[0]) {
                    boolean bl = true;
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (dragging) {
                GTK.gtk_event_controller_handle_event(this.dragGesture, event);
                GdkEventButton gdkEvent1 = new GdkEventButton();
                OS.memmove(gdkEvent1, event, (long)GdkEventButton.sizeof);
                if (gdkEvent1.type == 6) {
                    return 0L;
                }
                Point scaledEvent = DPIUtil.autoScaleDown(new Point((int)gdkEvent1.x, (int)gdkEvent1.y));
                if (this.sendDragEvent(gdkEvent1.button, gdkEvent1.state, scaledEvent.x, scaledEvent.y, false)) {
                    return 1L;
                }
            }
        }
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        double x = gdkEvent.x_root;
        double y = gdkEvent.y_root;
        int state = gdkEvent.state;
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            long window = this.eventWindow();
            this.gdk_window_get_device_position(window, pointer_x, pointer_y, mask);
            x = pointer_x[0];
            y = pointer_y[0];
            state = mask[0];
        }
        if (GTK.GTK3 && this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                Point pt = this.display.mapInPixels(this, this.display.currentControl, (int)x, (int)y);
                this.display.currentControl.sendMouseEvent(7, 0, gdkEvent.time, pt.x, pt.y, gdkEvent.is_hint != 0, state);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, gdkEvent.time, x, y, gdkEvent.is_hint != 0, state);
            }
        }
        int result = this.sendMouseEvent(5, 0, gdkEvent.time, x, y, gdkEvent.is_hint != 0, state) ? 0 : 1;
        return result;
    }

    @Override
    long gtk_popup_menu(long widget) {
        if (!this.hasFocus()) {
            return 0L;
        }
        int[] x = new int[1];
        int[] y = new int[1];
        this.gdk_window_get_device_position(0L, x, y, null);
        return this.showMenu(x[0], y[0], 1) ? 1 : 0;
    }

    @Override
    long gtk_preedit_changed(long imcontext) {
        this.display.showIMWindow(this);
        return 0L;
    }

    @Override
    long gtk_realize(long widget) {
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            long window = this.gtk_widget_get_window(this.paintHandle());
            GTK.gtk_im_context_set_client_window(imHandle, window);
        }
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_scroll_event(long widget, long eventPtr) {
        GdkEventScroll gdkEvent = new GdkEventScroll();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventScroll.sizeof);
        switch (gdkEvent.direction) {
            case 0: {
                return this.sendMouseEvent(37, 0, 3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 1: {
                return this.sendMouseEvent(37, 0, -3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 2: {
                return this.sendMouseEvent(38, 0, 3, 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 3: {
                return this.sendMouseEvent(38, 0, -3, 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
            }
            case 4: {
                long result = 0L;
                double[] delta_x = new double[1];
                double[] delta_y = new double[1];
                if (GDK.gdk_event_get_scroll_deltas(eventPtr, delta_x, delta_y)) {
                    if (delta_x[0] != 0.0) {
                        result = this.sendMouseEvent(38, 0, (int)(-3.0 * delta_x[0]), 0, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
                    }
                    if (delta_y[0] != 0.0) {
                        result = this.sendMouseEvent(37, 0, (int)(-3.0 * delta_y[0]), 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, false, gdkEvent.state) ? 0 : 1;
                    }
                }
                return result;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show_help(long widget, long helpType) {
        if (!this.hasFocus()) {
            return 0L;
        }
        return this.sendHelpEvent(helpType) ? 1 : 0;
    }

    @Override
    long gtk_style_set(long widget, long previousStyle) {
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_unrealize(long widget) {
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            GTK.gtk_im_context_set_client_window(imHandle, 0L);
        }
        return 0L;
    }

    void gtk_widget_size_request(long widget, GtkRequisition requisition) {
        this.gtk_widget_get_preferred_size(widget, requisition);
    }

    @Override
    public long internal_new_GC(GCData data) {
        long gc;
        this.checkWidget();
        long window = this.paintWindow();
        if (window == 0L) {
            this.error(2);
        }
        if ((gc = data.cairo) != 0L) {
            Cairo.cairo_reference(gc);
        } else {
            gc = GDK.gdk_cairo_create(window);
        }
        if (gc == 0L) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.drawable = window;
            data.device = this.display;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            Font font = data.font = this.font != null ? this.font : this.defaultFont();
            if (GTK.GTK3) {
                data.foregroundRGBA = this.getForegroundGdkRGBA();
                data.backgroundRGBA = control.getBackgroundGdkRGBA();
            } else {
                data.foreground = this.getForegroundGdkColor();
                data.background = control.getBackgroundGdkColor();
            }
        }
        return gc;
    }

    long imHandle() {
        return 0L;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        this.checkWidget();
        Cairo.cairo_destroy(hDC);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSizeInPixels();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    @Override
    void register() {
        long imHandle;
        super.register();
        if (this.fixedHandle != 0L) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((imHandle = this.imHandle()) != 0L) {
            this.display.addWidget(imHandle, this);
        }
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean all) {
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, all, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, all);
    }

    void redrawInPixels(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        this.redrawWidget(x, y, width, height, false, all, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long window = this.paintWindow();
        GdkRectangle rect = new GdkRectangle();
        if (redrawAll) {
            int[] w = new int[1];
            int[] h = new int[1];
            this.gdk_window_get_size(window, w, h);
            rect.width = w[0];
            rect.height = h[0];
        } else {
            rect.x = x;
            rect.y = y;
            rect.width = Math.max(0, width);
            rect.height = Math.max(0, height);
        }
        GDK.gdk_window_invalidate_rect(window, rect, all);
    }

    @Override
    void release(boolean destroy) {
        Control next = null;
        Control previous = null;
        if (destroy && this.parent != null) {
            Control[] children = this.parent._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (index > 0) {
                previous = children[index - 1];
            }
            if (index + 1 < children.length) {
                next = children[index + 1];
                next.removeRelation();
            }
            this.removeRelation();
        }
        super.release(destroy);
        if (destroy && previous != null && next != null) {
            previous.addRelation(next);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0L;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        this.parent.removeControl(this);
    }

    @Override
    void releaseWidget() {
        boolean hadFocus = this.display.getFocusControl() == this;
        super.releaseWidget();
        if (hadFocus) {
            this.fixFocus(this);
        }
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            GTK.gtk_im_context_reset(imHandle);
            GTK.gtk_im_context_set_client_window(imHandle, 0L);
        }
        if (this.enableWindow != 0L) {
            GDK.gdk_window_set_user_data(this.enableWindow, 0L);
            GDK.gdk_window_destroy(this.enableWindow);
            this.enableWindow = 0L;
        }
        this.redrawWindow = 0L;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    void restackWindow(long window, long sibling, boolean above) {
        GDK.gdk_window_restack(window, sibling, above);
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y, boolean isStateMask) {
        Event event = new Event();
        event.button = button;
        Rectangle eventRect = new Rectangle(x, y, 0, 0);
        event.setBounds(eventRect);
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        if (isStateMask) {
            event.stateMask = stateMask;
        } else {
            this.setInputState(event, stateMask);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int type) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = type;
        this.sendEvent(type);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double delta) {
        switch (detail) {
            case 8: {
                return this.sendGestureEvent(stateMask, detail, x, y, delta, 0, 0, 0.0);
            }
            case 32: {
                return this.sendGestureEvent(stateMask, detail, x, y, 0.0, 0, 0, delta);
            }
            case 2: {
                return this.sendGestureEvent(stateMask, detail, x, y, 0.0, 0, 0, delta);
            }
            case 4: {
                return this.sendGestureEvent(stateMask, detail, 0, 0, 0.0, 0, 0, 0.0);
            }
        }
        return false;
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double xDirection, double yDirection) {
        if (detail == 16) {
            return this.sendGestureEvent(stateMask, detail, x, y, 0.0, (int)xDirection, (int)yDirection, 0.0);
        }
        return false;
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double rotation, int xDirection, int yDirection, double magnification) {
        Event event = new Event();
        event.stateMask = stateMask;
        event.detail = detail;
        event.x = x;
        event.y = y;
        switch (detail) {
            case 8: {
                event.rotation = rotation;
                break;
            }
            case 32: {
                event.magnification = magnification;
                break;
            }
            case 16: {
                event.xDirection = xDirection;
                event.yDirection = yDirection;
                break;
            }
        }
        this.postEvent(48, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendHelpEvent(long helpType) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int type, int button, int time, double x, double y, boolean is_hint, int state) {
        return this.sendMouseEvent(type, button, 0, 0, false, time, x, y, is_hint, state);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, int time, double x, double y, boolean is_hint, int state) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        Event event = new Event();
        event.time = time;
        event.button = button;
        event.detail = detail;
        event.count = count;
        if (is_hint) {
            Rectangle eventRect = new Rectangle((int)x, (int)y, 0, 0);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
        } else {
            long window = this.eventWindow();
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            GDK.gdk_window_get_origin(window, origin_x, origin_y);
            Rectangle eventRect = new Rectangle((int)x - origin_x[0], (int)y - origin_y[0], 0, 0);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
        }
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        this.setInputState(event, state);
        event.data = send;
        if (!OS.isX11()) {
            if (type == 3) {
                this.dragDetectionQueue = new LinkedList();
                this.dragDetectionQueue.add(event);
                return true;
            }
            if (this.dragDetectionQueue != null) {
                switch (type) {
                    case 5: {
                        if (this.dragDetect(event.x, event.y, false, true, null)) {
                            Event mouseDownEvent = this.dragDetectionQueue.getFirst();
                            mouseDownEvent.data = true;
                            this.dragDetectionQueue = null;
                            this.sendOrPost(3, mouseDownEvent);
                            break;
                        }
                        this.dragDetectionQueue.add(event);
                        break;
                    }
                    case 4: {
                        boolean sendOrPostAll = send ? true : (Boolean)this.dragDetectionQueue.getFirst().data;
                        this.dragDetectionQueue.forEach(queuedEvent -> {
                            Object object = queuedEvent.data = Boolean.valueOf(sendOrPostAll);
                        });
                        this.sendOrPost(3, this.dragDetectionQueue.removeFirst());
                        this.dragDetectionQueue.forEach(queuedEvent -> {
                            boolean bl = this.sendOrPost(5, (Event)queuedEvent);
                        });
                        this.dragDetectionQueue = null;
                    }
                }
            }
        }
        return this.sendOrPost(type, event);
    }

    private boolean sendOrPost(int type, Event event) {
        assert (event.data != null) : "event.data should have been a Boolean, but received null";
        boolean send = (Boolean)event.data;
        event.data = null;
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    void gtk_widget_set_align(long widget, int hAlign, int vAlign) {
        GTK.gtk_widget_set_halign(widget, hAlign);
        GTK.gtk_widget_set_valign(widget, vAlign);
    }

    void gtk_label_set_align(long label, float xAlign, float yAlign) {
        GTK.gtk_label_set_xalign(label, xAlign);
        GTK.gtk_label_set_yalign(label, yAlign);
    }

    void setBackground() {
        if ((this.state & 0x2000) == 0 && this.backgroundImage == null) {
            if ((this.state & 0x8000) != 0) {
                this.setParentBackground();
            } else {
                this.setWidgetBackground();
            }
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this._setBackground(color);
        if (color != null) {
            this.updateBackgroundMode();
        }
    }

    private void _setBackground(Color color) {
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        boolean set = false;
        if (GTK.GTK3) {
            GdkRGBA rgba = null;
            if (color != null) {
                rgba = color.handleRGBA;
                this.backgroundAlpha = color.getAlpha();
            }
            if (set = true) {
                this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
                this.setBackgroundGdkRGBA(rgba);
            }
        } else {
            GdkColor gdkColor = null;
            if (color != null) {
                if (color.isDisposed()) {
                    this.error(5);
                }
                gdkColor = color.handle;
                this.backgroundAlpha = color.getAlpha();
            }
            if (gdkColor == null) {
                long style = GTK.gtk_widget_get_modifier_style(this.handle);
                set = (GTK.gtk_rc_style_get_color_flags(style, 0) & 2) != 0;
            } else {
                GdkColor oldColor = this.getBackgroundGdkColor();
                boolean bl = set = oldColor.pixel != gdkColor.pixel;
            }
            if (set) {
                this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
                this.setBackgroundGdkColor(gdkColor);
            }
        }
        this.redrawChildren();
    }

    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handleRGBA;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            String css;
            String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.display.gtk_widget_class_get_css_name(handle) : this.display.gtk_widget_get_name(handle);
            String selection = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? " selection" : ":selected";
            this.cssBackground = css = String.valueOf(name) + " {background-color: " + this.display.gtk_rgba_to_css_string(rgba) + ";}\n" + name + selection + " {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(context, finalCss);
        } else {
            GTK.gtk_widget_override_background_color(handle, 0, rgba);
            GTK.gtk_widget_override_background_color(handle, 4, selectedBackground);
        }
    }

    void setBackgroundGradientGdkRGBA(long context, long handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        String css = "* {\n";
        if (rgba != null) {
            String color = this.display.gtk_rgba_to_css_string(rgba);
            css = String.valueOf(css) + "background-image: -gtk-gradient (linear, 0 0, 0 1, color-stop(0, " + color + "), color-stop(1, " + color + "));\n";
        }
        this.cssBackground = css = String.valueOf(css) + "}\n";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    void gtk_css_provider_load_from_css(long context, String css) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        GTK.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L, null);
    }

    void setBackgroundGdkColor(long handle, GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        int index = 0;
        long style = GTK.gtk_widget_get_modifier_style(handle);
        long ptr = GTK.gtk_rc_style_get_bg_pixmap_name(style, index);
        if (ptr != 0L) {
            OS.g_free(ptr);
        }
        ptr = 0L;
        String pixmapName = null;
        int flags = GTK.gtk_rc_style_get_color_flags(style, index);
        if (color != null) {
            flags |= 2;
            pixmapName = "<none>";
        } else {
            flags &= 0xFFFFFFFD;
            if (this.backgroundImage == null && (this.state & 0x8000) != 0) {
                pixmapName = "<parent>";
            }
        }
        if (pixmapName != null) {
            byte[] buffer = Converter.wcsToMbcs(pixmapName, true);
            ptr = OS.g_malloc(buffer.length);
            C.memmove(ptr, buffer, (long)buffer.length);
        }
        GTK.gtk_rc_style_set_bg_pixmap_name(style, index, ptr);
        GTK.gtk_rc_style_set_bg(style, index, color);
        GTK.gtk_rc_style_set_color_flags(style, index, flags);
        this.modifyStyle(handle, style);
    }

    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        this.setBackgroundGdkColor(this.handle, color);
    }

    void setBackgroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.setBackgroundGdkRGBA(this.handle, rgba);
    }

    void setBackgroundGdkRGBA(long handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        double alpha = 1.0;
        if (rgba == null) {
            if ((this.state & 0x8000) != 0) {
                alpha = 0.0;
                Control control = this.findBackgroundControl();
                if (control == null) {
                    control = this;
                }
                rgba = control.getBackgroundGdkRGBA();
            }
        } else {
            alpha = this.backgroundAlpha;
        }
        if (rgba != null) {
            rgba.alpha = alpha / 255.0;
        }
        long context = GTK.gtk_widget_get_style_context(handle);
        this.setBackgroundGdkRGBA(context, handle, rgba);
        GTK.gtk_style_context_invalidate(context);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage && this.backgroundAlpha > 0) {
            return;
        }
        this.backgroundAlpha = 255;
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundPixmap(Image image) {
        long window = this.gtk_widget_get_window(this.paintHandle());
        if (window != 0L) {
            if (image.pixmap != 0L) {
                GDK.gdk_window_set_back_pixmap(window, image.pixmap, false);
            } else if (image.surface != 0L && GTK.GTK3) {
                long pattern = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (pattern == 0L) {
                    SWT.error(2);
                }
                Cairo.cairo_pattern_set_extend(pattern, 1);
                GDK.gdk_window_set_background_pattern(window, pattern);
                Cairo.cairo_pattern_destroy(pattern);
            }
        }
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0L);
    }

    void setCursor(long cursor) {
        long window = this.eventWindow();
        if (window != 0L) {
            GDK.gdk_window_set_cursor(window, cursor);
            if (!OS.isX11()) {
                GDK.gdk_flush();
            } else {
                long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
                OS.XFlush(xDisplay);
            }
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    static long enterNotifyEventProc(long ihint, long n_param_values, long param_values, long data) {
        long firstItem;
        long gdkWindow;
        long instance = OS.g_value_peek_pointer(param_values);
        long hashTable = OS.g_object_get_qdata(instance, GTK_POINTER_WINDOW);
        if (hashTable != 0L && (gdkWindow = OS.g_list_data(firstItem = OS.g_hash_table_get_values(hashTable))) == data) {
            OS.g_object_set_qdata(gdkWindow, SWT_GRAB_WIDGET, instance);
        }
        return 1L;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (enabled) {
            if (this.enableWindow != 0L) {
                this.cleanupEnableWindow();
            }
        } else {
            GTK.gtk_widget_realize(this.handle);
            long parentHandle = this.parent.eventHandle();
            long window = this.parent.eventWindow();
            long topHandle = this.topHandle();
            GdkWindowAttr attributes = new GdkWindowAttr();
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(topHandle, allocation);
            attributes.x = allocation.x;
            attributes.y = allocation.y;
            attributes.width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            attributes.height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = GDK.gdk_window_new(window, attributes, 12);
            if (this.enableWindow != 0L) {
                if (enterNotifyEventFunc != null) {
                    this.enterNotifyEventId = OS.g_signal_add_emission_hook(enterNotifyEventSignalId, 0, enterNotifyEventFunc.getAddress(), this.enableWindow, 0L);
                }
                GDK.gdk_window_set_user_data(this.enableWindow, parentHandle);
                this.restackWindow(this.enableWindow, this.gtk_widget_get_window(topHandle), true);
                if (GTK.gtk_widget_get_visible(topHandle)) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void cleanupEnableWindow() {
        if (enterNotifyEventFunc != null) {
            if (this.enterNotifyEventId > 0L) {
                OS.g_signal_remove_emission_hook(enterNotifyEventSignalId, this.enterNotifyEventId);
            }
            this.enterNotifyEventId = 0L;
            long grabWidget = OS.g_object_get_qdata(this.enableWindow, SWT_GRAB_WIDGET);
            if (grabWidget != 0L) {
                OS.g_object_set_qdata(grabWidget, GTK_POINTER_WINDOW, 0L);
                OS.g_object_set_qdata(this.enableWindow, SWT_GRAB_WIDGET, 0L);
            }
        }
        GDK.gdk_window_set_user_data(this.enableWindow, 0L);
        GDK.gdk_window_destroy(this.enableWindow);
        this.enableWindow = 0L;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        long fontDesc;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            fontDesc = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                this.error(5);
            }
            fontDesc = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(fontDesc);
    }

    void setFontDescription(long font) {
        this.setFontDescription(this.handle, font);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            gdkColor = color.handle;
        }
        boolean set = false;
        if (GTK.GTK3) {
            set = !this.getForeground().equals(color);
        } else if (gdkColor == null) {
            long style = GTK.gtk_widget_get_modifier_style(this.handle);
            set = (GTK.gtk_rc_style_get_color_flags(style, 0) & 1) != 0;
        } else {
            GdkColor oldColor = this.getForegroundGdkColor();
            boolean bl = set = oldColor.pixel != gdkColor.pixel;
        }
        if (set) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            if (GTK.GTK3) {
                GdkRGBA rgba = color == null ? null : color.handleRGBA;
                this.setForegroundGdkRGBA(rgba);
            } else {
                this.setForegroundGdkColor(gdkColor);
            }
        }
    }

    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.setForegroundGdkRGBA(this.handle, rgba);
    }

    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        this.setForegroundColor(this.handle, color);
    }

    void setForegroundGdkRGBA(long handle, GdkRGBA rgba) {
        String css;
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0)) {
            GdkRGBA selectedForeground = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
            GTK.gtk_widget_override_color(handle, 0, rgba);
            GTK.gtk_widget_override_color(handle, 4, selectedForeground);
            long context = GTK.gtk_widget_get_style_context(handle);
            GTK.gtk_style_context_invalidate(context);
            return;
        }
        GdkRGBA toSet = rgba != null ? rgba : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long context = GTK.gtk_widget_get_style_context(handle);
        String color = this.display.gtk_rgba_to_css_string(toSet);
        String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.display.gtk_widget_class_get_css_name(handle) : this.display.gtk_widget_get_name(handle);
        GdkRGBA selectedForeground = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
        String selection = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) && !name.contains("treeview") ? " selection" : ":selected";
        this.cssForeground = css = "* {color: " + color + ";}\n" + name + selection + " {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            long topHandle = this.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            allocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
            allocation.y = 0;
            if (GTK.GTK3) {
                GTK.gtk_widget_set_visible(topHandle, true);
            }
            GTK.gtk_widget_set_allocation(topHandle, allocation);
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    private void setDragGesture() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.dragGesture = GTK.gtk_gesture_drag_new(this.handle);
            GTK.gtk_event_controller_set_propagation_phase(this.dragGesture, 2);
            GTK.gtk_gesture_single_set_button(this.dragGesture, 0);
            OS.g_signal_connect(this.dragGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.dragGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    private void setRotateGesture() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.rotateGesture = GTK.gtk_gesture_rotate_new(this.handle);
            GTK.gtk_event_controller_set_propagation_phase(this.rotateGesture, 2);
            OS.g_signal_connect(this.rotateGesture, OS.angle_changed, gestureRotation.getAddress(), this.handle);
            OS.g_signal_connect(this.rotateGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.rotateGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    private void setZoomGesture() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.zoomGesture = GTK.gtk_gesture_zoom_new(this.handle);
            GTK.gtk_event_controller_set_propagation_phase(this.zoomGesture, 2);
            OS.g_signal_connect(this.zoomGesture, OS.scale_changed, gestureZoom.getAddress(), this.handle);
            OS.g_signal_connect(this.zoomGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.zoomGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    static Control getControl(long handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (Control)widget;
    }

    static void rotateProc(long gesture, double angle, double angle_delta, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            double delta = -(GTK.gtk_gesture_rotate_get_angle_delta(gesture) * 100.0);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 8, (int)x[0], (int)y[0], delta);
        }
    }

    static void magnifyProc(long gesture, double zoom, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            double delta = GTK.gtk_gesture_zoom_get_scale_delta(gesture);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 32, (int)x[0], (int)y[0], delta);
        }
    }

    static void swipeProc(long gesture, double velocity_x, double velocity_y, long user_data) {
        double[] yVelocity;
        double[] xVelocity;
        if (GTK.gtk_gesture_is_recognized(gesture) && GTK.gtk_gesture_swipe_get_velocity(gesture, xVelocity = new double[1], yVelocity = new double[1])) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 16, (int)x[0], (int)y[0], xVelocity[0], yVelocity[0]);
        }
    }

    static void gestureBeginProc(long gesture, long sequence, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, sequence, x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 2, (int)x[0], (int)y[0], 0.0);
        }
    }

    static void gestureEndProc(long gesture, long sequence, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 4, (int)x[0], (int)y[0], 0.0);
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, dir);
            }
            if (this.fixedHandle != 0L) {
                GTK.gtk_widget_set_direction(this.fixedHandle, dir);
            }
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.setOrientation(false);
        this.style &= 0xF7FFFFFF;
        this.checkMirrored();
    }

    public boolean setParent(Composite parent) {
        int height;
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        GTK.gtk_widget_realize(parent.handle);
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((parent.style & 0x8000000) != 0) {
            x = parent.getClientWidth() - width - x;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        Menu[] menus = oldShell.findMenus(this);
        if (oldShell != newShell || oldDecorations != newDecorations) {
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            newDecorations.fixAccelGroup();
            oldDecorations.fixAccelGroup();
        }
        long newParent = parent.parentingHandle();
        Control.gtk_widget_reparent(this, newParent);
        if (GTK.GTK3) {
            OS.swt_fixed_move(newParent, topHandle, x, y);
        } else {
            GTK.gtk_fixed_move(newParent, topHandle, x, y);
        }
        this.resizeHandle(width, height);
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(topHandle, requisition);
        allocation.x = x;
        allocation.y = y;
        allocation.width = width;
        allocation.height = height;
        GTK.gtk_widget_size_allocate(topHandle, allocation);
        this.parent = parent;
        this.setZOrder(null, false, true);
        this.reskin(1);
        return true;
    }

    void setParentBackground() {
        if (GTK.GTK3) {
            this.setBackgroundGdkRGBA(this.handle, null);
            if (this.fixedHandle != 0L) {
                this.setBackgroundGdkRGBA(this.fixedHandle, null);
            }
        } else {
            this.setBackgroundGdkColor(this.handle, null);
            if (this.fixedHandle != 0L) {
                this.setBackgroundGdkColor(this.fixedHandle, null);
            }
        }
    }

    void setParentGdkWindow(Control child) {
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0 && this.redrawWindow != 0L) {
                long window = this.paintWindow();
                GDK.gdk_window_hide(this.redrawWindow);
                GDK.gdk_window_destroy(this.redrawWindow);
                GDK.gdk_window_set_events(window, GTK.gtk_widget_get_events(this.paintHandle()));
                this.redrawWindow = 0L;
            }
        } else if (this.drawCount++ == 0 && GTK.gtk_widget_get_realized(this.handle)) {
            long window = this.paintWindow();
            Rectangle rect = this.getBoundsInPixels();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = 2;
            attributes.window_type = 2;
            this.redrawWindow = GDK.gdk_window_new(window, attributes, 0);
            if (this.redrawWindow != 0L) {
                int mouseMask = 13308;
                GDK.gdk_window_set_events(window, GDK.gdk_window_get_events(window) & ~mouseMask);
                if (GTK.GTK3) {
                    GDK.gdk_window_set_background_pattern(this.redrawWindow, 0L);
                } else {
                    GDK.gdk_window_set_back_pixmap(this.redrawWindow, 0L, false);
                }
                GDK.gdk_window_show(this.redrawWindow);
            }
        }
    }

    @Override
    boolean setTabItemFocus(boolean next) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int textDirection) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.setToolTipText(this._getShell(), string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        if (this.display.currentControl == this) {
            shell.setToolTipText(shell.handle, this.eventHandle(), newString);
        }
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == visible) {
            return;
        }
        long topHandle = this.topHandle();
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                if (this.reparentOnVisibility && GTK.GTK3) {
                    GDK.gdk_window_raise(this.gtk_widget_get_window(topHandle));
                }
                GTK.gtk_widget_show(topHandle);
            }
        } else {
            Control control = null;
            boolean fixFocus = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (fixFocus) {
                if (GTK.GTK3) {
                    GTK.gtk_widget_set_can_focus(topHandle, false);
                } else {
                    this.gtk_widget_set_visible(topHandle, false);
                }
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                if (GTK.GTK3) {
                    GTK.gtk_widget_set_can_focus(topHandle, true);
                } else {
                    this.gtk_widget_set_visible(topHandle, true);
                }
            }
            GTK.gtk_widget_hide(topHandle);
            if (this.isDisposed()) {
                return;
            }
            if (this.enableWindow != 0L) {
                GDK.gdk_window_hide(this.enableWindow);
            }
            if (this.reparentOnVisibility && GTK.GTK3) {
                GDK.gdk_window_lower(this.gtk_widget_get_window(topHandle));
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        this.setZOrder(sibling, above, fixRelations, true);
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations, boolean fixChildren) {
        int index = 0;
        int siblingIndex = 0;
        int oldNextIndex = -1;
        Control[] children = null;
        if (fixRelations) {
            children = this.parent._getChildren();
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (sibling != null) {
                while (siblingIndex < children.length) {
                    if (children[siblingIndex] == sibling) break;
                    ++siblingIndex;
                }
            }
            this.removeRelation();
            if (index + 1 < children.length) {
                oldNextIndex = index + 1;
                children[oldNextIndex].removeRelation();
            }
            if (sibling != null) {
                if (above) {
                    sibling.removeRelation();
                } else if (siblingIndex + 1 < children.length) {
                    children[siblingIndex + 1].removeRelation();
                }
            }
        }
        long topHandle = this.topHandle();
        long siblingHandle = sibling != null ? sibling.topHandle() : 0L;
        long window = this.gtk_widget_get_window(topHandle);
        if (window != 0L) {
            long redrawWindow;
            long siblingWindow = 0L;
            if (sibling != null) {
                siblingWindow = above && sibling.enableWindow != 0L ? this.enableWindow : GTK.gtk_widget_get_window(siblingHandle);
            }
            long l = redrawWindow = fixChildren ? this.parent.redrawWindow : 0L;
            if (!OS.GDK_WINDOWING_X11() || siblingWindow == 0L && (!above || redrawWindow == 0L)) {
                if (above) {
                    GDK.gdk_window_raise(window);
                    if (redrawWindow != 0L) {
                        GDK.gdk_window_raise(redrawWindow);
                    }
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_raise(this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_lower(this.enableWindow);
                    }
                    GDK.gdk_window_lower(window);
                }
            } else {
                long siblingW = siblingWindow != 0L ? siblingWindow : redrawWindow;
                boolean stack_mode = above;
                if (redrawWindow != 0L && siblingWindow == 0L) {
                    stack_mode = false;
                }
                this.restackWindow(window, siblingW, stack_mode);
                if (this.enableWindow != 0L) {
                    this.restackWindow(this.enableWindow, window, true);
                }
            }
        }
        if (fixChildren) {
            if (above) {
                this.parent.moveAbove(topHandle, siblingHandle);
            } else {
                this.parent.moveBelow(topHandle, siblingHandle);
            }
        }
        if (!above && fixChildren) {
            this.parent.fixZOrder();
        }
        if (fixRelations) {
            index = sibling != null ? (above ? siblingIndex - (index < siblingIndex ? 1 : 0) : siblingIndex + (siblingIndex < index ? 1 : 0)) : (above ? 0 : children.length - 1);
            children = this.parent._getChildren();
            if (index > 0) {
                children[index - 1].addRelation(this);
            }
            if (index + 1 < children.length) {
                this.addRelation(children[index + 1]);
            }
            if (oldNextIndex != -1) {
                if (oldNextIndex <= index) {
                    --oldNextIndex;
                }
                if (oldNextIndex > 0 && oldNextIndex != index && oldNextIndex != index + 1) {
                    children[oldNextIndex - 1].addRelation(children[oldNextIndex]);
                }
            }
        }
    }

    void setWidgetBackground() {
        if (GTK.GTK3) {
            GdkRGBA rgba;
            GdkRGBA gdkRGBA = rgba = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
            if (this.fixedHandle != 0L) {
                this.setBackgroundGdkRGBA(this.fixedHandle, rgba);
            }
            this.setBackgroundGdkRGBA(this.handle, rgba);
        } else {
            GdkColor color;
            GdkColor gdkColor = color = (this.state & 0x2000) != 0 ? this.getBackgroundGdkColor() : null;
            if (this.fixedHandle != 0L) {
                this.setBackgroundGdkColor(this.fixedHandle, color);
            }
            this.setBackgroundGdkColor(this.handle, color);
        }
    }

    boolean showMenu(int x, int y) {
        return this.showMenu(x, y, 0);
    }

    boolean showMenu(int x, int y, int detail) {
        Event event = new Event();
        Rectangle eventRect = new Rectangle(x, y, 0, 0);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        event.detail = detail;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            boolean hooksKeys = this.hooks(1) || this.hooks(2);
            this.menu.createIMMenu(hooksKeys ? this.imHandle() : 0L);
            Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
            if (rect.x != x || rect.y != y) {
                this.menu.setLocationInPixels(rect.x, rect.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        long topHandle = this.topHandle();
        long parentHandle = this.parent.parentingHandle();
        this.parent.setParentGdkWindow(this);
        GTK.gtk_container_add(parentHandle, topHandle);
        if (this.handle != 0L && this.handle != topHandle) {
            GTK.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0L) {
            GTK.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    if (character == '\u0000' || (stateMask & 0x50000) != 65536) break;
                    traversal = 128;
                    doit = true;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int keyval, GdkEventKey gdkEvent) {
        Decorations shell;
        long key = GDK.gdk_keyval_to_unicode(keyval);
        if (key < 32L) {
            return false;
        }
        if (gdkEvent.state == 0) {
            int code = this.traversalCode(keyval, gdkEvent);
            if ((code & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell2 = this._getShell();
            int mask = 13;
            if ((gdkEvent.state & mask) != GTK.gtk_window_get_mnemonic_modifier(shell2.shellHandle)) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, gdkEvent)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int detail = 0;
        int key = keyEvent.keyval;
        int code = this.traversalCode(key, keyEvent);
        boolean all = false;
        switch (key) {
            case 65307: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean next = (keyEvent.state & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next;
                boolean bl = next = key == 65364 || key == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (key == 65361 || key == 65363)) {
                    next = !next;
                }
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((keyEvent.state & 4) == 0) {
                    return false;
                }
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = keyEvent.time;
        if (!this.setKeyState(event, keyEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Widget group = this.computeTabGroup();
        Widget[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Widget widget = list[index];
            if (widget.isDisposed() || !widget.setTabGroupFocus(next)) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus(next);
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean all, boolean flush) {
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long window = this.paintWindow();
        if (flush) {
            this.display.flushExposes(window, all);
        }
        if (GTK.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            GDK.gdk_window_process_updates(window, all);
        }
        GDK.gdk_flush();
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x8000;
        this.checkBackground();
        if (oldState != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean all) {
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                boolean draw;
                if ((this.state & 0x40) != 0) break;
                Control control = this.findBackgroundControl();
                boolean bl = draw = control != null && control.backgroundImage != null;
                if (GTK.GTK3 && !draw && (this.state & 2) != 0) {
                    if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0)) {
                        GdkRGBA rgba = new GdkRGBA();
                        long context = GTK.gtk_widget_get_style_context(handle);
                        GTK.gtk_style_context_get_background_color(context, 0, rgba);
                        draw = rgba.alpha == 0.0;
                    } else {
                        boolean bl2 = draw = (this.state & 0x2000) == 0;
                    }
                }
                if (!draw) break;
                if (GTK.GTK3) {
                    long window;
                    long cairo = arg0;
                    GdkRectangle rect = new GdkRectangle();
                    GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
                    if (control == null) {
                        control = this;
                    }
                    if ((window = GTK.gtk_widget_get_window(handle)) != 0L) {
                        this.drawBackground(control, window, 0L, 0L, rect.x, rect.y, rect.width, rect.height);
                        break;
                    }
                    this.drawBackground(control, 0L, cairo, 0L, rect.x, rect.y, rect.width, rect.height);
                    break;
                }
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, (long)GdkEventExpose.sizeof);
                long paintWindow = this.paintWindow();
                long window = gdkEvent.window;
                if (window != paintWindow) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    Point getWindowOrigin() {
        int[] x = new int[1];
        int[] y = new int[1];
        long window = this.eventWindow();
        GDK.gdk_window_get_origin(window, x, y);
        return new Point(x[0], y[0]);
    }
}

