/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IPropertyBag;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebFramePrivate;
import org.eclipse.swt.internal.webkit.IWebOpenPanelResultListener;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebUIDelegate {
    COMObject iWebUIDelegate;
    int refCount = 0;
    String lastHoveredLinkURL;
    Browser browser;
    Point size;
    Point location;
    boolean menuBar = true;
    boolean toolBar = true;
    boolean statusBar = true;
    boolean prompt = true;

    WebUIDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int canTakeFocus(long sender, int forward, long result) {
        OS.MoveMemory(result, new int[]{1}, 4);
        return 0;
    }

    int contextMenuItemsForElement(long sender, long element, long defaultItemsHMenu, long resultHMenu) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (event.doit) {
            Menu menu = this.browser.getMenu();
            if (menu != null && !menu.isDisposed()) {
                if (event.x != pt.x || event.y != pt.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            } else {
                OS.MoveMemory(resultHMenu, new long[]{defaultItemsHMenu}, C.PTR_SIZEOF);
                return 0;
            }
        }
        OS.MoveMemory(resultHMenu, new long[1], C.PTR_SIZEOF);
        return 0;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[66];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 3;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 2;
        nArray[27] = 3;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 3;
        nArray[31] = 3;
        nArray[32] = 3;
        nArray[33] = 3;
        nArray[34] = 5;
        nArray[35] = 3;
        nArray[36] = 1;
        nArray[37] = 3;
        nArray[38] = 2;
        nArray[39] = 2;
        nArray[40] = 2;
        nArray[41] = 2;
        nArray[42] = 3;
        nArray[43] = 2;
        nArray[44] = 3;
        nArray[45] = 1;
        nArray[46] = 1;
        nArray[49] = 1;
        nArray[50] = 1;
        nArray[51] = 2;
        nArray[52] = 2;
        nArray[53] = 2;
        nArray[54] = 2;
        nArray[55] = 3;
        nArray[56] = 5;
        nArray[57] = 2;
        nArray[58] = 2;
        nArray[59] = 3;
        nArray[60] = 1;
        nArray[61] = 2;
        nArray[62] = 2;
        nArray[63] = 4;
        nArray[64] = 10;
        nArray[65] = 3;
        this.iWebUIDelegate = new COMObject(nArray){

            @Override
            public long method0(long[] args) {
                return WebUIDelegate.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return WebUIDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return WebUIDelegate.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return WebUIDelegate.this.createWebViewWithRequest(args[0], args[1], args[2]);
            }

            @Override
            public long method4(long[] args) {
                return WebUIDelegate.this.webViewShow(args[0]);
            }

            @Override
            public long method5(long[] args) {
                return WebUIDelegate.this.webViewClose(args[0]);
            }

            @Override
            public long method6(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method7(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method8(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method9(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method10(long[] args) {
                return WebUIDelegate.this.setStatusText(args[0], args[1]);
            }

            @Override
            public long method11(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method12(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method13(long[] args) {
                return WebUIDelegate.this.setToolbarsVisible(args[0], (int)args[1]);
            }

            @Override
            public long method14(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method15(long[] args) {
                return WebUIDelegate.this.setStatusBarVisible(args[0], (int)args[1]);
            }

            @Override
            public long method16(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method17(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method18(long[] args) {
                return WebUIDelegate.this.setFrame(args[0], args[1]);
            }

            @Override
            public long method19(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method20(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method21(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method22(long[] args) {
                return WebUIDelegate.this.runJavaScriptAlertPanelWithMessage(args[0], args[1]);
            }

            @Override
            public long method23(long[] args) {
                return WebUIDelegate.this.runJavaScriptConfirmPanelWithMessage(args[0], args[1], args[2]);
            }

            @Override
            public long method24(long[] args) {
                return WebUIDelegate.this.runJavaScriptTextInputPanelWithPrompt(args[0], args[1], args[2], args[3]);
            }

            @Override
            public long method25(long[] args) {
                return WebUIDelegate.this.runBeforeUnloadConfirmPanelWithMessage(args[0], args[1], args[2], args[3]);
            }

            @Override
            public long method26(long[] args) {
                return WebUIDelegate.this.runOpenPanelForFileButtonWithResultListener(args[0], args[1]);
            }

            @Override
            public long method27(long[] args) {
                return WebUIDelegate.this.mouseDidMoveOverElement(args[0], args[1], (int)args[2]);
            }

            @Override
            public long method28(long[] args) {
                return WebUIDelegate.this.contextMenuItemsForElement(args[0], args[1], args[2], args[3]);
            }

            @Override
            public long method29(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method30(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method31(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method32(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method33(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method34(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method35(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method36(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method37(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method38(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method39(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method40(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method41(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method42(long[] args) {
                return WebUIDelegate.this.canTakeFocus(args[0], (int)args[1], args[2]);
            }

            @Override
            public long method43(long[] args) {
                return WebUIDelegate.this.takeFocus(args[0], (int)args[1]);
            }

            @Override
            public long method44(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method45(long[] args) {
                return 0L;
            }

            @Override
            public long method46(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method47(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method48(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method49(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method50(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method51(long[] args) {
                return WebUIDelegate.this.printFrame(args[0], args[1]);
            }

            @Override
            public long method52(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method53(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method54(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method55(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method56(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method57(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method58(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method59(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method60(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method61(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method62(long[] args) {
                return WebUIDelegate.this.setMenuBarVisible(args[0], (int)args[1]);
            }

            @Override
            public long method63(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method64(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method65(long[] args) {
                return -2147467263L;
            }
        };
    }

    int createWebViewWithRequest(long sender, long request, long webView) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        OpenWindowListener[] openWindowListeners = this.browser.webBrowser.openWindowListeners;
        int i = 0;
        while (i < openWindowListeners.length) {
            openWindowListeners[i].open(newEvent);
            ++i;
        }
        IWebView iwebview = null;
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            iwebview = ((WebKit)((Browser)browser).webBrowser).webView;
            OS.MoveMemory(webView, new long[]{iwebview.getAddress()}, C.PTR_SIZEOF);
            if (request != 0L) {
                IWebURLRequest req = new IWebURLRequest(request);
                long[] result = new long[1];
                int hr = req.URL(result);
                if (hr != 0 || result[0] == 0L) {
                    return 0;
                }
                String sUrl = WebKit.extractBSTR(result[0]);
                COM.SysFreeString(result[0]);
                if (sUrl.length() != 0) {
                    result[0] = 0L;
                    hr = iwebview.mainFrame(result);
                    if (hr != 0 || result[0] == 0L) {
                        return 0;
                    }
                    IWebFrame mainFrame = new IWebFrame(result[0]);
                    mainFrame.loadRequest(req.getAddress());
                    mainFrame.Release();
                }
            }
            return 0;
        }
        return -2147467263;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebUIDelegate != null) {
            this.iWebUIDelegate.dispose();
            this.iWebUIDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebUIDelegate.getAddress();
    }

    int mouseDidMoveOverElement(long sender, long elementInformation, int modifierFlags) {
        long hHeap;
        long resultPtr;
        if (elementInformation == 0L) {
            return 0;
        }
        IPropertyBag info = new IPropertyBag(elementInformation);
        long key = WebKit.createBSTR("WebElementLinkURLKey");
        int hr = info.Read(key, resultPtr = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, VARIANT.sizeof), null);
        if (hr != 0 || resultPtr == 0L) {
            return 0;
        }
        String value = null;
        VARIANT v = new VARIANT();
        COM.MoveMemory(v, resultPtr, VARIANT.sizeof);
        if (v.vt == 8) {
            value = WebKit.extractBSTR(v.lVal);
        }
        OS.HeapFree(hHeap, 0, resultPtr);
        StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
        if (value == null || value.length() == 0) {
            if (this.lastHoveredLinkURL == null) {
                return 0;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = this.browser.getDisplay();
            statusText.widget = this.browser;
            statusText.text = "";
            int i = 0;
            while (i < statusTextListeners.length) {
                statusTextListeners[i].changed(statusText);
                ++i;
            }
            return 0;
        }
        if (value.equals(this.lastHoveredLinkURL)) {
            return 0;
        }
        this.lastHoveredLinkURL = value;
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = value;
        int i = 0;
        while (i < statusTextListeners.length) {
            statusTextListeners[i].changed(statusText);
            ++i;
        }
        return 0;
    }

    int printFrame(long webView, long frame) {
        IWebFrame iwebFrame = new IWebFrame(frame);
        PRINTDLG pd = new PRINTDLG();
        pd.lStructSize = PRINTDLG.sizeof;
        pd.Flags = 256;
        Display display = this.browser.getDisplay();
        display.sendPreExternalEventDispatchEvent();
        boolean success = OS.PrintDlg(pd);
        display.sendPostExternalEventDispatchEvent();
        if (!success) {
            return 0;
        }
        long printDC = pd.hDC;
        long[] result = new long[1];
        int hr = iwebFrame.QueryInterface(WebKit_win32.IID_IWebFramePrivate, result);
        if (hr != 0 || result[0] == 0L) {
            return 0;
        }
        IWebFramePrivate privateFrame = new IWebFramePrivate(result[0]);
        privateFrame.setInPrintingMode(1, printDC);
        int[] count = new int[1];
        hr = privateFrame.getPrintedPageCount(printDC, count);
        if (hr != 0 || count[0] == 0) {
            privateFrame.Release();
            return 0;
        }
        int pageCount = count[0];
        String jobName = null;
        result[0] = 0L;
        hr = iwebFrame.dataSource(result);
        if (hr == 0 && result[0] != 0L) {
            IWebDataSource dataSource = new IWebDataSource(result[0]);
            result[0] = 0L;
            hr = dataSource.pageTitle(result);
            dataSource.Release();
            if (hr == 0 && result[0] != 0L) {
                jobName = WebKit.extractBSTR(result[0]);
                COM.SysFreeString(result[0]);
            }
        }
        DOCINFO di = new DOCINFO();
        di.cbSize = DOCINFO.sizeof;
        long hHeap = OS.GetProcessHeap();
        long lpszDocName = 0L;
        if (jobName != null && jobName.length() != 0) {
            TCHAR buffer = new TCHAR(0, jobName, true);
            int byteCount = buffer.length() * TCHAR.sizeof;
            lpszDocName = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszDocName, buffer, byteCount);
            di.lpszDocName = lpszDocName;
        }
        int rc = OS.StartDoc(printDC, di);
        if (lpszDocName != 0L) {
            OS.HeapFree(hHeap, 0, lpszDocName);
        }
        if (rc >= 0) {
            int i = 0;
            while (i < pageCount) {
                OS.StartPage(printDC);
                privateFrame.spoolPages(printDC, i, i, null);
                OS.EndPage(printDC);
                ++i;
            }
            privateFrame.setInPrintingMode(0, printDC);
            OS.EndDoc(printDC);
        }
        privateFrame.Release();
        return 0;
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebUIDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebUIDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebUIDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int runBeforeUnloadConfirmPanelWithMessage(long sender, long message, long initiatedByFrame, long result) {
        if (!this.prompt) {
            return 0;
        }
        Shell parent = this.browser.getShell();
        String string = WebKit.extractBSTR(message);
        StringBuffer text = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        text.append("\n\n");
        text.append(string);
        text.append("\n\n");
        text.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox box = new MessageBox(parent, 292);
        box.setMessage(text.toString());
        int[] response = new int[]{box.open() == 32 ? 1 : 0};
        OS.MoveMemory(result, response, 4);
        return 0;
    }

    int runJavaScriptAlertPanelWithMessage(long sender, long message) {
        String messageString = WebKit.extractBSTR(message);
        this.showAlertMessage("Javascript", messageString);
        return 0;
    }

    int runJavaScriptConfirmPanelWithMessage(long sender, long message, long result) {
        String messageString = WebKit.extractBSTR(message);
        int[] response = new int[]{this.showConfirmPanel("Javascript", messageString) == 32 ? 1 : 0};
        OS.MoveMemory(result, response, 4);
        return 0;
    }

    int runJavaScriptTextInputPanelWithPrompt(long sender, long message, long defaultText, long result) {
        String messageString = WebKit.extractBSTR(message);
        String defaultTextString = WebKit.extractBSTR(defaultText);
        String resultString = this.showTextPrompter("Javascript", messageString, defaultTextString);
        long[] response = new long[1];
        if (resultString != null) {
            response[0] = WebKit.createBSTR(resultString);
        }
        OS.MoveMemory(result, response, C.PTR_SIZEOF);
        return 0;
    }

    int runOpenPanelForFileButtonWithResultListener(long sender, long resultListener) {
        Shell parent = this.browser.getShell();
        FileDialog dialog = new FileDialog(parent, 0);
        String result = dialog.open();
        IWebOpenPanelResultListener listener = new IWebOpenPanelResultListener(resultListener);
        if (result == null) {
            listener.cancel();
        } else {
            listener.chooseFilename(WebKit.createBSTR(result));
        }
        return 0;
    }

    int setFrame(long sender, long frame) {
        RECT rect = new RECT();
        COM.MoveMemory(rect, frame, RECT.sizeof);
        this.location = DPIUtil.autoScaleUp(this.browser.getDisplay().map((Control)this.browser, null, DPIUtil.autoScaleDown(new Point(rect.left, rect.top))));
        int x = rect.right - rect.left;
        int y = rect.bottom - rect.top;
        if (y < 0 || x < 0 || x == 0 && y == 0) {
            return 0;
        }
        this.size = new Point(x, y);
        return 0;
    }

    int setMenuBarVisible(long sender, int visible) {
        this.menuBar = visible == 1;
        return 0;
    }

    int setStatusBarVisible(long sender, int visible) {
        this.statusBar = visible == 1;
        return 0;
    }

    int setStatusText(long sender, long text) {
        String statusText = WebKit.extractBSTR(text);
        if (statusText.length() == 0) {
            return 0;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = statusText;
        StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
        int i = 0;
        while (i < statusTextListeners.length) {
            statusTextListeners[i].changed(statusTextEvent);
            ++i;
        }
        return 0;
    }

    int setToolbarsVisible(long sender, int visible) {
        this.toolBar = visible == 1;
        return 0;
    }

    void showAlertMessage(String title, String message) {
        Shell parent = this.browser.getShell();
        final Shell dialog = new Shell(parent, 67680);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialog.setLayout(layout);
        dialog.setText(title);
        Label label = new Label(dialog, 0);
        Image image = dialog.getDisplay().getSystemImage(8);
        label.setImage(image);
        label = new Label(dialog, 64);
        label.setText(message);
        Monitor monitor = parent.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label.computeSize((int)-1, (int)-1).x;
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = Math.min(width, maxWidth);
        label.setLayoutData(data);
        Button ok = new Button(dialog, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        width = ok.computeSize((int)-1, (int)-1).x;
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000000;
        layoutData.verticalAlignment = 0x1000000;
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = Math.max(width, 75);
        ok.setLayoutData(layoutData);
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(ok);
        dialog.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog.getBounds();
        int x = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog.setLocation(x, y);
        dialog.open();
        Display display = this.browser.getDisplay();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    int showConfirmPanel(String title, String message) {
        Shell parent = this.browser.getShell();
        final Shell dialog = new Shell(parent, 67680);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialog.setLayout(layout);
        dialog.setText(title);
        Label label = new Label(dialog, 0);
        Image image = dialog.getDisplay().getSystemImage(4);
        label.setImage(image);
        label.setLayoutData(new GridData());
        label = new Label(dialog, 64);
        label.setText(message);
        Monitor monitor = parent.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label.computeSize((int)-1, (int)-1).x;
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = Math.min(width, maxWidth);
        label.setLayoutData(data);
        Composite buttons = new Composite(dialog, 0);
        data = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
        buttons.setLayoutData(data);
        buttons.setLayout(new GridLayout(2, true));
        Button ok = new Button(buttons, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000000;
        layoutData.verticalAlignment = 0x1000000;
        ok.setLayoutData(layoutData);
        Button cancel = new Button(buttons, 8);
        cancel.setText(SWT.getMessage("SWT_Cancel"));
        cancel.setLayoutData(layoutData);
        width = cancel.computeSize((int)-1, (int)-1).x;
        layoutData.widthHint = Math.max(width, 75);
        final int[] result = new int[1];
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                result[0] = 32;
                dialog.dispose();
            }
        });
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                result[0] = 256;
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(ok);
        dialog.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog.getBounds();
        int x = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog.setLocation(x, y);
        dialog.open();
        Display display = this.browser.getDisplay();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    String showTextPrompter(String title, String message, String defaultText) {
        Shell parent = this.browser.getShell();
        final Shell dialog = new Shell(parent, 67680);
        dialog.setLayout(new GridLayout());
        dialog.setText(title);
        Label label = new Label(dialog, 0);
        label.setLayoutData(new GridData(768));
        label.setText(message);
        final Text textBox = new Text(dialog, 2052);
        GridData data = new GridData(768);
        data.widthHint = 300;
        textBox.setLayoutData(data);
        textBox.setText(defaultText);
        Composite buttons = new Composite(dialog, 0);
        buttons.setLayout(new GridLayout(2, true));
        buttons.setLayoutData(new GridData(64));
        Button ok = new Button(buttons, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        ok.setLayoutData(new GridData(768));
        final String[] result = new String[1];
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                result[0] = textBox.getText();
                dialog.dispose();
            }
        });
        Button cancel = new Button(buttons, 8);
        cancel.setText(SWT.getMessage("SWT_Cancel"));
        cancel.setLayoutData(new GridData(768));
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(ok);
        dialog.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog.getBounds();
        int x = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog.setLocation(x, y);
        dialog.open();
        Display display = this.browser.getDisplay();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    int takeFocus(long sender, int forward) {
        int traveralCode = forward == 0 ? 8 : 16;
        ((WebKit)this.browser.webBrowser).traverseOut = true;
        this.browser.traverse(traveralCode);
        return 0;
    }

    int webViewClose(long sender) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        CloseWindowListener[] closeWindowListeners = this.browser.webBrowser.closeWindowListeners;
        int i = 0;
        while (i < closeWindowListeners.length) {
            closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        return 0;
    }

    int webViewFrame(long sender, long frame) {
        RECT rect = new RECT();
        OS.MoveMemory(frame, rect, RECT.sizeof);
        return 0;
    }

    int webViewShow(long sender) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        newEvent.addressBar = this.toolBar;
        newEvent.menuBar = this.menuBar;
        newEvent.statusBar = this.statusBar;
        newEvent.toolBar = this.toolBar;
        VisibilityWindowListener[] visibilityWindowListeners = this.browser.webBrowser.visibilityWindowListeners;
        int i = 0;
        while (i < visibilityWindowListeners.length) {
            visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        this.location = null;
        this.size = null;
        return 0;
    }
}

