/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceActiveObject;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class OleFrame
extends Composite {
    private COMObject iUnknown;
    private COMObject iOleInPlaceFrame;
    private IOleInPlaceActiveObject objIOleInPlaceActiveObject;
    private OleClientSite currentdoc;
    private int refCount = 0;
    private MenuItem[] fileMenuItems;
    private MenuItem[] containerMenuItems;
    private MenuItem[] windowMenuItems;
    private Listener listener;
    private long shellHandle;
    private long oldMenuHandle;
    private long newMenuHandle;
    private static long lastActivatedMenuHandle;
    private static String CHECK_FOCUS;
    private static String HHOOK;
    private static String HHOOKMSG;
    private static boolean ignoreNextKey;
    private static final short[] ACCENTS;
    private static final String CONSUME_KEY = "org.eclipse.swt.OleFrame.ConsumeKey";
    private static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";

    static {
        CHECK_FOCUS = "OLE_CHECK_FOCUS";
        HHOOK = "OLE_HHOOK";
        HHOOKMSG = "OLE_HHOOK_MSG";
        ACCENTS = new short[]{126, 96, 39, 94, 34};
    }

    public OleFrame(Composite parent, int style) {
        super(parent, style);
        this.createCOMInterfaces();
        this.listener = e -> {
            switch (e.type) {
                case 26: {
                    this.onActivate(e);
                    break;
                }
                case 27: {
                    this.onDeactivate(e);
                    break;
                }
                case 12: {
                    this.onDispose(e);
                    break;
                }
                case 10: 
                case 11: {
                    this.onResize(e);
                    break;
                }
                default: {
                    OLE.error(20);
                }
            }
        };
        this.addListener(26, this.listener);
        this.addListener(27, this.listener);
        this.addListener(12, this.listener);
        this.addListener(11, this.listener);
        this.addListener(10, this.listener);
        this.AddRef();
        Display display = this.getDisplay();
        OleFrame.initCheckFocus(display);
        OleFrame.initMsgHook(display);
    }

    private static void initCheckFocus(Display display) {
        if (display.getData(CHECK_FOCUS) != null) {
            return;
        }
        display.setData(CHECK_FOCUS, CHECK_FOCUS);
        Runnable[] timer = new Runnable[1];
        Control[] lastFocus = new Control[1];
        timer[0] = () -> {
            if (lastFocus[0] instanceof OleClientSite && !lastFocus[0].isDisposed()) {
                long hwnd = OS.GetFocus();
                while (hwnd != 0L) {
                    long ownerHwnd = OS.GetWindow(hwnd, 4);
                    if (ownerHwnd != 0L) {
                        display.timerExec(50, timer[0]);
                        return;
                    }
                    hwnd = OS.GetParent(hwnd);
                }
            }
            if (lastFocus[0] == null || lastFocus[0].isDisposed() || !lastFocus[0].isFocusControl()) {
                Control currentFocus = display.getFocusControl();
                if (currentFocus instanceof OleFrame) {
                    OleFrame frame = (OleFrame)currentFocus;
                    currentFocus = frame.getCurrentDocument();
                }
                if (lastFocus[0] != currentFocus) {
                    Event event = new Event();
                    if (lastFocus[0] instanceof OleClientSite && !lastFocus[0].isDisposed()) {
                        lastFocus[0].notifyListeners(16, event);
                    }
                    if (currentFocus instanceof OleClientSite && !currentFocus.isDisposed()) {
                        currentFocus.notifyListeners(15, event);
                    }
                }
                controlArray[0] = currentFocus;
            }
            display.timerExec(50, timer[0]);
        };
        display.timerExec(50, timer[0]);
    }

    private static void initMsgHook(Display display) {
        int threadId;
        long hHook;
        if (display.getData(HHOOK) != null) {
            return;
        }
        Callback callback = new Callback(OleFrame.class, "getMsgProc", 3);
        long address = callback.getAddress();
        if (address == 0L) {
            SWT.error(3);
        }
        if ((hHook = OS.SetWindowsHookEx(3, address, 0L, threadId = OS.GetCurrentThreadId())) == 0L) {
            callback.dispose();
            return;
        }
        display.setData(HHOOK, new LONG(hHook));
        display.setData(HHOOKMSG, new MSG());
        display.disposeExec(() -> {
            if (hHook != 0L) {
                OS.UnhookWindowsHookEx(hHook);
            }
            if (callback != null) {
                callback.dispose();
            }
        });
    }

    static long getMsgProc(long code, long wParam, long lParam) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0L;
        }
        LONG hHook = (LONG)display.getData(HHOOK);
        if (hHook == null) {
            return 0L;
        }
        if (code < 0L || (wParam & 1L) == 0L) {
            return OS.CallNextHookEx(hHook.value, (int)code, wParam, lParam);
        }
        MSG msg = (MSG)display.getData(HHOOKMSG);
        OS.MoveMemory(msg, lParam, MSG.sizeof);
        int message = msg.message;
        if (256 <= message && message <= 264 && display != null) {
            Widget widget = null;
            long hwnd = msg.hwnd;
            while (hwnd != 0L) {
                widget = display.findWidget(hwnd);
                if (widget != null) break;
                hwnd = OS.GetParent(hwnd);
            }
            if (widget != null && widget instanceof OleClientSite) {
                OleClientSite site = (OleClientSite)widget;
                if (site.handle == hwnd) {
                    boolean consumed = false;
                    int thread = OS.GetWindowThreadProcessId(msg.hwnd, null);
                    GUITHREADINFO lpgui = new GUITHREADINFO();
                    lpgui.cbSize = GUITHREADINFO.sizeof;
                    boolean rc = OS.GetGUIThreadInfo(thread, lpgui);
                    int mask = 30;
                    if (!rc || (lpgui.flags & mask) == 0) {
                        OleFrame frame = site.frame;
                        frame.setData(CONSUME_KEY, null);
                        display.setData(ACCEL_KEY_HIT, Boolean.TRUE);
                        consumed = frame.translateOleAccelerator(msg);
                        if (display.isDisposed()) {
                            return 0L;
                        }
                        display.setData(ACCEL_KEY_HIT, Boolean.FALSE);
                        if (frame.isDisposed()) {
                            return 0L;
                        }
                        String value = (String)frame.getData(CONSUME_KEY);
                        if (value != null) {
                            consumed = value.equals("true");
                        }
                        frame.setData(CONSUME_KEY, null);
                    }
                    boolean accentKey = false;
                    block0 : switch (msg.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch ((int)msg.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block0;
                                }
                            }
                            int mapKey = OS.MapVirtualKey((int)msg.wParam, 2);
                            if (mapKey == 0) break;
                            boolean bl = accentKey = (mapKey & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0;
                            if (accentKey) break;
                            int i = 0;
                            while (i < ACCENTS.length) {
                                short value = OS.VkKeyScan(ACCENTS[i]);
                                if (value != -1 && (long)(value & 0xFF) == msg.wParam) {
                                    int state = value >> 8;
                                    if (OS.GetKeyState(16) < 0 == ((state & 1) != 0) && OS.GetKeyState(17) < 0 == ((state & 2) != 0) && OS.GetKeyState(18) < 0 == ((state & 4) != 0)) {
                                        if ((state & 7) == 0) break block0;
                                        accentKey = true;
                                        break block0;
                                    }
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    if (!(consumed || accentKey || ignoreNextKey)) {
                        long hwndOld = msg.hwnd;
                        msg.hwnd = site.handle;
                        consumed = OS.DispatchMessage(msg) == 1L;
                        msg.hwnd = hwndOld;
                    }
                    block6 : switch (msg.message) {
                        case 256: 
                        case 260: {
                            switch ((int)msg.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block6;
                                }
                            }
                            ignoreNextKey = accentKey;
                        }
                    }
                    if (consumed) {
                        msg.message = 0;
                        msg.lParam = 0L;
                        msg.wParam = 0L;
                        OS.MoveMemory(lParam, msg, MSG.sizeof);
                        return 0L;
                    }
                }
            }
        }
        return OS.CallNextHookEx(hHook.value, (int)code, wParam, lParam);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int ContextSensitiveHelp(int fEnterMode) {
        return 0;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.iUnknown = new COMObject(nArray){

            @Override
            public long method0(long[] args) {
                return OleFrame.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return OleFrame.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return OleFrame.this.Release();
            }
        };
        int[] nArray2 = new int[15];
        nArray2[0] = 2;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 3;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[14] = 2;
        this.iOleInPlaceFrame = new COMObject(nArray2){

            @Override
            public long method0(long[] args) {
                return OleFrame.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return OleFrame.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return OleFrame.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return OleFrame.this.GetWindow(args[0]);
            }

            @Override
            public long method4(long[] args) {
                return OleFrame.this.ContextSensitiveHelp((int)args[0]);
            }

            @Override
            public long method5(long[] args) {
                return OleFrame.this.GetBorder(args[0]);
            }

            @Override
            public long method6(long[] args) {
                return OleFrame.this.RequestBorderSpace(args[0]);
            }

            @Override
            public long method7(long[] args) {
                return OleFrame.this.SetBorderSpace(args[0]);
            }

            @Override
            public long method8(long[] args) {
                return OleFrame.this.SetActiveObject(args[0], args[1]);
            }

            @Override
            public long method9(long[] args) {
                return OleFrame.this.InsertMenus(args[0], args[1]);
            }

            @Override
            public long method10(long[] args) {
                return OleFrame.this.SetMenu(args[0], args[1], args[2]);
            }

            @Override
            public long method11(long[] args) {
                return OleFrame.this.RemoveMenus(args[0]);
            }

            @Override
            public long method14(long[] args) {
                return OleFrame.this.TranslateAccelerator(args[0], (int)args[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleInPlaceFrame != null) {
            this.iOleInPlaceFrame.dispose();
        }
        this.iOleInPlaceFrame = null;
    }

    private int GetBorder(long lprectBorder) {
        if (lprectBorder == 0L) {
            return -2147024809;
        }
        RECT rectBorder = new RECT();
        OS.GetClientRect(this.handle, rectBorder);
        OS.MoveMemory(lprectBorder, rectBorder, RECT.sizeof);
        return 0;
    }

    public MenuItem[] getContainerMenus() {
        return this.containerMenuItems;
    }

    public MenuItem[] getFileMenus() {
        return this.fileMenuItems;
    }

    long getIOleInPlaceFrame() {
        return this.iOleInPlaceFrame.getAddress();
    }

    private long getMenuItemID(long hMenu, int index) {
        long id = 0L;
        MENUITEMINFO lpmii = new MENUITEMINFO();
        lpmii.cbSize = MENUITEMINFO.sizeof;
        lpmii.fMask = 7;
        OS.GetMenuItemInfo(hMenu, index, true, lpmii);
        id = (lpmii.fState & 0x10) == 16 ? lpmii.hSubMenu : (long)lpmii.wID;
        return id;
    }

    private int GetWindow(long phwnd) {
        if (phwnd != 0L) {
            OS.MoveMemory(phwnd, new long[]{this.handle}, C.PTR_SIZEOF);
        }
        return 0;
    }

    public MenuItem[] getWindowMenus() {
        return this.windowMenuItems;
    }

    private int InsertMenus(long hmenuShared, long lpMenuWidths) {
        Menu menubar = this.getShell().getMenuBar();
        if (menubar == null || menubar.isDisposed()) {
            OS.MoveMemory(lpMenuWidths, new int[1], 4);
            return 0;
        }
        long hMenu = menubar.handle;
        MENUITEMINFO lpmii = new MENUITEMINFO();
        long hHeap = OS.GetProcessHeap();
        int cch = 128;
        int byteCount = cch * TCHAR.sizeof;
        long pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        lpmii.cbSize = MENUITEMINFO.sizeof;
        lpmii.fMask = 55;
        lpmii.dwTypeData = pszText;
        lpmii.cch = cch;
        int fileMenuCount = 0;
        int newindex = 0;
        if (this.fileMenuItems != null) {
            int i = 0;
            while (i < this.fileMenuItems.length) {
                MenuItem item = this.fileMenuItems[i];
                if (item != null) {
                    int index = item.getParent().indexOf(item);
                    lpmii.cch = cch;
                    if (OS.GetMenuItemInfo(hMenu, index, true, lpmii) && OS.InsertMenuItem(hmenuShared, newindex, true, lpmii)) {
                        ++fileMenuCount;
                        ++newindex;
                    }
                }
                ++i;
            }
        }
        OS.MoveMemory(lpMenuWidths, new int[]{fileMenuCount}, 4);
        int containerMenuCount = 0;
        if (this.containerMenuItems != null) {
            int i = 0;
            while (i < this.containerMenuItems.length) {
                MenuItem item = this.containerMenuItems[i];
                if (item != null) {
                    int index = item.getParent().indexOf(item);
                    lpmii.cch = cch;
                    if (OS.GetMenuItemInfo(hMenu, index, true, lpmii) && OS.InsertMenuItem(hmenuShared, newindex, true, lpmii)) {
                        ++containerMenuCount;
                        ++newindex;
                    }
                }
                ++i;
            }
        }
        OS.MoveMemory(lpMenuWidths + 8L, new int[]{containerMenuCount}, 4);
        int windowMenuCount = 0;
        if (this.windowMenuItems != null) {
            int i = 0;
            while (i < this.windowMenuItems.length) {
                MenuItem item = this.windowMenuItems[i];
                if (item != null) {
                    int index = item.getParent().indexOf(item);
                    lpmii.cch = cch;
                    if (OS.GetMenuItemInfo(hMenu, index, true, lpmii) && OS.InsertMenuItem(hmenuShared, newindex, true, lpmii)) {
                        ++windowMenuCount;
                        ++newindex;
                    }
                }
                ++i;
            }
        }
        OS.MoveMemory(lpMenuWidths + 16L, new int[]{windowMenuCount}, 4);
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        return 0;
    }

    void onActivate(Event e) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(true);
        }
    }

    void onDeactivate(Event e) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(false);
        }
    }

    private void onDispose(Event e) {
        this.releaseObjectInterfaces();
        this.currentdoc = null;
        this.Release();
        this.removeListener(26, this.listener);
        this.removeListener(27, this.listener);
        this.removeListener(12, this.listener);
        this.removeListener(11, this.listener);
        this.removeListener(10, this.listener);
    }

    void onFocusIn(Event e) {
        if (lastActivatedMenuHandle != this.newMenuHandle) {
            this.currentdoc.doVerb(-1);
        }
        if (OS.GetMenu(this.shellHandle) != this.newMenuHandle) {
            OS.SetMenu(this.shellHandle, this.newMenuHandle);
        }
    }

    void onFocusOut(Event e) {
        Control control = this.getDisplay().getFocusControl();
        if (OS.GetMenu(this.shellHandle) != this.oldMenuHandle && control != null && control.handle != this.shellHandle) {
            OS.SetMenu(this.shellHandle, this.oldMenuHandle);
        }
    }

    private void onResize(Event e) {
        if (this.objIOleInPlaceActiveObject != null) {
            RECT lpRect = new RECT();
            OS.GetClientRect(this.handle, lpRect);
            this.objIOleInPlaceActiveObject.ResizeBorder(lpRect, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    private int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIOleInPlaceFrame)) {
            OS.MoveMemory(ppvObject, new long[]{this.iOleInPlaceFrame.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    private void releaseObjectInterfaces() {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
        }
        this.objIOleInPlaceActiveObject = null;
    }

    private int RemoveMenus(long hmenuShared) {
        int index;
        long id;
        int index2;
        MenuItem item;
        int i;
        Menu menubar = this.getShell().getMenuBar();
        if (menubar == null || menubar.isDisposed()) {
            return 1;
        }
        long hMenu = menubar.handle;
        ArrayList<LONG> ids = new ArrayList<LONG>();
        if (this.fileMenuItems != null) {
            i = 0;
            while (i < this.fileMenuItems.length) {
                item = this.fileMenuItems[i];
                if (item != null && !item.isDisposed()) {
                    index2 = item.getParent().indexOf(item);
                    id = this.getMenuItemID(hMenu, index2);
                    ids.add(new LONG(id));
                }
                ++i;
            }
        }
        if (this.containerMenuItems != null) {
            i = 0;
            while (i < this.containerMenuItems.length) {
                item = this.containerMenuItems[i];
                if (item != null && !item.isDisposed()) {
                    index2 = item.getParent().indexOf(item);
                    id = this.getMenuItemID(hMenu, index2);
                    ids.add(new LONG(id));
                }
                ++i;
            }
        }
        if (this.windowMenuItems != null) {
            i = 0;
            while (i < this.windowMenuItems.length) {
                item = this.windowMenuItems[i];
                if (item != null && !item.isDisposed()) {
                    index2 = item.getParent().indexOf(item);
                    id = this.getMenuItemID(hMenu, index2);
                    ids.add(new LONG(id));
                }
                ++i;
            }
        }
        int i2 = index = OS.GetMenuItemCount(hmenuShared) - 1;
        while (i2 >= 0) {
            long id2 = this.getMenuItemID(hmenuShared, i2);
            if (ids.contains(new LONG(id2))) {
                OS.RemoveMenu(hmenuShared, i2, 1024);
            }
            --i2;
        }
        return 0;
    }

    private int RequestBorderSpace(long pborderwidths) {
        return 0;
    }

    int SetActiveObject(long pActiveObject, long pszObjName) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
            this.objIOleInPlaceActiveObject = null;
        }
        if (pActiveObject != 0L) {
            this.objIOleInPlaceActiveObject = new IOleInPlaceActiveObject(pActiveObject);
            this.objIOleInPlaceActiveObject.AddRef();
        }
        return 0;
    }

    private int SetBorderSpace(long pborderwidths) {
        if (this.objIOleInPlaceActiveObject == null) {
            return 0;
        }
        RECT borderwidth = new RECT();
        if (pborderwidths == 0L || this.currentdoc == null) {
            return 0;
        }
        COM.MoveMemory(borderwidth, pborderwidths, RECT.sizeof);
        this.currentdoc.setBorderSpace(borderwidth);
        return 0;
    }

    public void setContainerMenus(MenuItem[] containerMenus) {
        this.containerMenuItems = containerMenus;
    }

    OleClientSite getCurrentDocument() {
        return this.currentdoc;
    }

    void setCurrentDocument(OleClientSite doc) {
        this.currentdoc = doc;
        if (this.currentdoc != null && this.objIOleInPlaceActiveObject != null) {
            RECT lpRect = new RECT();
            OS.GetClientRect(this.handle, lpRect);
            this.objIOleInPlaceActiveObject.ResizeBorder(lpRect, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    public void setFileMenus(MenuItem[] fileMenus) {
        this.fileMenuItems = fileMenus;
    }

    private int SetMenu(long hmenuShared, long holemenu, long hwndActiveObject) {
        Menu menubar;
        long inPlaceActiveObject = 0L;
        if (this.objIOleInPlaceActiveObject != null) {
            inPlaceActiveObject = this.objIOleInPlaceActiveObject.getAddress();
        }
        if ((menubar = this.getShell().getMenuBar()) == null || menubar.isDisposed()) {
            return COM.OleSetMenuDescriptor(0L, this.getShell().handle, hwndActiveObject, this.iOleInPlaceFrame.getAddress(), inPlaceActiveObject);
        }
        long handle = menubar.getShell().handle;
        if (hmenuShared == 0L && holemenu == 0L) {
            hmenuShared = menubar.handle;
        }
        if (hmenuShared == 0L) {
            return -2147467259;
        }
        this.shellHandle = handle;
        this.oldMenuHandle = menubar.handle;
        lastActivatedMenuHandle = this.newMenuHandle = hmenuShared;
        return COM.OleSetMenuDescriptor(holemenu, handle, hwndActiveObject, this.iOleInPlaceFrame.getAddress(), inPlaceActiveObject);
    }

    public void setWindowMenus(MenuItem[] windowMenus) {
        this.windowMenuItems = windowMenus;
    }

    private boolean translateOleAccelerator(MSG msg) {
        if (this.objIOleInPlaceActiveObject == null) {
            return false;
        }
        int result = this.objIOleInPlaceActiveObject.TranslateAccelerator(msg);
        return result != 1 && result != -2147467263;
    }

    private int TranslateAccelerator(long lpmsg, int wID) {
        Menu menubar = this.getShell().getMenuBar();
        if (menubar == null || menubar.isDisposed() || !menubar.isEnabled()) {
            return 1;
        }
        if (wID < 0) {
            return 1;
        }
        Shell shell = menubar.getShell();
        long hwnd = shell.handle;
        long hAccel = OS.SendMessage(hwnd, 32769, 0L, 0L);
        if (hAccel == 0L) {
            return 1;
        }
        MSG msg = new MSG();
        OS.MoveMemory(msg, lpmsg, MSG.sizeof);
        int result = OS.TranslateAccelerator(hwnd, hAccel, msg);
        return result == 0 ? 1 : 0;
    }
}

