/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;

public class AggregateHyperlinkSegment
extends ParagraphSegment
implements IHyperlinkSegment {
    private String href;
    private Vector<ParagraphSegment> segments = new Vector();

    public void add(TextHyperlinkSegment segment) {
        this.segments.add(segment);
    }

    public void add(ImageHyperlinkSegment segment) {
        this.segments.add(segment);
    }

    @Override
    public boolean advanceLocator(GC gc, int wHint, Locator loc, Hashtable<String, Object> objectTable, boolean computeHeightOnly) {
        boolean newLine = false;
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = this.segments.get(i);
            if (segment.advanceLocator(gc, wHint, loc, objectTable, computeHeightOnly)) {
                newLine = true;
            }
            ++i;
        }
        return newLine;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void paint(GC gc, boolean hover, Hashtable<String, Object> resourceTable, boolean selected, SelectionData selData, Rectangle repaintRegion) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = this.segments.get(i);
            segment.paint(gc, hover, resourceTable, selected, selData, repaintRegion);
            ++i;
        }
    }

    @Override
    public String getText() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)((Object)this.segments.get(i));
            buf.append(segment.getText());
            ++i;
        }
        return buf.toString();
    }

    @Override
    public void paintFocus(GC gc, Color bg, Color fg, boolean selected, Rectangle repaintRegion) {
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)((Object)this.segments.get(i));
            segment.paintFocus(gc, bg, fg, selected, repaintRegion);
            ++i;
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.segments.size() == 0) {
            return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        }
        IHyperlinkSegment segment0 = (IHyperlinkSegment)((Object)this.segments.get(0));
        Rectangle bounds = segment0.getBounds();
        int i = 1;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)((Object)this.segments.get(i));
            Rectangle sbounds = segment.getBounds();
            bounds.add(sbounds);
            ++i;
        }
        return bounds;
    }

    @Override
    public boolean contains(int x, int y) {
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)((Object)this.segments.get(i));
            if (segment.contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle rect) {
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)((Object)this.segments.get(i));
            if (segment.intersects(rect)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void layout(GC gc, int width, Locator locator, Hashtable<String, Object> resourceTable, boolean selected) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = this.segments.get(i);
            segment.layout(gc, width, locator, resourceTable, selected);
            ++i;
        }
    }

    @Override
    public void computeSelection(GC gc, Hashtable<String, Object> resourceTable, SelectionData selData) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = this.segments.get(i);
            segment.computeSelection(gc, resourceTable, selData);
            ++i;
        }
    }

    @Override
    public void clearCache(String fontId) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = this.segments.get(i);
            segment.clearCache(fontId);
            ++i;
        }
    }

    @Override
    public String getTooltipText() {
        if (this.segments.size() > 0) {
            return this.segments.get(0).getTooltipText();
        }
        return super.getTooltipText();
    }

    @Override
    public boolean isFocusSelectable(Hashtable<String, Object> resourceTable) {
        return true;
    }

    @Override
    public boolean setFocus(Hashtable<String, Object> resourceTable, boolean direction) {
        return true;
    }
}

