/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class CopyResourceAction
extends SelectionListenerAction
implements ISelectionValidator {
    public static final String ID = "org.eclipse.ui.CopyResourceAction";
    protected IShellProvider shellProvider;
    protected CopyFilesAndFoldersOperation operation;
    private String[] modelProviderIds;

    public static IPath getNewNameFor(IPath originalName, IWorkspace workspace) {
        return CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace);
    }

    @Deprecated
    public CopyResourceAction(Shell shell) {
        this(shell, IDEWorkbenchMessages.CopyResourceAction_title);
    }

    public CopyResourceAction(IShellProvider provider) {
        this(provider, IDEWorkbenchMessages.CopyResourceAction_title);
    }

    @Deprecated
    CopyResourceAction(Shell shell, String name) {
        super(name);
        Assert.isNotNull((Object)shell);
        this.shellProvider = () -> shell;
        this.initAction();
    }

    CopyResourceAction(IShellProvider provider, String name) {
        super(name);
        Assert.isNotNull((Object)provider);
        this.shellProvider = provider;
        this.initAction();
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new CopyFilesAndFoldersOperation(this.getShell());
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.CopyResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.copy_resource_action_context");
    }

    IContainer getInitialContainer() {
        List<? extends IResource> resources = this.getSelectedResources();
        if (resources.size() > 0) {
            IResource resource = resources.get(0);
            return resource.getParent();
        }
        return null;
    }

    protected IResource[] getResources(List<? extends IResource> resourceList) {
        return resourceList.toArray(new IResource[resourceList.size()]);
    }

    Shell getShell() {
        return this.shellProvider.getShell();
    }

    public String isValid(Object destination) {
        IWorkspaceRoot root = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        IContainer container = (IContainer)root.findMember((IPath)destination);
        if (container != null) {
            CopyFilesAndFoldersOperation newOperation = this.createOperation();
            List<? extends IResource> sources = this.getSelectedResources();
            IResource[] resources = sources.toArray(new IResource[sources.size()]);
            return newOperation.validateDestination(container, resources);
        }
        return null;
    }

    IPath queryDestinationResource() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.shellProvider.getShell(), this.getInitialContainer(), true, IDEWorkbenchMessages.CopyResourceAction_selectDestination);
        dialog.setValidator(this);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    public void run() {
        try {
            this.operation = this.createOperation();
            this.operation.setModelProviderIds(this.getModelProviderIds());
            List<? extends IResource> sources = this.getSelectedResources();
            IPath destination = this.queryDestinationResource();
            if (destination == null) {
                return;
            }
            IWorkspaceRoot root = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
            IContainer container = (IContainer)root.findMember(destination);
            if (container == null) {
                return;
            }
            this.runOperation(this.getResources(sources), container);
        }
        finally {
            this.operation = null;
        }
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        this.operation.copyResources(resources, destination);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List<? extends IResource> selectedResources = this.getSelectedResources();
        if (selectedResources.size() == 0) {
            return false;
        }
        IContainer firstParent = selectedResources.get(0).getParent();
        if (firstParent == null) {
            return false;
        }
        for (IResource iResource : selectedResources) {
            if (!iResource.exists()) {
                return false;
            }
            if (iResource.getType() == 4) {
                return false;
            }
            IContainer parent = iResource.getParent();
            if (parent == null || parent.equals((Object)firstParent)) continue;
            return false;
        }
        return true;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }
}

