/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.osgi.service.event.EventHandler;

public abstract class CompatibilityPart
implements ISelectionChangedListener {
    public static final String COMPATIBILITY_EDITOR_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor";
    public static final String COMPATIBILITY_VIEW_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    public static final String ENABLE_DEPENDENCY_INJECTION_FOR_E3_PARTS = "ENABLE_DEPENDENCY_INJECTION_FOR_E3";
    @Inject
    Composite composite;
    @Inject
    Logger logger;
    IWorkbenchPart wrapped;
    MPart part;
    @Inject
    private IEventBroker eventBroker;
    private boolean beingDisposed = false;
    private boolean alreadyDisposed = false;
    private boolean focusDelegatingInProgress;
    private EventHandler widgetSetHandler = event -> {
        if (event.getProperty("ChangedElement") == this.part && event.getProperty("NewValue") == null) {
            Assert.isTrue((!this.composite.isDisposed() ? 1 : 0) != 0, (String)"The widget should not have been disposed at this point");
            this.beingDisposed = true;
            WorkbenchPartReference reference = this.getReference();
            ((WorkbenchPage)reference.getPage()).firePartDeactivatedIfActive(this.part);
            ((WorkbenchPage)reference.getPage()).firePartHidden(this.part);
            ((WorkbenchPage)reference.getPage()).firePartClosed(this);
        }
    };
    private EventHandler objectSetHandler = event -> {
        if (event.getProperty("ChangedElement") == this.part && event.getProperty("NewValue") != null) {
            WorkbenchPartReference reference = this.getReference();
            ((WorkbenchPage)reference.getPage()).firePartOpened(this);
        }
    };
    private ISelectionChangedListener postListener = e -> {
        ESelectionService selectionService = (ESelectionService)this.part.getContext().get(ESelectionService.class);
        selectionService.setPostSelection((Object)e.getSelection());
    };
    private IWorkbenchPart legacyPart;

    CompatibilityPart(MPart part) {
        this.part = part;
    }

    @PersistState
    void persistState() {
        ContextInjectionFactory.invoke((Object)this.wrapped, PersistState.class, (IEclipseContext)this.part.getContext(), null);
    }

    public abstract WorkbenchPartReference getReference();

    protected boolean createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        ISelectionProvider selectionProvider;
        this.legacyPart = legacyPart;
        IWorkbenchPartSite site = null;
        try {
            site = legacyPart.getSite();
            this.part.getContext().set(Composite.class, (Object)parent);
            if (this.part.getTags().contains("inject")) {
                ContextInjectionFactory.inject((Object)legacyPart, (IEclipseContext)this.part.getContext());
            }
            legacyPart.createPartControl(parent);
        }
        catch (RuntimeException e) {
            this.logger.error((Throwable)e);
            try {
                legacyPart.dispose();
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
            }
            this.internalDisposeSite(site);
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, "Failed to create the part's controls", (Throwable)e);
            WorkbenchPartReference reference = this.getReference();
            this.wrapped = reference.createErrorPart((IStatus)status);
            try {
                reference.initialize(this.wrapped);
                this.wrapped.createPartControl(parent);
            }
            catch (RuntimeException ex) {
                this.logger.error((Throwable)ex);
            }
            catch (PartInitException ex) {
                WorkbenchPlugin.log("Unable to initialize error part", ex.getStatus());
            }
        }
        if (site != null && (selectionProvider = site.getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.postListener);
            } else {
                selectionProvider.addSelectionChangedListener(this.postListener);
            }
            ESelectionService selectionService = (ESelectionService)this.part.getContext().get(ESelectionService.class);
            selectionService.setSelection((Object)selectionProvider.getSelection());
        }
        return true;
    }

    @Focus
    void delegateSetFocus() {
        if (this.focusDelegatingInProgress) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Ignored attempt to set focus during set focus for: " + this);
            }
            return;
        }
        this.focusDelegatingInProgress = true;
        try {
            try {
                if (this.part.getTags().contains("inject")) {
                    ContextInjectionFactory.invoke((Object)this.wrapped, Focus.class, (IEclipseContext)this.part.getContext(), null);
                }
                this.wrapped.setFocus();
            }
            catch (Exception e) {
                if (this.logger != null) {
                    String msg = "Error setting focus to : " + this.part.getClass().getName();
                    msg = String.valueOf(msg) + ' ' + this.part.getLocalizedLabel();
                    this.logger.error((Throwable)e, msg);
                }
                this.focusDelegatingInProgress = false;
            }
        }
        finally {
            this.focusDelegatingInProgress = false;
        }
    }

    private void invalidate() {
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite site = null;
        if (this.wrapped != null && (site = this.wrapped.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.postListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.postListener);
            }
        }
        WorkbenchPartReference reference = this.getReference();
        reference.invalidate();
        if (this.wrapped != null) {
            try {
                this.wrapped.dispose();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
            this.wrapped = null;
        }
        this.internalDisposeSite(site);
        this.alreadyDisposed = true;
    }

    private String computeLabel() {
        if (this.wrapped instanceof IWorkbenchPart2) {
            String label = ((IWorkbenchPart2)this.wrapped).getPartName();
            return Util.safeString(label);
        }
        IWorkbenchPartSite site = this.wrapped.getSite();
        if (site != null) {
            return Util.safeString(site.getRegisteredName());
        }
        return Util.safeString(this.wrapped.getTitle());
    }

    public boolean isBeingDisposed() {
        return this.beingDisposed;
    }

    IWorkbenchPart createPart(WorkbenchPartReference reference) throws PartInitException {
        return reference.createPart();
    }

    boolean handlePartInitException(PartInitException e) {
        WorkbenchPartReference reference = this.getReference();
        PartSite site = reference.getSite();
        reference.invalidate();
        if (this.wrapped instanceof IEditorPart) {
            try {
                this.wrapped.dispose();
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
            }
        }
        this.internalDisposeSite(site);
        this.alreadyDisposed = false;
        WorkbenchPlugin.log("Unable to create part", e.getStatus());
        this.wrapped = reference.createErrorPart(e.getStatus());
        try {
            reference.initialize(this.wrapped);
        }
        catch (PartInitException ex) {
            WorkbenchPlugin.log("Unable to initialize error part", ex.getStatus());
            return false;
        }
        return true;
    }

    @PostConstruct
    public void create() {
        ISaveablePart saveable;
        block8: {
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetSetHandler);
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/Contribution/object/*", this.objectSetHandler);
            WorkbenchPartReference reference = this.getReference();
            try {
                this.wrapped = this.createPart(reference);
                reference.initialize(this.wrapped);
            }
            catch (PartInitException e) {
                if (!this.handlePartInitException(e)) {
                    return;
                }
            }
            catch (Exception e) {
                WorkbenchPlugin.log("Unable to initialize part", e);
                if (this.handlePartInitException(new PartInitException(e.getMessage()))) break block8;
                return;
            }
        }
        int style = 0;
        if (this.wrapped instanceof IWorkbenchPartOrientation) {
            style = ((IWorkbenchPartOrientation)((Object)this.wrapped)).getOrientation();
        }
        Composite parent = new Composite(this.composite, style);
        parent.setLayout((Layout)new FillLayout());
        if (!this.createPartControl(this.wrapped, parent)) {
            return;
        }
        if (!(this.wrapped instanceof ErrorEditorPart) && !(this.wrapped instanceof ErrorViewPart)) {
            this.part.setLabel(this.computeLabel());
            this.part.getTransientData().put("e4_override_title_tool_tip_key", this.wrapped.getTitleToolTip());
            this.part.getTransientData().put("e4_override_icon_image_key", this.wrapped.getTitleImage());
        }
        if ((saveable = SaveableHelper.getSaveable(this.wrapped)) != null && SaveableHelper.isDirtyStateSupported(this.wrapped)) {
            this.part.setDirty(saveable.isDirty());
        }
        this.wrapped.addPropertyListener((source, propId) -> {
            switch (propId) {
                case 1: {
                    String titleToolTip;
                    this.part.setLabel(this.computeLabel());
                    if (this.wrapped.getTitleImage() != null) {
                        Image newImage = this.wrapped.getTitleImage();
                        this.part.getTransientData().put("e4_override_icon_image_key", newImage);
                    }
                    if ((titleToolTip = this.wrapped.getTitleToolTip()) == null) break;
                    this.part.getTransientData().put("e4_override_title_tool_tip_key", titleToolTip);
                    break;
                }
                case 257: {
                    boolean supportsDirtyState = SaveableHelper.isDirtyStateSupported(this.wrapped);
                    if (!supportsDirtyState) {
                        this.part.setDirty(false);
                        return;
                    }
                    ISaveablePart saveable1 = SaveableHelper.getSaveable(this.wrapped);
                    if (saveable1 != null) {
                        this.part.setDirty(saveable1.isDirty());
                        break;
                    }
                    if (!this.part.isDirty()) break;
                    this.part.setDirty(false);
                    break;
                }
                case 258: {
                    WorkbenchPartReference ref = this.getReference();
                    ((WorkbenchPage)ref.getSite().getPage()).firePartInputChanged(ref);
                }
            }
        });
    }

    @PreDestroy
    void destroy() {
        if (!this.alreadyDisposed) {
            this.invalidate();
        }
        this.eventBroker.unsubscribe(this.widgetSetHandler);
        this.eventBroker.unsubscribe(this.objectSetHandler);
    }

    private void internalDisposeSite(IWorkbenchPartSite site) {
        if (site instanceof PartSite) {
            this.disposeSite((PartSite)site);
        }
    }

    void disposeSite(PartSite site) {
        site.dispose();
        if (this.part.getTags().contains("inject")) {
            ContextInjectionFactory.uninject((Object)this.legacyPart, (IEclipseContext)this.part.getContext());
        }
    }

    @Persist
    void doSave() {
        ISaveablePart saveable = SaveableHelper.getSaveable(this.wrapped);
        if (saveable != null) {
            SaveableHelper.savePart(saveable, this.wrapped, this.getReference().getSite().getWorkbenchWindow(), false);
        }
    }

    public IWorkbenchPart getPart() {
        return this.wrapped;
    }

    public MPart getModel() {
        return this.part;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        ESelectionService selectionService = (ESelectionService)this.part.getContext().get(ESelectionService.class);
        selectionService.setSelection((Object)e.getSelection());
    }

    protected void clearMenuItems() {
        for (MMenu menu : this.part.getMenus()) {
            menu.getChildren().clear();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompatibilityPart [");
        if (this.part != null) {
            builder.append("partId=");
            builder.append(this.part.getElementId());
            builder.append(", properties=");
            builder.append(this.part.getProperties());
            builder.append(", tags=");
            builder.append(this.part.getTags());
        }
        if (this.wrapped != null) {
            builder.append(", wrapped=");
            builder.append(this.wrapped.getClass());
        }
        if (this.legacyPart != null) {
            builder.append(", legacyPart=");
            builder.append(this.legacyPart.getClass());
        }
        builder.append(", beingDisposed=");
        builder.append(this.beingDisposed);
        builder.append(", alreadyDisposed=");
        builder.append(this.alreadyDisposed);
        builder.append("]");
        return builder.toString();
    }
}

