/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.menus.MenuHelper;

public class ActionSet {
    public static final String MAIN_TOOLBAR = "org.eclipse.ui.main.toolbar";
    public static final String MAIN_MENU = "org.eclipse.ui.main.menu";
    protected IConfigurationElement configElement;
    protected MApplication application;
    protected Expression visibleWhen;
    private HashSet<String> menuContributionGroupIds = new HashSet();
    private HashSet<String> toolbarContributionGroupIds = new HashSet();
    private String id;

    public String getId() {
        return this.id;
    }

    public ActionSet(MApplication application, IEclipseContext appContext, IConfigurationElement element) {
        this.application = application;
        this.configElement = element;
        this.id = MenuHelper.getId(this.configElement);
    }

    public void addToModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IConfigurationElement[] actions;
        IConfigurationElement[] menus;
        String idContrib = MenuHelper.getId(this.configElement);
        this.visibleWhen = this.createExpression(this.configElement);
        EContextService contextService = (EContextService)this.application.getContext().get(EContextService.class);
        Context actionSetContext = contextService.getContext(idContrib);
        if (!actionSetContext.isDefined()) {
            actionSetContext.define(MenuHelper.getLabel(this.configElement), MenuHelper.getDescription(this.configElement), "org.eclipse.ui.contexts.actionSet");
        }
        if ((menus = this.configElement.getChildren("menu")).length > 0) {
            int i = menus.length;
            while (i > 0) {
                IConfigurationElement element = menus[i - 1];
                this.addContribution(idContrib, menuContributions, element, true, MAIN_MENU);
                --i;
            }
        }
        if ((actions = this.configElement.getChildren("action")).length > 0) {
            int i = 0;
            while (i < actions.length) {
                IConfigurationElement up = actions[i];
                IConfigurationElement down = actions[actions.length - 1 - i];
                this.addContribution(idContrib, menuContributions, down, false, MAIN_MENU);
                this.addToolBarContribution(idContrib, toolBarContributions, trimContributions, up, MAIN_TOOLBAR);
                ++i;
            }
        }
    }

    protected Expression createExpression(IConfigurationElement configElement) {
        String actionSetId = MenuHelper.getId(configElement);
        Set<String> associatedPartIds = this.actionSetPartAssociations(actionSetId);
        return new ActionSetAndPartExpression(actionSetId, associatedPartIds);
    }

    private Set<String> actionSetPartAssociations(String actionSetId) {
        IConfigurationElement[] associations;
        HashSet<String> result = new HashSet<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = associations = registry.getConfigurationElementsFor("org.eclipse.ui.actionSetPartAssociations");
        int n = associations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String targetId = element.getAttribute("targetID");
            if (actionSetId.equals(targetId)) {
                IConfigurationElement[] children;
                IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren("part");
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement part = iConfigurationElementArray2[n4];
                    String id = MenuHelper.getId(part);
                    if (id != null && id.length() > 0) {
                        if (Policy.DEBUG_MENUS) {
                            MenuHelper.trace("actionSetPartAssociations:" + actionSetId + ':' + id, null);
                        }
                        result.add(id);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    private MCoreExpression createVisibleWhen() {
        if (this.visibleWhen == null) {
            return null;
        }
        MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
        exp.setCoreExpressionId("programmatic." + MenuHelper.getId(this.configElement));
        exp.setCoreExpression((Object)this.visibleWhen);
        return exp;
    }

    protected void addContribution(String idContrib, ArrayList<MMenuContribution> contributions, IConfigurationElement element, boolean isMenu, String parentId) {
        String path;
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.setVisibleWhen((MExpression)this.createVisibleWhen());
        menuContribution.getTags().add("menuContribution:menu");
        menuContribution.getTags().add("scheme:menu");
        String elementId = MenuHelper.getId(element);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(String.valueOf(idContrib) + "/" + elementId);
        } else {
            menuContribution.setElementId(elementId);
        }
        String string = path = isMenu ? MenuHelper.getPath(element) : MenuHelper.getMenuBarPath(element);
        if (path == null || path.length() == 0) {
            if (!isMenu) {
                return;
            }
            path = "additions";
        }
        if (path.endsWith("/")) {
            path = String.valueOf(path) + "additions";
        }
        Path menuPath = new Path(path);
        String positionInParent = "after=" + menuPath.segment(0);
        int segmentCount = menuPath.segmentCount();
        if (segmentCount > 1) {
            parentId = menuPath.segment(segmentCount - 2);
            positionInParent = "after=" + menuPath.segment(segmentCount - 1);
        }
        menuContribution.setParentId(parentId);
        menuContribution.setPositionInParent(positionInParent);
        if (isMenu) {
            MMenu menu = MenuHelper.createMenuAddition(element);
            if (menu != null) {
                this.contributeMenuGroup(contributions, parentId, positionInParent);
                menuContribution.getChildren().add(menu);
                menu.getTransientData().put("ActionSet", this.id);
            }
        } else {
            MMenuElement action;
            if (parentId.equals(MAIN_MENU)) {
                E4Util.unsupported("****MC: bad pie: " + menuPath);
                parentId = "window";
                menuContribution.setParentId(parentId);
            }
            if ((action = MenuHelper.createLegacyMenuActionAdditions(this.application, element)) != null) {
                this.contributeMenuGroup(contributions, parentId, positionInParent);
                menuContribution.getChildren().add(action);
                action.getTransientData().put("ActionSet", this.id);
            }
        }
        if (menuContribution.getChildren().size() > 0) {
            contributions.add(menuContribution);
        }
        if (isMenu) {
            this.processGroups(idContrib, contributions, element);
        }
    }

    private void contributeMenuGroup(ArrayList<MMenuContribution> contributions, String parentId, String positionInParent) {
        String group = positionInParent.substring(6);
        if (this.menuContributionGroupIds.contains(String.valueOf(parentId) + group)) {
            return;
        }
        this.menuContributionGroupIds.add(String.valueOf(parentId) + group);
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.setVisibleWhen((MExpression)this.createVisibleWhen());
        menuContribution.getTags().add("menuContribution:menu");
        menuContribution.getTags().add("scheme:menu");
        menuContribution.setParentId(parentId);
        menuContribution.setPositionInParent("after=additions");
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
        sep.setVisible(false);
        sep.setElementId(group);
        menuContribution.getChildren().add(sep);
        contributions.add(menuContribution);
    }

    private void contributeToolBarGroup(ArrayList<MToolBarContribution> contributions, String parentId, String group) {
        if (this.toolbarContributionGroupIds.contains(String.valueOf(parentId) + group)) {
            return;
        }
        this.toolbarContributionGroupIds.add(String.valueOf(parentId) + group);
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        toolBarContribution.getTags().add("menuContribution:menu");
        toolBarContribution.getTags().add("scheme:toolbar");
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent("after=additions");
        MToolBarSeparator sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId(group);
        sep.setVisible(false);
        toolBarContribution.getChildren().add(sep);
        contributions.add(toolBarContribution);
    }

    protected void addToolBarContribution(String idContrib, ArrayList<MToolBarContribution> contributions, ArrayList<MTrimContribution> trimContributions, IConfigurationElement element, String parentId) {
        String tpath = MenuHelper.getToolBarPath(element);
        if (tpath == null || this.isEditorAction(element)) {
            return;
        }
        if (tpath.endsWith("/")) {
            tpath = String.valueOf(tpath) + "additions";
        }
        MToolBarElement action = MenuHelper.createLegacyToolBarActionAdditions(this.application, element);
        action.getTransientData().put("Name", MenuHelper.getLabel(element));
        action.getTransientData().put("ActionSet", this.id);
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        toolBarContribution.getTags().add("menuContribution:menu");
        toolBarContribution.getTags().add("scheme:toolbar");
        String elementId = MenuHelper.getId(element);
        if (idContrib != null && idContrib.length() > 0) {
            toolBarContribution.setElementId(String.valueOf(idContrib) + "/" + elementId);
            toolBarContribution.getTags().add("ActionSet::" + idContrib);
        } else {
            toolBarContribution.setElementId(elementId);
        }
        String tgroup = null;
        if (tpath != null) {
            int loc = tpath.lastIndexOf(47);
            if (loc != -1) {
                tgroup = tpath.substring(loc + 1);
                tpath = tpath.substring(0, loc);
            } else {
                tgroup = tpath;
                tpath = null;
            }
        }
        if (tpath == null || tpath.equals("Normal")) {
            IConfigurationElement parent = (IConfigurationElement)element.getParent();
            tpath = parent.getAttribute("id");
        }
        Path menuPath = new Path(tpath);
        tpath = menuPath.segment(0);
        if (MAIN_TOOLBAR.equals(parentId)) {
            this.addTrimContribution(idContrib, contributions, trimContributions, element, parentId, tpath, tgroup);
        } else {
            tpath = parentId;
        }
        String positionInParent = "after=" + tgroup;
        this.contributeToolBarGroup(contributions, tpath, tgroup);
        toolBarContribution.setParentId(tpath);
        toolBarContribution.setPositionInParent(positionInParent);
        toolBarContribution.setVisibleWhen((MExpression)this.createVisibleWhen());
        toolBarContribution.getChildren().add(action);
        contributions.add(toolBarContribution);
    }

    private boolean isEditorAction(IConfigurationElement element) {
        return "org.eclipse.ui.editorActions".equals(element.getDeclaringExtension().getExtensionPointUniqueIdentifier());
    }

    private void addTrimContribution(String idContrib, ArrayList<MToolBarContribution> contributions, ArrayList<MTrimContribution> trimContributions, IConfigurationElement element, String parentId, String tpath, String tgroup) {
        String elementId = MenuHelper.getId(element);
        MTrimContribution trimContribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        trimContribution.getTags().add("menuContribution:toolbar");
        trimContribution.getTags().add("scheme:toolbar");
        if (idContrib != null && idContrib.length() > 0) {
            trimContribution.setElementId(String.valueOf(idContrib) + "/" + elementId);
        } else {
            trimContribution.setElementId(elementId);
        }
        trimContribution.setParentId(parentId);
        trimContribution.setPositionInParent("after=additions");
        MToolBar tb = MenuFactoryImpl.eINSTANCE.createToolBar();
        tb.setElementId(tpath);
        tb.getTransientData().put("Name", MenuHelper.getLabel(this.configElement));
        tb.getTransientData().put("ActionSet", this.id);
        trimContribution.getChildren().add(tb);
        trimContributions.add(trimContribution);
    }

    private void processGroups(String idContrib, ArrayList<MMenuContribution> contributions, IConfigurationElement element) {
        IConfigurationElement[] children;
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.setVisibleWhen((MExpression)this.createVisibleWhen());
        menuContribution.getTags().add("menuContribution:menu");
        menuContribution.getTags().add("scheme:menu");
        String elementId = MenuHelper.getId(element);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(String.valueOf(idContrib) + "/" + elementId + ".groups");
        } else {
            menuContribution.setElementId(String.valueOf(elementId) + ".groups");
        }
        menuContribution.setParentId(elementId);
        menuContribution.setPositionInParent("after=additions");
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement sepAddition = iConfigurationElementArray[n2];
            String name = sepAddition.getAttribute("name");
            String tag = sepAddition.getName();
            MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
            sep.setElementId(name);
            if ("groupMarker".equals(tag)) {
                sep.setVisible(false);
                sep.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
            }
            menuContribution.getChildren().add(sep);
            ++n2;
        }
        if (menuContribution.getChildren().size() > 0) {
            contributions.add(menuContribution);
        }
    }

    MElementContainer<MMenuElement> findMenuFromPath(MElementContainer<MMenuElement> menu, Path menuPath, int segment) {
        int idx = ContributionsAnalyzer.indexForId(menu, (String)menuPath.segment(segment));
        if (idx == -1) {
            if (segment + 1 < menuPath.segmentCount() || !menuPath.hasTrailingSeparator()) {
                return null;
            }
            return menu;
        }
        MElementContainer item = (MElementContainer)menu.getChildren().get(idx);
        if (item.getChildren().size() == 0) {
            if (segment + 1 == menuPath.segmentCount()) {
                return menu;
            }
            return null;
        }
        return this.findMenuFromPath((MElementContainer<MMenuElement>)item, menuPath, segment + 1);
    }

    static class ActionSetAndPartExpression
    extends Expression {
        private String id;
        private Set<String> partIds;

        public ActionSetAndPartExpression(String id, Set<String> associatedPartIds) {
            this.id = id;
            this.partIds = associatedPartIds;
        }

        public void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeContexts");
            info.addVariableNameAccess("activePartId");
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            boolean rc;
            Object obj = context.getVariable("activeContexts");
            if (obj instanceof Collection && (rc = ((Collection)obj).contains(this.id))) {
                return EvaluationResult.TRUE;
            }
            if (!this.partIds.isEmpty()) {
                return EvaluationResult.valueOf((boolean)this.partIds.contains(context.getVariable("activePartId")));
            }
            return EvaluationResult.FALSE;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActionSetAndPartExpression)) {
                return false;
            }
            ActionSetAndPartExpression exp = (ActionSetAndPartExpression)((Object)obj);
            return this.id.equals(exp.id) && this.partIds.equals(exp.partIds);
        }

        public int hashCode() {
            return this.id.hashCode() + this.partIds.hashCode();
        }
    }
}

