/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.launching.AntLaunch;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.launching.debug.model.RemoteAntDebugBuildListener;
import org.eclipse.ant.internal.launching.launchConfigurations.AntJavaLaunchDelegate;
import org.eclipse.ant.internal.launching.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.launching.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.launching.launchConfigurations.RemoteAntBuildListener;
import org.eclipse.core.externaltools.internal.launchConfigurations.BackgroundResourceRefresher;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class AntLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String ANT_LOGGER_CLASS = "org.eclipse.ant.internal.launching.runtime.logger.AntProcessBuildLogger";
    private static final String ANT_DEBUG_LOGGER_CLASS = "org.eclipse.ant.internal.launching.runtime.logger.AntProcessDebugBuildLogger";
    private static final String NULL_LOGGER_CLASS = "org.eclipse.ant.internal.launching.runtime.logger.NullBuildLogger";
    private static final String REMOTE_ANT_LOGGER_CLASS = "org.eclipse.ant.internal.launching.remote.logger.RemoteAntBuildLogger";
    private static final String REMOTE_ANT_DEBUG_LOGGER_CLASS = "org.eclipse.ant.internal.launching.remote.logger.RemoteAntDebugBuildLogger";
    private static final String BASE_DIR_PREFIX = "-Dbasedir=";
    private static final String INPUT_HANDLER_CLASS = "org.eclipse.ant.internal.ui.antsupport.inputhandler.AntInputHandler";
    private static final String REMOTE_INPUT_HANDLER_CLASS = "org.eclipse.ant.internal.ui.antsupport.inputhandler.ProxyInputHandler";
    private static final String ATTR_BUILD_SCOPE = String.valueOf(AntLaunching.getUniqueIdentifier()) + ".ATTR_BUILD_SCOPE";
    private static final String ATTR_INCLUDE_REFERENCED_PROJECTS = String.valueOf(AntLaunching.getUniqueIdentifier()) + ".ATTR_INCLUDE_REFERENCED_PROJECTS";
    private static String fgSWTLibraryLocation;
    private String fMode;
    ILaunchManager launchManager;
    private boolean fUserSpecifiedLogger = false;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath jrePath;
        IVMInstall vm;
        String path = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, new String(""));
        if (!path.isEmpty() && (vm = JavaRuntime.getVMInstall((IPath)(jrePath = Path.fromPortableString((String)path)))) instanceof AbstractVMInstall) {
            boolean useDefault;
            AbstractVMInstall install = (AbstractVMInstall)vm;
            String vmver = install.getJavaVersion();
            if (vmver.length() > 3) {
                vmver = vmver.substring(0, 3);
            }
            if (JavaCore.compareJavaVersions((String)vmver, (String)"1.8") < 0 && (useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true))) {
                Status status = new Status(4, "org.eclipse.ant.launching", 1, AntLaunchConfigurationMessages.AntLaunchDelegate_Launching__0__2, null);
                throw new CoreException((IStatus)status);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.fUserSpecifiedLogger = false;
        this.fMode = mode;
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        AntLaunchingUtil.migrateToNewClasspathFormat(configuration);
        boolean isSeparateJRE = AntLaunchingUtil.isSeparateJREAntBuild(configuration);
        if (AntLaunchingUtil.isLaunchInBackground(configuration)) {
            monitor.beginTask(MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchDelegate_Launching__0__1, (Object[])new Object[]{configuration.getName()}), 10);
        } else {
            monitor.beginTask(MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchDelegate_Running__0__2, (Object[])new Object[]{configuration.getName()}), 100);
        }
        IPath location = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)configuration);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        if (!isSeparateJRE && AntRunner.isBuildRunning()) {
            Status status = new Status(4, "org.eclipse.ant.launching", 1, MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchDelegate_Build_In_Progress, (Object[])new Object[]{location.toOSString()}), null);
            throw new CoreException((IStatus)status);
        }
        IPath workingDirectory = ExternalToolsCoreUtil.getWorkingDirectory((ILaunchConfiguration)configuration);
        String basedir = null;
        if (workingDirectory != null) {
            basedir = workingDirectory.toOSString();
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        String idStamp = Long.toString(timeStamp);
        StringBuffer idProperty = new StringBuffer("-D");
        idProperty.append("org.eclipse.ant.core.ANT_PROCESS_ID");
        idProperty.append('=');
        idProperty.append(idStamp);
        String[] arguments = ExternalToolsCoreUtil.getArguments((ILaunchConfiguration)configuration);
        Map<String, String> userProperties = AntLaunchingUtil.getProperties(configuration);
        if (userProperties != null) {
            userProperties = new HashMap<String, String>(userProperties);
        }
        String[] propertyFiles = AntLaunchingUtil.getPropertyFiles(configuration);
        String[] targets = AntLaunchingUtil.getTargetNames(configuration);
        URL[] customClasspath = AntLaunchingUtil.getCustomClasspath(configuration);
        String antHome = AntLaunchingUtil.getAntHome(configuration);
        boolean setInputHandler = true;
        try {
            setInputHandler = configuration.getAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", true);
        }
        catch (CoreException ce) {
            AntLaunching.log(ce);
        }
        AntRunner runner = null;
        if (!isSeparateJRE) {
            runner = this.configureAntRunner(configuration, location, basedir, idProperty, arguments, userProperties, propertyFiles, targets, customClasspath, antHome, setInputHandler);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        boolean captureOutput = ExternalToolsCoreUtil.getCaptureOutput((ILaunchConfiguration)configuration);
        int port = -1;
        int requestPort = -1;
        if (isSeparateJRE && captureOutput) {
            if (userProperties == null) {
                userProperties = new HashMap<String, String>();
            }
            port = SocketUtil.findFreePort();
            userProperties.put("org.eclipse.ant.core.ANT_PROCESS_ID", idStamp);
            userProperties.put("eclipse.connect.port", Integer.toString(port));
            if (this.fMode.equals("debug")) {
                requestPort = SocketUtil.findFreePort();
                userProperties.put("eclipse.connect.request_port", Integer.toString(requestPort));
            }
        }
        StringBuffer commandLine = this.generateCommandLine(location, arguments, userProperties, propertyFiles, targets, antHome, basedir, isSeparateJRE, captureOutput, setInputHandler);
        if (isSeparateJRE) {
            monitor.beginTask(MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchDelegate_Launching__0__1, (Object[])new Object[]{configuration.getName()}), 10);
            this.runInSeparateVM(configuration, launch, monitor, idStamp, antHome, port, requestPort, commandLine, captureOutput, setInputHandler);
        } else {
            this.runInSameVM(configuration, launch, monitor, location, idStamp, runner, commandLine);
        }
        monitor.done();
    }

    private void runInSameVM(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor, IPath location, String idStamp, AntRunner runner, StringBuffer commandLine) throws CoreException {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.ant.ui.antProcess");
        attributes.put("org.eclipse.ant.core.ANT_PROCESS_ID", idStamp);
        AntProcess process = new AntProcess(location.toOSString(), launch, attributes);
        this.setProcessAttributes(process, idStamp, commandLine);
        boolean debug = this.fMode.equals("debug");
        if (debug || AntLaunchingUtil.isLaunchInBackground(configuration)) {
            AntRunner finalRunner = runner;
            Runnable r = () -> {
                try {
                    finalRunner.run((IProgressMonitor)process);
                }
                catch (CoreException e) {
                    this.handleException(e, AntLaunchConfigurationMessages.AntLaunchDelegate_Failure);
                }
                process.terminated();
            };
            Thread background = new Thread(r);
            background.setDaemon(true);
            background.start();
            monitor.worked(1);
            if (configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, null) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, (IProcess)process);
                refresher.startBackgroundRefresh();
            }
        } else {
            try {
                process.setProgressMonitor(monitor);
                runner.run(monitor);
            }
            catch (CoreException e) {
                process.terminated();
                monitor.done();
                this.handleException(e, AntLaunchConfigurationMessages.AntLaunchDelegate_23);
                return;
            }
            process.terminated();
            RefreshUtil.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private AntRunner configureAntRunner(ILaunchConfiguration configuration, IPath location, String baseDir, StringBuffer idProperty, String[] arguments, Map<String, String> userProperties, String[] propertyFiles, String[] targets, URL[] customClasspath, String antHome, boolean setInputHandler) throws CoreException {
        int argLength = 1;
        if (arguments != null) {
            argLength += arguments.length;
        }
        if (baseDir != null && baseDir.length() > 0) {
            ++argLength;
        }
        String[] runnerArgs = new String[argLength];
        if (arguments != null) {
            System.arraycopy(arguments, 0, runnerArgs, 0, arguments.length);
        }
        if (baseDir != null && baseDir.length() > 0) {
            runnerArgs[runnerArgs.length - 2] = BASE_DIR_PREFIX + baseDir;
        }
        runnerArgs[runnerArgs.length - 1] = idProperty.toString();
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(location.toOSString());
        boolean captureOutput = ExternalToolsCoreUtil.getCaptureOutput((ILaunchConfiguration)configuration);
        if (captureOutput) {
            if (this.fMode.equals("debug")) {
                runner.addBuildLogger(ANT_DEBUG_LOGGER_CLASS);
            } else {
                runner.addBuildLogger(ANT_LOGGER_CLASS);
            }
        } else {
            runner.addBuildLogger(NULL_LOGGER_CLASS);
        }
        if (setInputHandler) {
            runner.setInputHandler(INPUT_HANDLER_CLASS);
        } else {
            runner.setInputHandler("");
        }
        runner.setArguments(runnerArgs);
        if (userProperties != null) {
            runner.addUserProperties(userProperties);
        }
        if (propertyFiles != null) {
            runner.setPropertyFiles(propertyFiles);
        }
        if (targets != null) {
            runner.setExecutionTargets(targets);
        }
        if (customClasspath != null) {
            runner.setCustomClasspath(customClasspath);
        }
        if (antHome != null) {
            runner.setAntHome(antHome);
        }
        return runner;
    }

    private void handleException(CoreException e, String title) {
        AntLaunching.log(title, e);
    }

    private void setProcessAttributes(IProcess process, String idStamp, StringBuffer commandLine) {
        if (!this.fUserSpecifiedLogger) {
            process.setAttribute("org.eclipse.ant.core.ANT_PROCESS_ID", idStamp);
        }
        if (commandLine != null) {
            process.setAttribute(IProcess.ATTR_CMDLINE, commandLine.toString());
        }
    }

    private StringBuffer generateCommandLine(IPath location, String[] arguments, Map<String, String> userProperties, String[] propertyFiles, String[] targets, String antHome, String basedir, boolean separateVM, boolean captureOutput, boolean setInputHandler) {
        boolean useGlobalProperties;
        StringBuffer commandLine = new StringBuffer();
        if (!separateVM) {
            commandLine.append("ant");
        }
        if (arguments != null) {
            commandLine.append(' ');
            commandLine.append(DebugPlugin.renderArguments((String[])arguments, null));
        }
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        if (propertyFiles == null) {
            String[] files = prefs.getCustomPropertyFiles();
            int i = 0;
            while (i < files.length) {
                String path = files[i];
                commandLine.append(" -propertyfile \"");
                commandLine.append(path);
                commandLine.append('\"');
                ++i;
            }
        } else {
            int i = 0;
            while (i < propertyFiles.length) {
                String path = propertyFiles[i];
                commandLine.append(" -propertyfile \"");
                commandLine.append(path);
                commandLine.append('\"');
                ++i;
            }
        }
        if (userProperties != null) {
            for (String key : userProperties.keySet()) {
                this.appendProperty(commandLine, key, userProperties.get(key));
            }
        }
        List properties = null;
        properties = !separateVM ? prefs.getProperties() : prefs.getRemoteAntProperties();
        int numberOfEclipseProperties = 2;
        if (userProperties != null && userProperties.get("eclipse.connect.request_port") != null) {
            numberOfEclipseProperties = 3;
        }
        boolean bl = useGlobalProperties = userProperties == null || separateVM && userProperties.size() == numberOfEclipseProperties;
        if (useGlobalProperties) {
            for (Property property : properties) {
                String key = property.getName();
                String value = property.getValue(false);
                if (value == null) continue;
                this.appendProperty(commandLine, key, value);
            }
        }
        if (basedir != null && basedir.length() > 0) {
            this.appendProperty(commandLine, "basedir", basedir);
        }
        if (antHome != null) {
            commandLine.append(" \"-Dant.home=");
            commandLine.append(antHome);
            commandLine.append('\"');
        }
        if (separateVM) {
            if (commandLine.indexOf("-logger") == -1) {
                if (captureOutput) {
                    commandLine.append(" -logger ");
                    if (this.fMode.equals("debug")) {
                        commandLine.append(REMOTE_ANT_DEBUG_LOGGER_CLASS);
                    } else {
                        commandLine.append(REMOTE_ANT_LOGGER_CLASS);
                    }
                }
            } else {
                this.fUserSpecifiedLogger = true;
            }
            if (commandLine.indexOf("-inputhandler") == -1 && setInputHandler) {
                commandLine.append(" -inputhandler ");
                commandLine.append(REMOTE_INPUT_HANDLER_CLASS);
            }
        } else {
            if (commandLine.indexOf("-inputhandler") == -1 && setInputHandler) {
                commandLine.append(" -inputhandler ");
                commandLine.append(INPUT_HANDLER_CLASS);
            }
            if (commandLine.indexOf("-logger") == -1) {
                commandLine.append(" -logger ");
                if (this.fMode.equals("debug")) {
                    commandLine.append(ANT_DEBUG_LOGGER_CLASS);
                } else if (captureOutput) {
                    commandLine.append(ANT_LOGGER_CLASS);
                } else {
                    commandLine.append(NULL_LOGGER_CLASS);
                }
            }
        }
        if (separateVM) {
            this.appendTaskAndTypes(prefs, commandLine);
        }
        commandLine.append(" -buildfile \"");
        commandLine.append(location.toOSString());
        commandLine.append('\"');
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                commandLine.append(" \"");
                commandLine.append(targets[i]);
                commandLine.append('\"');
                ++i;
            }
        }
        return commandLine;
    }

    private void appendTaskAndTypes(AntCorePreferences prefs, StringBuffer commandLine) {
        List tasks = prefs.getRemoteTasks();
        for (Task task : tasks) {
            commandLine.append(" -eclipseTask ");
            String name = ProjectHelper.genComponentName((String)task.getURI(), (String)task.getTaskName());
            commandLine.append(name);
            commandLine.append(',');
            commandLine.append(task.getClassName());
        }
        List types = prefs.getRemoteTypes();
        for (Type type : types) {
            commandLine.append(" -eclipseType ");
            String name = ProjectHelper.genComponentName((String)type.getURI(), (String)type.getTypeName());
            commandLine.append(name);
            commandLine.append(',');
            commandLine.append(type.getClassName());
        }
    }

    private void appendProperty(StringBuffer commandLine, String name, String value) {
        commandLine.append(" \"-D");
        commandLine.append(name);
        commandLine.append('=');
        commandLine.append(value);
        if (value.length() > 0 && value.charAt(value.length() - 1) == File.separatorChar) {
            commandLine.append(File.separatorChar);
        }
        commandLine.append("\"");
    }

    private void runInSeparateVM(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor, String idStamp, String antHome, int port, int requestPort, StringBuffer commandLine, boolean captureOutput, boolean setInputHandler) throws CoreException {
        boolean debug = this.fMode.equals("debug");
        if (captureOutput) {
            String encoding = DebugPlugin.getDefault().getLaunchManager().getEncoding(configuration);
            if (debug) {
                RemoteAntDebugBuildListener listener = new RemoteAntDebugBuildListener(launch, encoding);
                if (requestPort != -1) {
                    listener.startListening(port, requestPort);
                }
            } else if (!this.fUserSpecifiedLogger) {
                RemoteAntBuildListener client = new RemoteAntBuildListener(launch, encoding);
                if (port != -1) {
                    client.startListening(port);
                }
            }
        }
        ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
        this.setDefaultWorkingDirectory(copy);
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, commandLine.toString());
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.launching.remote.InternalAntRunner");
        StringBuffer vmArgs = this.generateVMArguments((ILaunchConfiguration)copy, setInputHandler, antHome);
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.toString());
        copy.setAttribute("org.eclipse.debug.ui.private", true);
        if (copy.getAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false)) {
            this.setDefaultVM(configuration, copy);
        }
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, false);
        if (debug) {
            copy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        }
        if (antHome != null) {
            Map vars = copy.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap(1));
            vars.put("ANT_HOME", antHome);
            copy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, vars);
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        AntJavaLaunchDelegate delegate = new AntJavaLaunchDelegate();
        delegate.preLaunchCheck((ILaunchConfiguration)copy, "run", (IProgressMonitor)subMonitor);
        delegate.launch((ILaunchConfiguration)copy, "run", launch, (IProgressMonitor)subMonitor);
        final IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            this.setProcessAttributes(processes[i], idStamp, null);
            ++i;
        }
        if (AntLaunchingUtil.isLaunchInBackground((ILaunchConfiguration)copy)) {
            if (configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, null) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, processes[0]);
                refresher.startBackgroundRefresh();
            }
        } else {
            final boolean[] terminated = new boolean[]{launch.isTerminated()};
            IDebugEventSetListener listener = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    int i = 0;
                    while (i < events.length) {
                        DebugEvent event = events[i];
                        int j = 0;
                        int numProcesses = processes.length;
                        while (j < numProcesses) {
                            if (event.getSource() == processes[j] && event.getKind() == 8) {
                                terminated[0] = true;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            };
            DebugPlugin.getDefault().addDebugEventListener(listener);
            monitor.subTask(AntLaunchConfigurationMessages.AntLaunchDelegate_28);
            while (!monitor.isCanceled() && !terminated[0]) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            DebugPlugin.getDefault().removeDebugEventListener(listener);
            if (!monitor.isCanceled()) {
                RefreshUtil.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
            }
        }
    }

    private void setDefaultVM(ILaunchConfiguration configuration, ILaunchConfigurationWorkingCopy copy) {
        try {
            JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        }
        catch (CoreException coreException) {
            IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, defaultVMInstall.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, defaultVMInstall.getVMInstallType().getId());
        }
    }

    private StringBuffer generateVMArguments(ILaunchConfiguration config, boolean setInputHandler, String antHome) {
        String swtLocation;
        StringBuffer vmArgs = new StringBuffer();
        try {
            String configArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (configArgs != null) {
                vmArgs.append(configArgs);
                vmArgs.append(' ');
            }
        }
        catch (CoreException coreException) {}
        if (antHome != null) {
            vmArgs.append("-Dant.home=\"");
            vmArgs.append(antHome);
            vmArgs.append("\" ");
            File antLibDir = new File(antHome, "lib");
            vmArgs.append("-Dant.library.dir=\"");
            vmArgs.append(antLibDir.getAbsolutePath());
            vmArgs.append('\"');
        }
        if (setInputHandler && (swtLocation = this.getSWTLibraryLocation()) != null) {
            vmArgs.append(" -Djava.library.path=\"");
            String javaLibPath = System.getProperty("java.library.path");
            javaLibPath = this.stripUnescapedQuotes(javaLibPath);
            if (javaLibPath != null) {
                vmArgs.append(javaLibPath);
                if (vmArgs.charAt(vmArgs.length() - 1) != File.pathSeparatorChar) {
                    vmArgs.append(File.pathSeparatorChar);
                }
            }
            vmArgs.append(swtLocation);
            vmArgs.append('\"');
        }
        return vmArgs;
    }

    private String stripUnescapedQuotes(String javaLibPath) {
        StringBuffer buf = new StringBuffer(javaLibPath.length());
        int i = 0;
        while (i < javaLibPath.length()) {
            char c = javaLibPath.charAt(i);
            switch (c) {
                case '\"': {
                    if (i == 0 || javaLibPath.charAt(i - 1) != '\\') break;
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] projects;
        String scopeKey = ATTR_BUILD_SCOPE;
        String refKey = ATTR_INCLUDE_REFERENCED_PROJECTS;
        if (configuration.hasAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE") || configuration.hasAttribute("org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS")) {
            scopeKey = "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE";
            refKey = "org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS";
        }
        if ((projects = ExternalToolsCoreUtil.getBuildProjects((ILaunchConfiguration)configuration, (String)scopeKey)) == null) {
            return null;
        }
        boolean isRef = ExternalToolsCoreUtil.isIncludeReferencedProjects((ILaunchConfiguration)configuration, (String)refKey);
        if (isRef) {
            return this.computeReferencedBuildOrder(projects);
        }
        return this.computeBuildOrder(projects);
    }

    private String getSWTLibraryLocation() {
        if (fgSWTLibraryLocation == null) {
            List fragmentWires;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.swt");
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List list = fragmentWires = wiring == null ? Collections.emptyList() : wiring.getProvidedWires("osgi.wiring.host");
            if (fragmentWires.isEmpty()) {
                return null;
            }
            Bundle fragBundle = ((BundleWire)fragmentWires.get(0)).getRequirer().getBundle();
            try {
                URL url = FileLocator.toFileURL((URL)fragBundle.getEntry("/"));
                try {
                    Path path = new Path(URIUtil.toURL((URI)URIUtil.toURI((URL)url)).getPath());
                    path = path.removeTrailingSeparator();
                    fgSWTLibraryLocation = path.toOSString();
                }
                catch (URISyntaxException e) {
                    AntLaunching.log(e);
                }
            }
            catch (IOException iOException) {}
        }
        return fgSWTLibraryLocation;
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        return breakpointManager.getBreakpoints("org.eclipse.ant.ui.debug");
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if ("org.eclipse.ui.externaltools.builder".equals(configuration.getType().getCategory())) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }

    private void setDefaultWorkingDirectory(ILaunchConfigurationWorkingCopy copy) {
        try {
            String wd = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
            if (wd == null) {
                wd = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)copy).removeLastSegments(1).toOSString();
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, wd);
            }
        }
        catch (CoreException e) {
            AntLaunching.log(e.getStatus());
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new AntLaunch(configuration, mode, null);
    }
}

