/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.util.ArrayList;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.core.databinding";
    private volatile ServiceTracker _frameworkLogTracker;

    public void start(BundleContext context) throws Exception {
        this._frameworkLogTracker = new ServiceTracker(context, FrameworkLog.class.getName(), null);
        this._frameworkLogTracker.open();
        Policy.setLog(status -> {
            FrameworkLog log;
            ServiceTracker frameworkLogTracker = this._frameworkLogTracker;
            FrameworkLog frameworkLog = log = frameworkLogTracker == null ? null : (FrameworkLog)frameworkLogTracker.getService();
            if (log != null) {
                log.log(this.createLogEntry(status));
            } else {
                System.err.println(String.valueOf(status.getPlugin()) + " - " + status.getCode() + " - " + status.getMessage());
                if (status.getException() != null) {
                    status.getException().printStackTrace(System.err);
                }
            }
        });
    }

    FrameworkLogEntry createLogEntry(IStatus status) {
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(this.createLogEntry(coreStatus));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n2 = iStatusArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IStatus child = iStatusArray[n3];
                childlist.add(this.createLogEntry(child));
                ++n3;
            }
        }
        FrameworkLogEntry[] children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, children);
    }

    public void stop(BundleContext context) throws Exception {
        if (this._frameworkLogTracker != null) {
            this._frameworkLogTracker.close();
            this._frameworkLogTracker = null;
        }
    }
}

