/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.BundleFinder;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
DebugOptionsListener {
    public static final String PI_WORKBENCH = "org.eclipse.e4.ui.workbench";
    private static Activator activator;
    private BundleContext context;
    private ServiceTracker<Location, Location> locationTracker;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker;
    private ServiceTracker<LogService, LogService> logTracker;
    private BundleTracker<List<Bundle>> resolvedBundles;
    private final BundleFinder bundleFinder = new BundleFinder();
    private DebugTrace trace;

    public static Activator getDefault() {
        return activator;
    }

    public Bundle getBundle() {
        return this.context.getBundle();
    }

    public Bundle getBundleForName(String bundleName) {
        return this.bundleFinder.findBundle(bundleName);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        activator = this;
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", PI_WORKBENCH);
        context.registerService(DebugOptionsListener.class, (Object)this, props);
        this.resolvedBundles = new BundleTracker(context, 60, (BundleTrackerCustomizer)this.bundleFinder);
        this.resolvedBundles.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.locationTracker != null) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        if (this.debugTracker != null) {
            this.trace = null;
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.resolvedBundles != null) {
            this.resolvedBundles.close();
            this.resolvedBundles = null;
        }
    }

    public void optionsChanged(DebugOptions options) {
        this.trace = options.newDebugTrace(PI_WORKBENCH);
        Policy.DEBUG = options.getBooleanOption("org.eclipse.e4.ui.workbench/debug", false);
        Policy.DEBUG_CMDS = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/commands", false);
        Policy.DEBUG_CONTEXTS = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/eclipse.context", false);
        Policy.DEBUG_CONTEXTS_VERBOSE = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/eclipse.context.verbose", false);
        Policy.DEBUG_MENUS = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/menus", false);
        Policy.DEBUG_RENDERER = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/renderer", false);
        Policy.DEBUG_WORKBENCH = options.getBooleanOption("org.eclipse.e4.ui.workbench/trace/workbench", false);
    }

    public DebugTrace getTrace() {
        return this.trace;
    }

    public static void trace(String option, String msg, Throwable error) {
        activator.getTrace().trace(option, msg, error);
    }

    public LogService getLogService() {
        LogService logService = null;
        if (this.logTracker != null) {
            logService = (LogService)this.logTracker.getService();
        } else if (this.context != null) {
            this.logTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logTracker.open();
            logService = (LogService)this.logTracker.getService();
        }
        if (logService == null) {
            throw new IllegalStateException("No LogService is available.");
        }
        return logService;
    }

    public static void log(int level, String message) {
        LogService logService = activator.getLogService();
        if (logService != null) {
            logService.log(level, message);
        }
    }

    public static void log(int level, String message, Throwable exception) {
        LogService logService = activator.getLogService();
        if (logService != null) {
            logService.log(level, message, exception);
        }
    }
}

