/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

public class JrtPackageFragmentRoot
extends JarPackageFragmentRoot
implements IModulePathEntry {
    String moduleName;

    protected JrtPackageFragmentRoot(IPath jrtPath, String moduleName, JavaProject project) {
        super(jrtPath, project);
        this.moduleName = moduleName;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        final HashtableOfArrayToObject rawPackageInfo = new HashtableOfArrayToObject();
        rawPackageInfo.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
        try {
            JRTUtil.walkModuleImage(this.jarPath.toFile(), new JRTUtil.JrtFileVisitor<Path>(){

                @Override
                public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                    JrtPackageFragmentRoot.this.initRawPackageInfo(rawPackageInfo, dir.toString(), true, "1.8");
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, Path mod, BasicFileAttributes attrs) throws IOException {
                    JrtPackageFragmentRoot.this.initRawPackageInfo(rawPackageInfo, path.toString(), false, "1.8");
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitModule(Path mod) throws IOException {
                    if (!JrtPackageFragmentRoot.this.moduleName.equals(mod.toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            }, JRTUtil.NOTIFY_ALL);
        }
        catch (IOException iOException) {
            Util.log(4, "Error reading modules" + this.toStringWithAncestors());
        }
        info.setChildren(this.createChildren(rawPackageInfo));
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        return true;
    }

    @Override
    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) throws JavaModelException {
        IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
        String encoding = entry == null ? null : ((ClasspathEntry)entry).getSourceAttachmentEncoding();
        IModule mod = this.getModule();
        String modName = mod == null ? null : new String(mod.name());
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? modName : rootPath.toOSString(), this.getJavaProject().getOptions(true), encoding);
        return mapper;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JrtPackageFragmentRoot) {
            JrtPackageFragmentRoot other = (JrtPackageFragmentRoot)o;
            return this.moduleName.equals(other.moduleName) && this.jarPath.equals((Object)other.jarPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.moduleName;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public int hashCode() {
        return this.jarPath.hashCode() + this.moduleName.hashCode();
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<module:").append(this.moduleName).append(">");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    public IModule getModule() {
        IModuleDescription desc = this.getModuleDescription();
        if (desc != null) {
            try {
                return (IModule)((JavaElement)((Object)desc)).getElementInfo();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)((Object)e));
            }
        }
        return null;
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String requestedModuleName) {
        if (requestedModuleName != null && !requestedModuleName.equals(this.moduleName)) {
            return null;
        }
        if (this.getPackageFragment(qualifiedPackageName).exists()) {
            return new char[][]{requestedModuleName.toCharArray()};
        }
        return null;
    }
}

