/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaAnnotationHandler;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.PDEHTMLHelper;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.core.util.SchemaUtil;
import org.eclipse.pde.internal.core.util.XMLComponentRegistry;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLInsertionComputer;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionTreeSelectionPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.pde.internal.ui.wizards.templates.NewExtensionTemplateWizard;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.helpers.DefaultHandler;

public class PointSelectionPage
extends BaseWizardSelectionPage {
    private TableViewer fPointListViewer;
    private TableViewer fTemplateViewer;
    private IPluginModelBase fModel;
    private Button fFilterCheck;
    private IPluginExtensionPoint fCurrentPoint;
    private HashSet<?> fAvailableImports;
    private IProject fProject;
    private Label fTemplateLabel;
    private ExtensionTreeSelectionPage fWizardsPage;
    private IPluginExtension fNewExtension;
    private WizardCollectionElement fTemplateCollection;
    private WizardCollectionElement fWizardCollection;
    private NewExtensionWizard fWizard;
    private Text fFilterText;
    private WildcardFilter fWildCardFilter;
    private Text fPointDescription;
    private Link fDescLink;
    private Browser fPointDescBrowser;

    public PointSelectionPage(IProject project, IPluginModelBase model, WizardCollectionElement element, WizardCollectionElement templates, NewExtensionWizard wizard) {
        super("pointSelectionPage", PDEUIMessages.NewExtensionWizard_PointSelectionPage_title);
        this.fModel = model;
        this.fWizardCollection = element;
        this.fTemplateCollection = templates;
        this.fWizard = wizard;
        this.fProject = project;
        this.fWildCardFilter = new WildcardFilter();
        this.fAvailableImports = PluginSelectionDialog.getExistingImports(model, true);
        this.setTitle(PDEUIMessages.NewExtensionWizard_PointSelectionPage_title);
        this.setDescription(PDEUIMessages.NewExtensionWizard_PointSelectionPage_desc);
    }

    public void createControl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0x800000);
        TabItem firstTab = new TabItem(tabFolder, 0);
        firstTab.setText(PDEUIMessages.PointSelectionPage_tab1);
        TabItem secondTab = new TabItem(tabFolder, 0);
        secondTab.setText(PDEUIMessages.PointSelectionPage_tab2);
        secondTab.setControl(this.createWizardsPage((Composite)tabFolder));
        tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTabSelection(tabFolder.getSelectionIndex())));
        Composite outerContainer = new Composite((Composite)tabFolder, 0);
        firstTab.setControl((Control)outerContainer);
        GridLayout layout = new GridLayout();
        outerContainer.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        outerContainer.setLayoutData((Object)gd);
        Composite pointContainer = new Composite(outerContainer, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pointContainer.setLayout((Layout)layout);
        gd = new GridData(1808);
        pointContainer.setLayoutData((Object)gd);
        Composite labelContainer = new Composite(pointContainer, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labelContainer.setLayout((Layout)layout);
        labelContainer.setLayoutData((Object)new GridData(768));
        Label filterLabel = new Label(labelContainer, 0);
        filterLabel.setText(PDEUIMessages.NewExtensionWizard_PointSelectionPage_availExtPoints_label);
        gd = new GridData();
        gd.verticalAlignment = 2;
        filterLabel.setLayoutData((Object)gd);
        this.fFilterText = new Text(labelContainer, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(768));
        this.fFilterText.addModifyListener(e -> {
            this.fWildCardFilter.setMatchText(this.fFilterText.getText());
            this.fPointListViewer.refresh();
        });
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    PointSelectionPage.this.fPointListViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterCheck = new Button(outerContainer, 32);
        this.fFilterCheck.setText(PDEUIMessages.NewExtensionWizard_PointSelectionPage_filterCheck);
        gd = new GridData(768);
        this.fFilterCheck.setLayoutData((Object)gd);
        this.fFilterCheck.setSelection(true);
        this.fFilterCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.fPointListViewer.refresh()));
        this.fPointListViewer = new TableViewer(pointContainer, 2816);
        this.fPointListViewer.setContentProvider((IContentProvider)new PointContentProvider());
        this.fPointListViewer.setLabelProvider((IBaseLabelProvider)new PointLabelProvider());
        this.fPointListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fPointListViewer.addDoubleClickListener(event -> {
            if (this.canFinish()) {
                this.fWizard.performFinish();
                this.fWizard.getShell().close();
                this.fWizard.dispose();
                this.fWizard.setContainer(null);
            }
        });
        this.fPointListViewer.addFilter((ViewerFilter)this.fWildCardFilter);
        this.fPointListViewer.setComparator(ListUtil.NAME_COMPARATOR);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.fPointListViewer.getTable().setLayoutData((Object)gd);
        Composite templateComposite = new Composite(outerContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        templateComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        templateComposite.setLayoutData((Object)gd);
        this.fDescLink = new Link(templateComposite, 0);
        this.fDescLink.setText(NLS.bind((String)PDEUIMessages.PointSelectionPage_extPointDesc, (Object)""));
        this.fDescLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.fCurrentPoint != null) {
                new ShowDescriptionAction(this.fCurrentPoint, true).run();
            }
        }));
        this.fDescLink.setLayoutData((Object)new GridData(768));
        Browser c = null;
        Composite comp = new Composite(templateComposite, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        try {
            c = this.fPointDescBrowser = new Browser(comp, 0);
        }
        catch (SWTError sWTError) {}
        if (c == null) {
            this.fPointDescription = new Text(comp, 586);
            c = this.fPointDescription;
        }
        this.setPointDescriptionText(PDEUIMessages.NewExtensionWizard_PointSelectionPage_extPointDescription);
        gd = new GridData(768);
        gd.heightHint = 80;
        c.setLayoutData((Object)gd);
        this.fTemplateLabel = new Label(templateComposite, 64);
        this.fTemplateLabel.setText(PDEUIMessages.NewExtensionWizard_PointSelectionPage_contributedTemplates_title);
        gd = new GridData(768);
        this.fTemplateLabel.setLayoutData((Object)gd);
        SashForm templateSashForm = new SashForm(templateComposite, 256);
        templateSashForm.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.heightHint = 80;
        templateSashForm.setLayoutData((Object)gd);
        Composite wizardComposite = new Composite((Composite)templateSashForm, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wizardComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        wizardComposite.setLayoutData((Object)gd);
        this.fTemplateViewer = new TableViewer(wizardComposite, 2816);
        this.fTemplateViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTemplateViewer.setLabelProvider((IBaseLabelProvider)ElementLabelProvider.INSTANCE);
        this.fTemplateViewer.setComparator(ListUtil.NAME_COMPARATOR);
        this.fTemplateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        gd = new GridData(1808);
        this.fTemplateViewer.getTable().setLayoutData((Object)gd);
        TableItem[] selection = this.fPointListViewer.getTable().getSelection();
        if (selection != null && selection.length > 0) {
            this.fTemplateViewer.setInput((Object)selection[0]);
        }
        this.fTemplateViewer.addDoubleClickListener(event -> {
            if (this.canFlipToNextPage()) {
                this.advanceToNextPage();
            }
        });
        Composite descriptionComposite = new Composite((Composite)templateSashForm, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        descriptionComposite.setLayoutData((Object)gd);
        this.createDescriptionIn(descriptionComposite);
        this.initialize();
        this.setControl((Control)tabFolder);
        Dialog.applyDialogFont((Control)outerContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)outerContainer.getParent(), "org.eclipse.pde.doc.user.add_extensions_schema_based");
    }

    private Control createWizardsPage(Composite parent) {
        this.fWizardsPage = new ExtensionTreeSelectionPage(this.fWizardCollection, null, PDEUIMessages.PointSelectionPage_categories);
        this.fWizardsPage.createControl(parent);
        this.fWizardsPage.setWizard((IWizard)this.fWizard);
        this.fWizardsPage.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.fWizardsPage.init(this.fProject, this.fModel.getPluginBase());
        return this.fWizardsPage.getControl();
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    public boolean canFinish() {
        IStructuredSelection selection;
        if (this.fTemplateViewer != null && !(selection = this.fTemplateViewer.getStructuredSelection()).isEmpty()) {
            return false;
        }
        return this.fPointListViewer != null && !(selection = this.fPointListViewer.getStructuredSelection()).isEmpty();
    }

    public void dispose() {
        this.fWizardsPage.dispose();
        super.dispose();
    }

    public boolean finish() {
        String point = IdUtil.getFullId((IPluginExtensionPoint)this.fCurrentPoint, (IPluginModelBase)this.fModel);
        try {
            IPluginExtension extension = this.fModel.getFactory().createExtension();
            extension.setPoint(point);
            this.fModel.getPluginBase().add(extension);
            ISchemaElement schemaElement = null;
            Object object = extension.getSchema();
            if (object != null && object instanceof Schema) {
                Schema schema = (Schema)object;
                if (extension instanceof PluginExtensionNode) {
                    String elementName = ((PluginExtensionNode)extension).getXMLTagName();
                    schemaElement = schema.findElement(elementName);
                }
                if (schemaElement != null) {
                    XMLInsertionComputer.computeInsertion(schemaElement, (IPluginParent)extension);
                }
            }
            String pluginID = this.fCurrentPoint.getPluginBase().getId();
            if (!(this.fCurrentPoint instanceof PluginExtensionPointNode) && !this.fAvailableImports.contains(pluginID) && !(this.fCurrentPoint.getPluginBase() instanceof IFragment) && MessageDialog.openQuestion((Shell)this.getShell(), (String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_dependencyTitle, (String)NLS.bind((String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_dependencyMessage, (Object[])new String[]{pluginID, this.fCurrentPoint.getId()}))) {
                IPluginImport importNode = this.fModel.getPluginFactory().createImport();
                importNode.setId(pluginID);
                this.fModel.getPluginBase().add(importNode);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    public IPluginExtension getNewExtension() {
        return this.fNewExtension;
    }

    protected void initialize() {
        this.fPointListViewer.addFilter((ViewerFilter)new PointFilter());
        this.fPointListViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fPointListViewer.getTable().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (!ssel.isEmpty()) {
                Object element = ssel.getFirstElement();
                if (element instanceof WizardElement) {
                    this.handleTemplateSelection((WizardElement)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    this.handlePointSelection((IPluginExtensionPoint)element);
                }
            } else {
                this.setDescription("");
                this.setDescriptionText("");
                this.fTemplateLabel.setText(PDEUIMessages.NewExtensionWizard_PointSelectionPage_contributedTemplates_title);
                this.setPointDescriptionText(PDEUIMessages.PointSelectionPage_noDescAvailable);
                this.fDescLink.setText(NLS.bind((String)PDEUIMessages.PointSelectionPage_extPointDesc, (Object)""));
                this.setSelectedNode(null);
                this.setPageComplete(false);
            }
            this.getContainer().updateButtons();
        }
    }

    private void handleTemplateSelection(WizardElement element) {
        this.setSelectedNode(this.createWizardNode(element));
        this.setDescriptionText(element.getDescription());
        this.setDescription(NLS.bind((String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_templateDescription, (Object)element.getLabel()));
        this.setPageComplete(false);
    }

    private void handlePointSelection(IPluginExtensionPoint element) {
        SchemaRegistry reg;
        ISchema schema;
        this.fCurrentPoint = element;
        this.fTemplateViewer.setInput((Object)this.fCurrentPoint);
        this.fTemplateViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        String fullPointID = IdUtil.getFullId((IPluginExtensionPoint)this.fCurrentPoint, (IPluginModelBase)this.fModel);
        String description = XMLComponentRegistry.Instance().getDescription(fullPointID, 2);
        String name = XMLComponentRegistry.Instance().getName(fullPointID, 2);
        URL url = null;
        if (description == null || name == null) {
            url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)this.fCurrentPoint, (IPluginModelBase)this.fModel);
        }
        if (url != null) {
            SchemaAnnotationHandler handler = new SchemaAnnotationHandler();
            SchemaUtil.parseURL((URL)url, (DefaultHandler)handler);
            description = handler.getDescription();
            name = handler.getName();
        }
        if (description == null) {
            this.setPointDescriptionText(PDEUIMessages.PointSelectionPage_noDescAvailable);
        } else {
            this.setPointDescriptionText(description);
        }
        if (name == null) {
            name = fullPointID;
        }
        if ((schema = (reg = PDECore.getDefault().getSchemaRegistry()).getSchema(this.fCurrentPoint.getFullId())) != null && schema.isDeperecated()) {
            this.setMessage(NLS.bind((String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_pluginDescription_deprecated, (Object)name), 2);
        } else {
            this.setMessage(null);
            this.setDescription(NLS.bind((String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_pluginDescription, (Object)name));
        }
        this.setDescriptionText("");
        this.fTemplateLabel.setText(NLS.bind((String)PDEUIMessages.NewExtensionWizard_PointSelectionPage_contributedTemplates_label, (Object)name.toLowerCase(Locale.ENGLISH)));
        this.fDescLink.setText(NLS.bind((String)PDEUIMessages.PointSelectionPage_extPointDesc, (Object)name));
        this.setSelectedNode(null);
        this.setPageComplete(true);
        XMLComponentRegistry.Instance().putDescription(fullPointID, description, 2);
        XMLComponentRegistry.Instance().putName(fullPointID, name, 2);
    }

    private void updateTabSelection(int index) {
        if (index == 0) {
            IStructuredSelection selection = this.fTemplateViewer.getStructuredSelection();
            if (!selection.isEmpty()) {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fTemplateViewer, (ISelection)selection));
            } else {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fPointListViewer, (ISelection)this.fPointListViewer.getStructuredSelection()));
            }
            this.fFilterText.setFocus();
        } else {
            ISelectionProvider provider = this.fWizardsPage.getSelectionProvider();
            this.selectionChanged(new SelectionChangedEvent(provider, provider.getSelection()));
        }
    }

    @Override
    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            @Override
            public IBasePluginWizard createWizard() throws CoreException {
                IExtensionWizard wizard = this.createWizard(this.wizardElement);
                if (wizard == null) {
                    throw new CoreException((IStatus)new Status(4, this.wizardElement.getConfigurationElement().getNamespaceIdentifier(), PDEUIMessages.PointSelectionPage_cannotFindTemplate));
                }
                wizard.init(PointSelectionPage.this.fProject, PointSelectionPage.this.fModel);
                return wizard;
            }

            protected IExtensionWizard createWizard(WizardElement element) throws CoreException {
                if (element.isTemplate()) {
                    IConfigurationElement template = element.getTemplateElement();
                    if (template == null) {
                        return null;
                    }
                    ITemplateSection section = (ITemplateSection)template.createExecutableExtension("class");
                    return new NewExtensionTemplateWizard(section);
                }
                return (IExtensionWizard)element.createExecutableExtension();
            }
        };
    }

    public void checkModel() {
        IWizardNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        IWizard wizard = node.getWizard();
        if (wizard instanceof NewExtensionTemplateWizard && ((NewExtensionTemplateWizard)wizard).updatedDependencies() && MessageDialog.openQuestion((Shell)this.getShell(), (String)PDEUIMessages.PointSelectionPage_newDepFound, (String)PDEUIMessages.PointSelectionPage_newDepMessage)) {
            this.fWizard.getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fFilterText.setFocus();
        }
        super.setVisible(visible);
    }

    private void setPointDescriptionText(String text) {
        if (this.fPointDescBrowser != null) {
            StringBuilder desc = new StringBuilder();
            HTMLPrinter.insertPageProlog((StringBuilder)desc, (int)0, (URL)TextUtil.getJavaDocStyleSheerURL());
            desc.append(text);
            HTMLPrinter.addPageEpilog((StringBuilder)desc);
            this.fPointDescBrowser.setText(desc.toString());
        } else {
            this.fPointDescription.setText(PDEHTMLHelper.stripTags((String)text));
        }
    }

    class PointContentProvider
    implements IStructuredContentProvider {
        PointContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IPluginExtensionPoint[] points;
            IPluginModelBase[] plugins;
            ArrayList<IPluginExtensionPoint> extPoints = new ArrayList<IPluginExtensionPoint>();
            IPluginModelBase[] iPluginModelBaseArray = plugins = PluginRegistry.getActiveModels();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase plugin = iPluginModelBaseArray[n2];
                IPluginExtensionPoint[] points2 = plugin.getPluginBase().getExtensionPoints();
                String id = plugin.getPluginBase().getId();
                if (!id.equals(PointSelectionPage.this.fModel.getPluginBase().getId())) {
                    IPluginExtensionPoint[] iPluginExtensionPointArray = points2;
                    int n3 = points2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginExtensionPoint point = iPluginExtensionPointArray[n4];
                        extPoints.add(point);
                        ++n4;
                    }
                }
                ++n2;
            }
            IPluginExtensionPoint[] iPluginExtensionPointArray = points = PointSelectionPage.this.fModel.getPluginBase().getExtensionPoints();
            int n5 = points.length;
            n = 0;
            while (n < n5) {
                IPluginExtensionPoint point = iPluginExtensionPointArray[n];
                extPoints.add(point);
                ++n;
            }
            return extPoints.toArray();
        }
    }

    class PointFilter
    extends ViewerFilter {
        PointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!PointSelectionPage.this.fFilterCheck.getSelection()) {
                return true;
            }
            IPluginExtensionPoint point = (IPluginExtensionPoint)element;
            if (point instanceof PluginExtensionPointNode) {
                return true;
            }
            return PointSelectionPage.this.fAvailableImports.contains(point.getPluginBase().getId());
        }
    }

    class PointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PointLabelProvider() {
        }

        public String getText(Object obj) {
            return this.getColumnText(obj, 0);
        }

        public String getColumnText(Object obj, int index) {
            IPluginExtensionPoint extPoint = (IPluginExtensionPoint)obj;
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            if (provider.isFullNameModeEnabled()) {
                return provider.getText(extPoint);
            }
            return IdUtil.getFullId((IPluginExtensionPoint)extPoint, (IPluginModelBase)PointSelectionPage.this.fModel);
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            IPluginExtensionPoint exp = (IPluginExtensionPoint)obj;
            if (((TemplateContentProvider)PointSelectionPage.this.fTemplateViewer.getContentProvider()).getElements(exp).length > 0) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_NEWEXP_WIZ_TOOL, 0);
            }
            int flags = 0;
            SchemaRegistry reg = PDECore.getDefault().getSchemaRegistry();
            ISchema schema = reg.getSchema(exp.getFullId());
            if (schema != null && schema.isDeperecated()) {
                PDEPlugin.getDefault().getLabelProvider();
                flags = 2;
            }
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ, flags);
        }
    }

    class TemplateContentProvider
    implements IStructuredContentProvider {
        TemplateContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint point = (IPluginExtensionPoint)inputElement;
                String pointID = IdUtil.getFullId((IPluginExtensionPoint)point, (IPluginModelBase)PointSelectionPage.this.fModel);
                ArrayList<Object> result = new ArrayList<Object>();
                if (PointSelectionPage.this.fTemplateCollection.getWizards() != null) {
                    Object[] wizards;
                    Object[] objectArray = wizards = PointSelectionPage.this.fTemplateCollection.getWizards().getChildren();
                    int n = wizards.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object wizardObject = objectArray[n2];
                        String wizardContributorId = ((WizardElement)wizardObject).getContributingId();
                        if (wizardContributorId != null && pointID != null && wizardObject instanceof WizardElement && wizardContributorId.equals(pointID)) {
                            result.add(wizardObject);
                        }
                        ++n2;
                    }
                    return result.toArray();
                }
            }
            return new Object[0];
        }
    }

    class WildcardFilter
    extends ViewerFilter {
        private String wMatch = "*";

        WildcardFilter() {
        }

        protected void setMatchText(String match) {
            if (match.indexOf("*") != 0 & match.indexOf("?") != 0 & match.indexOf(".") != 0) {
                match = "*" + match;
            }
            this.wMatch = String.valueOf(match) + "*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String text = ((PointLabelProvider)PointSelectionPage.this.fPointListViewer.getLabelProvider()).getColumnText(element, 0);
            Pattern pattern = null;
            try {
                pattern = PatternConstructor.createPattern((String)this.wMatch, (boolean)false);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
            return pattern != null && pattern.matcher(text.subSequence(0, text.length())).matches();
        }
    }
}

