/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.javaeditor;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints.BreakpointsView;
import org.eclipse.reddeer.eclipse.jdt.ui.javaeditor.JavaEditor;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@CleanWorkspaceRequirement.CleanWorkspace
@RunWith(value=RedDeerSuite.class)
public class JavaEditorTest {
    public static final String PROJECT_NAME = "java_project";
    public static final String CLASS_NAME = "Demo";

    @BeforeClass
    public static void prepareJavaProject() {
        JavaProjectWizard javaProjectWizard = new JavaProjectWizard();
        javaProjectWizard.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)javaProjectWizard).setProjectName(PROJECT_NAME);
        javaProjectWizard.finish();
        NewClassCreationWizard classCreationWizard = new NewClassCreationWizard();
        classCreationWizard.open();
        new NewClassWizardPage((ReferencedComposite)classCreationWizard).setName(CLASS_NAME);
        new NewClassWizardPage((ReferencedComposite)classCreationWizard).setStaticMainMethod(true);
        classCreationWizard.finish();
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        javaEditor.insertLine(6, "\t\tSystem.out.println(\"Hello World\");");
        javaEditor.save();
    }

    @AfterClass
    public static void cleanWorkspace() {
        new CleanWorkspaceRequirement().fulfill();
    }

    @Before
    public void removeAllBreakpoints() {
        new BreakpointsView().open();
        new BreakpointsView().removeAllBreakpoints();
    }

    @Test
    public void testAddingClassBreakpoint() {
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        javaEditor.addBreakpoint(javaEditor.getLineOfText("public class Demo"));
        JavaEditorTest.assertBreakpoint(CLASS_NAME, "public class Demo");
    }

    @Test
    public void testAddingMethodBreakpoint() {
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        javaEditor.addBreakpoint(javaEditor.getLineOfText("public static void main"));
        JavaEditorTest.assertBreakpoint("Demo [entry] - main(String[])", "public static void main");
    }

    @Test
    public void testAddingLineBreakpoint() {
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        javaEditor.addBreakpoint(javaEditor.getLineOfText("System.out.println"));
        JavaEditorTest.assertBreakpoint("Demo [line: 7] - main(String[])", "System.out.println");
    }

    @Test
    public void testRemovingBreakpoint() {
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        javaEditor.addBreakpoint(javaEditor.getLineOfText("public class Demo"));
        javaEditor.addBreakpoint(javaEditor.getLineOfText("public static void main"));
        javaEditor.addBreakpoint(javaEditor.getLineOfText("System.out.println"));
        Assert.assertEquals((long)3L, (long)javaEditor.getBreakpoints().size());
        javaEditor.removeBreakpoint(javaEditor.getLineOfText("public static void main"));
        Assert.assertEquals((long)2L, (long)javaEditor.getBreakpoints().size());
        Assert.assertNull((Object)javaEditor.getBreakpoint(javaEditor.getLineOfText("public static void main")));
    }

    private static void assertBreakpoint(String label, String text) {
        JavaEditor javaEditor = new JavaEditor("Demo.java");
        try {
            Assert.assertEquals((Object)label, (Object)javaEditor.getBreakpoint(javaEditor.getLineOfText(text)));
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        Assert.assertEquals((long)1L, (long)javaEditor.getBreakpoints().size());
        new BreakpointsView().open();
        Assert.assertTrue((boolean)new BreakpointsView().isBreakpointAvailable(label));
    }
}

