/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints.Breakpoint;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class BreakpointsView
extends WorkbenchView {
    public BreakpointsView() {
        super("Breakpoints");
    }

    public void addJavaExceptionBreakpoint(String exception) {
        log.info("Adding java exception breakpoint '" + exception + "'");
        this.open();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Add Java Exception Breakpoint").click();
        new DefaultShell("Add Java Exception Breakpoint");
        new DefaultText().setText(exception);
        new WaitUntil((WaitCondition)new ControlIsEnabled((Control)new OkButton()), TimePeriod.LONG);
        new OkButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Add Java Exception Breakpoint"));
    }

    public boolean isBreakpointAvailable(String label) {
        this.open();
        return this.getBreakpoint(label) != null;
    }

    public Breakpoint getBreakpoint(String label) {
        log.info("Accessing breakpoints in Breakpoints view");
        this.open();
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        List items = new DefaultTree((ReferencedComposite)this.cTabItem).getItems();
        for (TreeItem item : items) {
            log.debug("\tfound: " + item.getText());
            if (!item.getText().contains(label)) continue;
            return new Breakpoint(item);
        }
        return null;
    }

    public void removeAllBreakpoints() {
        log.info("Removing all breakpoints from Breakpoints view");
        this.open();
        if (new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Remove All Breakpoints").isEnabled()) {
            new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Remove All Breakpoints").click();
            new DefaultShell("Remove All Breakpoints").setFocus();
            new PushButton("Yes").click();
        }
    }

    public void importBreakpoints(String path) {
        log.info("Importing breakpoints from '" + path + "'");
        this.open();
        new DefaultTree((ReferencedComposite)this.cTabItem).setFocus();
        new ContextMenuItem(new String[]{"Import Breakpoints..."}).select();
        new DefaultShell("Import Breakpoints");
        new LabeledText("From file:").setText(path);
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Import Breakpoints"));
    }
}

